/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.widget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.widget.CorrectionCoefficient;
import org.intermine.web.logic.widget.PopulationInfo;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;

public class GeneLengthCorrectionCoefficient
implements CorrectionCoefficient {
    private WidgetConfig config;
    private ObjectStore os;
    private InterMineBag bag;
    private String ids;
    private Integer countItemsWithLengthNotNull = null;
    private static final String GENE_LENGTH = "gene_length";
    private static final String GENE_LENGTH_CORRECTION = "gene_length_correction";
    private static final String PERCENTAGE_GENE_LENGTH_NOT_NULL = "percentage_gene_length_not_null";
    private static final String PATH_QUERY_GENE_LENGTH_NULL = "pathQueryGeneLengthNull";

    public GeneLengthCorrectionCoefficient(WidgetConfig config, ObjectStore os, InterMineBag bag, String ids) {
        this.config = config;
        this.os = os;
        this.bag = bag;
        this.ids = ids;
    }

    public boolean isSelected(String correctionCoefficientInput) {
        return correctionCoefficientInput != null && "true".equalsIgnoreCase(correctionCoefficientInput);
    }

    public boolean isApplicable() {
        if (this.countItemsWithLengthNotNull != null) {
            return this.countItemsWithLengthNotNull != 0;
        }
        ClassDescriptor sequenceFeatureCd = this.os.getModel().getClassDescriptorByName("SequenceFeature");
        ClassDescriptor typeDescriptor = this.os.getModel().getClassDescriptorByName(this.config.getTypeClass());
        if (((EnrichmentWidgetConfig)this.config).getCorrectionCoefficient() != null && typeDescriptor.getAllSuperDescriptors().contains(sequenceFeatureCd)) {
            this.countItemsWithLengthNotNull = this.getCountItemsWithLengthNotNull();
            if (this.countItemsWithLengthNotNull != 0) {
                return true;
            }
        }
        return false;
    }

    private int getCountItemsWithLengthNotNull() {
        ClassDescriptor sequenceFeatureCd = this.os.getModel().getClassDescriptorByName("SequenceFeature");
        if (this.bag != null && this.bag.getClassDescriptors().contains(sequenceFeatureCd) || this.ids != null) {
            Query q = new Query();
            try {
                String type = this.config.getTypeClass();
                if (this.bag != null) {
                    type = this.bag.getQualifiedType();
                }
                Class<?> clazz = Class.forName(type);
                QueryClass qc = new QueryClass(clazz);
                QueryFunction count = new QueryFunction();
                q.addToSelect((QuerySelectable)count);
                q.addFrom((FromElement)qc);
                ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
                QueryField lenghtField = new QueryField(qc, "length");
                cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)lenghtField, ConstraintOp.IS_NOT_NULL));
                if (this.bag != null) {
                    cs.addConstraint((Constraint)new BagConstraint((QueryNode)qc, ConstraintOp.IN, this.bag.getOsb()));
                } else {
                    cs.addConstraint((Constraint)new BagConstraint((QueryNode)qc, ConstraintOp.IN, this.getIds()));
                }
                q.setConstraint((Constraint)cs);
                SingletonResults result = this.os.executeSingleton(q);
                return ((Long)result.get(0)).intValue();
            }
            catch (ClassNotFoundException cnfe) {
                return 0;
            }
        }
        return 0;
    }

    public void updatePopulationQuery(Query q, Query subQ, QueryField qfCorrection) {
        if (qfCorrection != null) {
            subQ.addToSelect((QuerySelectable)qfCorrection);
            QueryField outerQfGenelength = new QueryField(subQ, (QueryEvaluable)qfCorrection);
            QueryFunction qfAverage = new QueryFunction((QueryEvaluable)outerQfGenelength, 1);
            q.addToSelect((QuerySelectable)qfAverage);
        }
    }

    public void apply(Map<String, BigDecimal> pValuesPerTerm, PopulationInfo population, Map<String, PopulationInfo> annotatedPopulationInfo, Double maxValue) {
        BigDecimal maxDecimal = new BigDecimal(maxValue);
        for (Map.Entry<String, BigDecimal> pValuePerTerm : pValuesPerTerm.entrySet()) {
            BigDecimal pValue = pValuePerTerm.getValue();
            String term = pValuePerTerm.getKey();
            if (pValue.equals(BigDecimal.ZERO)) {
                pValuesPerTerm.put(term, BigDecimal.ZERO);
                continue;
            }
            PopulationInfo pi = annotatedPopulationInfo.get(term);
            if (pi != null) {
                float populationCountProbability;
                float geneLengthPerTerm = pi.getExtraAttribute();
                int populationPerTerm = pi.getSize();
                float geneLength = population.getExtraAttribute();
                float geneLenghtProbability = geneLengthPerTerm / geneLength;
                float correctionCoefficient = geneLenghtProbability / (populationCountProbability = (float)populationPerTerm / (float)population.getSize());
                BigDecimal pValueCorrected = pValue.multiply(new BigDecimal(correctionCoefficient));
                if (maxDecimal.compareTo(pValueCorrected) <= 0) continue;
                if (BigDecimal.ONE.compareTo(pValueCorrected) < 0) {
                    pValuesPerTerm.put(term, BigDecimal.ONE);
                    continue;
                }
                pValuesPerTerm.put(term, pValueCorrected);
                continue;
            }
            pValuesPerTerm.put(term, BigDecimal.ZERO);
        }
    }

    public Map<String, Map<String, Object>> getOutputInfo(String geneLengthCorrectionInput) {
        HashMap<String, Object> geneLengthAttributes = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> extraAttributes = new HashMap<String, Map<String, Object>>();
        if (this.isApplicable()) {
            try {
                double percentageGeneWithLengthNull = this.getPercentageGeneWithLengthNull();
                if (percentageGeneWithLengthNull != 0.0) {
                    DecimalFormat df = new DecimalFormat("##.##");
                    df.setRoundingMode(RoundingMode.DOWN);
                    geneLengthAttributes.put(PERCENTAGE_GENE_LENGTH_NOT_NULL, df.format(percentageGeneWithLengthNull) + "%");
                    geneLengthAttributes.put(PATH_QUERY_GENE_LENGTH_NULL, this.getPathQueryForGenesWithLengthNull(InterMineContext.getWebConfig()).toJson());
                } else {
                    geneLengthAttributes.put(PERCENTAGE_GENE_LENGTH_NOT_NULL, null);
                    geneLengthAttributes.put(PATH_QUERY_GENE_LENGTH_NULL, null);
                }
            }
            catch (ObjectStoreException e) {
                geneLengthAttributes.put(GENE_LENGTH_CORRECTION, null);
                geneLengthAttributes.put(PERCENTAGE_GENE_LENGTH_NOT_NULL, null);
                geneLengthAttributes.put(PATH_QUERY_GENE_LENGTH_NULL, null);
                extraAttributes.put(GENE_LENGTH, geneLengthAttributes);
            }
            if (geneLengthCorrectionInput == null) {
                geneLengthAttributes.put(GENE_LENGTH_CORRECTION, false);
            } else {
                geneLengthAttributes.put(GENE_LENGTH_CORRECTION, Boolean.valueOf(geneLengthCorrectionInput));
            }
        } else {
            geneLengthAttributes.put(GENE_LENGTH_CORRECTION, null);
            geneLengthAttributes.put(PERCENTAGE_GENE_LENGTH_NOT_NULL, null);
            geneLengthAttributes.put(PATH_QUERY_GENE_LENGTH_NULL, null);
        }
        extraAttributes.put(GENE_LENGTH, geneLengthAttributes);
        return extraAttributes;
    }

    private double getPercentageGeneWithLengthNull() throws ObjectStoreException {
        int bagSize = 0;
        bagSize = this.bag == null && !this.ids.isEmpty() ? this.ids.length() : this.bag.getSize();
        double rate = (double)(bagSize - this.countItemsWithLengthNotNull) / (double)bagSize;
        return rate * 100.0;
    }

    private PathQuery getPathQueryForGenesWithLengthNull(WebConfig webConfig) {
        Model model = this.os.getModel();
        PathQuery q = new PathQuery(model);
        String startClassSimpleName = this.config.getStartClass();
        String startClass = model.getPackageName() + "." + startClassSimpleName;
        Collection fieldConfigs = webConfig.getFieldConfigs(startClass);
        for (FieldConfig fieldConfig : fieldConfigs) {
            if (!fieldConfig.getShowInSummary()) continue;
            q.addView(startClassSimpleName + "." + fieldConfig.getFieldExpr());
        }
        if (this.bag == null) {
            List<Integer> intermineIds = this.getIds();
            q.addConstraint((PathConstraint)Constraints.inIds((String)this.config.getStartClass(), intermineIds));
        } else {
            q.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        }
        q.addConstraint((PathConstraint)Constraints.isNull((String)(this.config.getStartClass() + ".length")));
        return q;
    }

    private List<Integer> getIds() {
        String[] idArray = this.ids.split(",");
        ArrayList<Integer> idsCollection = new ArrayList<Integer>();
        for (String intermineId : idArray) {
            try {
                idsCollection.add(Integer.valueOf(intermineId.trim()));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("List of IDs contains invalid integer: " + intermineId, e);
            }
        }
        return idsCollection;
    }

    public QueryField updateQueryWithCorrectionCoefficient(Query query, QueryClass qc) {
        ConstraintSet cs = (ConstraintSet)query.getConstraint();
        QueryField qfCorrection = new QueryField(qc, "length");
        cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qfCorrection, ConstraintOp.IS_NOT_NULL));
        return qfCorrection;
    }
}

