/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.bio.webservice.FastaQueryService;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class FastaListService
extends FastaQueryService {
    private static final String LIST_PARAM = "list";

    public FastaListService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected PathQuery getQuery() {
        InterMineBag list = this.getList();
        PathQuery pq = new PathQuery(this.im.getModel());
        pq.addView(list.getType() + ".id");
        pq.addConstraint((PathConstraint)Constraints.in((String)list.getType(), (String)list.getName()));
        return pq;
    }

    private InterMineBag getList() {
        String listName = this.getRequiredParameter(LIST_PARAM);
        Profile p = this.getPermission().getProfile();
        InterMineBag list = this.im.getBagManager().getBag(p, listName);
        if (list == null) {
            throw new BadRequestException("Cannot access a list called" + listName);
        }
        return list;
    }
}

