/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.bio.web.displayer.GeneOntologyDisplayer;
import org.intermine.bio.web.displayer.MetabolicGeneSummaryDisplayer;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;

public class MetabolicGeneSummaryDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(MetabolicGeneSummaryDisplayer.class);

    public MetabolicGeneSummaryDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        GeneSummary summary = new GeneSummary(this, reportObject.getObject(), request);
        summary.addCollectionCount("Pathways", "Reactome, KEGG", (Object)"pathways", "pathways");
        summary.addCollectionCount("Diseases", "OMIM", (Object)"diseases", "diseases");
        if (summary.isThisAMouser().booleanValue()) {
            summary.addCollectionCount("Mouse Alleles (MGI)", "mouse alleles", (Object)"alleles", "MouseAllelesDisplayer");
        } else {
            summary.addCollectionCount("Mouse Alleles (MGI)", "mouse alleles", (Object)this.allelesPathQuery(summary.getObjectId()), "MouseAllelesDisplayer");
        }
        summary.addCollectionCount("Gene Ontology", "&nbsp;", (Object)this.goTermPathQuery(summary.getObjectId()), "GeneOntologyDisplayer");
        if (summary.isThisAHuman().booleanValue()) {
            ArrayList<Object> arr = new ArrayList<Object>();
            arr.add(this.arrayAtlasExpressionTissues(summary));
            arr.add(this.arrayAtlasExpressionDiseases(summary));
            summary.addCustom("Expression", "Array Express (E-MTAB 62)", arr, "GeneExpressionAtlasTissuesDisplayer", "metabolicGeneSummaryArrayExpressExpressionDisplayer.jsp");
        }
        request.setAttribute("summary", (Object)summary);
    }

    private Object arrayAtlasExpressionTissues(GeneSummary summary) {
        ExportResultsIterator results;
        PathQuery query = new PathQuery(this.im.getModel());
        query.addViews(new String[]{"Gene.atlasExpression.expression"});
        query.addOrderBy("Gene.atlasExpression.pValue", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)summary.getObjectId().toString()), "A");
        query.addConstraint((PathConstraint)Constraints.lessThan((String)"Gene.atlasExpression.pValue", (String)"1E-4"), "B");
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.atlasExpression.type", (String)"organism_part"), "D");
        query.addConstraint((PathConstraint)Constraints.greaterThan((String)"Gene.atlasExpression.tStatistic", (String)"4"), "E");
        query.addConstraint((PathConstraint)Constraints.lessThan((String)"Gene.atlasExpression.tStatistic", (String)"-4"), "F");
        query.addConstraint((PathConstraint)Constraints.neq((String)"Gene.atlasExpression.condition", (String)"(empty)"), "G");
        query.setConstraintLogic("A and B and D and (E or F) and G");
        try {
            results = summary.getExecutor().execute(query);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        Integer up = 0;
        Integer down = 0;
        while (results.hasNext()) {
            List item = results.next();
            String expression = ((ResultElement)item.get(0)).getField().toString();
            if ("UP".equals(expression)) {
                up = up + 1;
                continue;
            }
            down = down + 1;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("up", up);
        map.put("down", down);
        return map;
    }

    private Object arrayAtlasExpressionDiseases(GeneSummary summary) {
        ExportResultsIterator results;
        PathQuery query = new PathQuery(this.im.getModel());
        query.addViews(new String[]{"Gene.atlasExpression.expression"});
        query.addOrderBy("Gene.atlasExpression.pValue", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)summary.getObjectId().toString()), "A");
        query.addConstraint((PathConstraint)Constraints.lessThan((String)"Gene.atlasExpression.pValue", (String)"1e-4"), "B");
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.atlasExpression.type", (String)"disease_state"), "D");
        query.addConstraint((PathConstraint)Constraints.greaterThan((String)"Gene.atlasExpression.tStatistic", (String)"4"), "E");
        query.addConstraint((PathConstraint)Constraints.lessThan((String)"Gene.atlasExpression.tStatistic", (String)"-4"), "F");
        query.addConstraint((PathConstraint)Constraints.neq((String)"Gene.atlasExpression.condition", (String)"(empty)"), "G");
        query.setConstraintLogic("A and B and D and (E or F) and G");
        try {
            results = summary.getExecutor().execute(query);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        Integer up = 0;
        Integer down = 0;
        while (results.hasNext()) {
            List item = results.next();
            String expression = ((ResultElement)item.get(0)).getField().toString();
            if ("UP".equals(expression)) {
                up = up + 1;
                continue;
            }
            down = down + 1;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("up", up);
        map.put("down", down);
        return map;
    }

    @Deprecated
    private String emtabExpression(String primaryId) {
        if (primaryId != null) {
            return "http://www.ebi.ac.uk/gxa/webanatomogram/" + primaryId + ".png";
        }
        return null;
    }

    private PathQuery allelesPathQuery(Integer objectId) {
        PathQuery query = new PathQuery(this.im.getModel());
        query.addViews(new String[]{"Gene.homologues.homologue.alleles.primaryIdentifier"});
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.homologues.homologue.organism.shortName", (String)"M. musculus"), "A");
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)objectId.toString()), "B");
        query.setConstraintLogic("A and B");
        return query;
    }

    private PathQuery goTermPathQuery(Integer objectId) {
        PathQuery query = new PathQuery(this.im.getModel());
        query.addViews(new String[]{"Gene.goAnnotation.ontologyTerm.name"});
        query.addOrderBy("Gene.goAnnotation.ontologyTerm.name", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)objectId.toString()));
        query.addConstraint((PathConstraint)Constraints.oneOfValues((String)"Gene.goAnnotation.ontologyTerm.parents.name", (Collection)GeneOntologyDisplayer.ONTOLOGIES));
        query.addConstraint((PathConstraint)Constraints.isNull((String)"Gene.goAnnotation.qualifier"));
        return query;
    }

    static /* synthetic */ InterMineAPI access$000(MetabolicGeneSummaryDisplayer x0) {
        return x0.im;
    }
}

