/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.bio.webservice.GenomicRegionSearchListInput;
import org.intermine.webservice.server.lists.ListInput;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenomicRegionSearchListInput
extends ListInput {
    private final InterMineAPI api;
    private final GenomicRegionSearchInfo info;

    public GenomicRegionSearchListInput(HttpServletRequest request, BagManager bagManager, Profile profile, InterMineAPI im) throws Exception {
        super(request, bagManager, profile);
        this.api = im;
        this.info = this.parseRegionRequest();
    }

    private GenomicRegionSearchInfo parseRegionRequest() throws Exception {
        String input = "";
        input = "application/x-www-form-urlencoded".equals(this.request.getContentType()) || "GET".equalsIgnoreCase(this.request.getMethod()) ? this.request.getParameter("query") : IOUtils.toString((InputStream)this.request.getInputStream());
        JSONObject jsonRequest = new JSONObject(input);
        GenomicRegionSearchInfo parsed = new GenomicRegionSearchInfo(this);
        parsed.setOrganism(jsonRequest.getString("organism"));
        if (!jsonRequest.isNull("isInterbase")) {
            parsed.setInterbase(jsonRequest.getBoolean("isInterbase"));
        }
        if (!jsonRequest.isNull("extension")) {
            parsed.setExtension(jsonRequest.optInt("extension", 0));
        }
        JSONArray fts = jsonRequest.getJSONArray("featureTypes");
        int noOfTypes = fts.length();
        ArrayList<String> featureTypes = new ArrayList<String>();
        for (int i = 0; i < noOfTypes; ++i) {
            featureTypes.add(fts.getString(i));
        }
        parsed.setFeatureTypes(featureTypes);
        JSONArray regs = jsonRequest.getJSONArray("regions");
        int noOfRegs = regs.length();
        ArrayList<String> regions = new ArrayList<String>();
        for (int i = 0; i < noOfRegs; ++i) {
            regions.add(regs.getString(i));
        }
        parsed.setRegions(regions);
        if (!jsonRequest.isNull("strandSpecific")) {
            parsed.setStrandSpecific(jsonRequest.getBoolean("strandSpecific"));
        }
        return parsed;
    }

    protected String produceName() {
        String name = this.request.getParameter("listName");
        if (!StringUtils.isBlank((String)name)) {
            return name;
        }
        return super.produceName();
    }

    public GenomicRegionSearchInfo getSearchInfo() {
        return this.info;
    }

    static /* synthetic */ InterMineAPI access$000(GenomicRegionSearchListInput x0) {
        return x0.api;
    }
}

