/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.ClassKeysNotFoundException;
import org.intermine.api.bag.UnknownBagTypeException;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.bio.web.logic.GenomicRegionSearchQueryRunner;
import org.intermine.bio.web.logic.GenomicRegionSearchUtil;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.webservice.GenomicRegionSearchListInput;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.lists.ListMakerService;
import org.intermine.webservice.server.lists.ListServiceUtils;
import org.json.JSONException;

public class GenomicRegionSearchService
extends ListMakerService {
    public GenomicRegionSearchService(InterMineAPI im) {
        super(im);
    }

    protected String getNewListType(ListInput input) {
        GenomicRegionSearchListInput searchInput = (GenomicRegionSearchListInput)input;
        return ListServiceUtils.findCommonSuperTypeOf((Set)searchInput.getSearchInfo().getFeatureCds());
    }

    protected void makeList(ListInput input, String type, Profile profile, Set<String> temporaryBagNamesAccumulator) throws Exception {
        InterMineBag tempBag;
        if (input.doReplace()) {
            ListServiceUtils.ensureBagIsDeleted((Profile)profile, (String)input.getListName());
        }
        if (profile.getCurrentSavedBags().containsKey(input.getListName())) {
            throw new BadRequestException("Attempt to overwrite an existing bag - name:'" + input.getListName() + "'");
        }
        GenomicRegionSearchListInput searchInput = (GenomicRegionSearchListInput)input;
        try {
            tempBag = this.doListCreation(searchInput, profile, type);
        }
        catch (UnknownBagTypeException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        this.addOutputInfo("listSize", tempBag.getSize() + "");
        ArrayList row = new ArrayList(searchInput.getSearchInfo().getInvalidSpans());
        this.output.addResultItem(row);
        if (!input.getTags().isEmpty()) {
            this.im.getBagManager().addTagsToBag((Collection)input.getTags(), tempBag, profile);
        }
        profile.renameBag(input.getTemporaryListName(), input.getListName());
    }

    protected InterMineBag doListCreation(GenomicRegionSearchListInput input, Profile profile, String type) throws ObjectStoreException, ClassKeysNotFoundException, UnknownBagTypeException {
        InterMineBag tempBag = profile.createBag(input.getTemporaryListName(), type, input.getDescription(), (Map)this.im.getClassKeys());
        Map queries = this.createQueries(input.getSearchInfo());
        for (Map.Entry e : queries.entrySet()) {
            Query q = (Query)e.getValue();
            tempBag.addToBagFromQuery(q);
        }
        return tempBag;
    }

    protected Map<String, Object> getHeaderAttributes() {
        Map attributes = super.getHeaderAttributes();
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"invalidSpans\":[");
            attributes.put("outro", "]");
            attributes.put("should_quote", Boolean.TRUE);
        }
        return attributes;
    }

    protected ListInput getInput() {
        try {
            return new GenomicRegionSearchListInput(this.request, this.bagManager, this.getPermission().getProfile(), this.im);
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw new BadRequestException("Error parsing region search input");
            }
            throw new BadRequestException("Error parsing region search input: " + e.getMessage());
        }
        catch (Exception e) {
            throw new BadRequestException("Could not read input: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Map<GenomicRegion, Query> createQueries(GenomicRegionSearchListInput.GenomicRegionSearchInfo info) {
        return GenomicRegionSearchUtil.createRegionListQueries((Collection)info.getGenomicRegions(), (int)info.getExtension(), (Map)((Map)GenomicRegionSearchQueryRunner.getChromosomeInfo((InterMineAPI)this.im).get(info.getOrganism())), (String)info.getOrganism(), (Set)info.getFeatureClasses(), (boolean)info.getStrandSpecific());
    }
}

