/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.fair;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.rdf.PurlConfig;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.DynamicUtil;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.PermanentURIHelper;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.registry.model.Instance;
import org.intermine.web.registry.model.RegistryResponse;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InterMineLUIConverter;
import org.intermine.web.util.URLGenerator;
import org.intermine.webservice.server.core.SessionlessRequest;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SemanticMarkupFormatter {
    private static final String SCHEMA = "https://schema.org";
    private static final String DATASET_TYPE = "DataSet";
    private static final String BIOCHEMENTITY_TYPE = "BioChemEntity";
    private static final String PROTEIN_TYPE = "Protein";
    private static final String GENE_TYPE = "Gene";
    private static final String INTERMINE_CITE = "http://www.ncbi.nlm.nih.gov/pubmed/23023984";
    private static final String INTERMINE_REGISTRY = "https://registry.intermine.org/";
    private static String baseURI = null;
    private static final Logger LOG = Logger.getLogger(SemanticMarkupFormatter.class);

    private SemanticMarkupFormatter() {
    }

    private static Instance getMineInstance(HttpServletRequest request) {
        HttpSession session;
        baseURI = new PermanentURIHelper(request).getPermanentBaseURI();
        Instance imInstance = null;
        if (!(request instanceof SessionlessRequest) && (imInstance = SessionMethods.getBasicInstanceInfo((HttpSession)(session = request.getSession()))) != null) {
            return imInstance;
        }
        String mineURL = new URLGenerator(request).getPermanentBaseURL();
        Client client = ClientBuilder.newClient();
        try {
            Response response = client.target("https://registry.intermine.org/service/namespace?url=" + mineURL).request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                JSONObject result = new JSONObject((String)response.readEntity(String.class));
                String namespace = result.getString("namespace");
                LOG.info((Object)("Namespace is: " + namespace));
                response = client.target("https://registry.intermine.org/service/instances/" + namespace).request().get();
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    RegistryResponse registryRes = (RegistryResponse)response.readEntity(RegistryResponse.class);
                    imInstance = registryRes.getInstance();
                }
                if (!(request instanceof SessionlessRequest)) {
                    SessionMethods.setBasicInstanceInfo((ServletContext)request.getSession().getServletContext(), (Instance)imInstance);
                }
            }
        }
        catch (RuntimeException ex) {
            LOG.error((Object)"Problems connecting to InterMine registry");
            return null;
        }
        return imInstance;
    }

    public static Map<String, Object> formatInstance(HttpServletRequest request, Profile profile) {
        if (!SemanticMarkupFormatter.isEnabled()) {
            return null;
        }
        Instance instance = SemanticMarkupFormatter.getMineInstance((HttpServletRequest)request);
        Properties props = PropertiesUtil.getProperties();
        LinkedHashMap<String, Object> semanticMarkup = new LinkedHashMap<String, Object>();
        semanticMarkup.put("@context", "https://schema.org");
        semanticMarkup.put("@type", "DataSet");
        semanticMarkup.put("name", props.getProperty("project.title"));
        semanticMarkup.put("description", props.getProperty("project.subTitle"));
        semanticMarkup.put("keywords", "Data warehouse, Data integration,Bioinformatics software");
        String url = new URLGenerator(request).getPermanentBaseURL();
        String identifier = instance != null ? "https://registry.intermine.org/" + instance.getNamespace() : url;
        semanticMarkup.put("identifier", identifier);
        semanticMarkup.put("@id", url);
        semanticMarkup.put("url", url);
        LinkedHashMap<String, String> citation = new LinkedHashMap<String, String>();
        citation.put("@type", "CreativeWork");
        citation.put("@id", "http://www.ncbi.nlm.nih.gov/pubmed/23023984");
        citation.put("url", "http://www.ncbi.nlm.nih.gov/pubmed/23023984");
        semanticMarkup.put("citation", citation);
        LinkedHashMap<String, String> contactPoint = new LinkedHashMap<String, String>();
        contactPoint.put("@type", "Person");
        contactPoint.put("name", "Support");
        if (instance != null && !StringUtils.isEmpty((String)instance.getMaintainerEmail())) {
            contactPoint.put("email", instance.getMaintainerEmail());
        } else {
            contactPoint.put("email", "support@intermine.org");
        }
        semanticMarkup.put("contactPoint", contactPoint);
        LinkedHashMap<String, String> provider = new LinkedHashMap<String, String>();
        provider.put("@type", "Organization");
        if (instance != null && !StringUtils.isEmpty((String)instance.getMaintainerOrgName())) {
            provider.put("name", instance.getMaintainerOrgName());
        } else {
            provider.put("name", "InterMine");
        }
        if (instance != null && !StringUtils.isEmpty((String)instance.getMaintainerUrl())) {
            provider.put("url", instance.getMaintainerUrl());
        } else {
            provider.put("url", "http://intermine.org");
        }
        semanticMarkup.put("provider", provider);
        semanticMarkup.put("isBasedOn", SemanticMarkupFormatter.formatDataSets((HttpServletRequest)request, (Profile)profile));
        return semanticMarkup;
    }

    private static List<Map<String, Object>> formatDataSets(HttpServletRequest request, Profile profile) {
        ArrayList<Map<String, Object>> dataSets = new ArrayList<Map<String, Object>>();
        PathQuery pathQuery = new PathQuery(Model.getInstanceByName((String)"genomic"));
        pathQuery.addViews(new String[]{"DataSet.name", "DataSet.description", "DataSet.url", "DataSet.licence"});
        pathQuery.addOrderBy("DataSet.name", OrderDirection.ASC);
        InterMineAPI im = InterMineContext.getInterMineAPI();
        PathQueryExecutor executor = new PathQueryExecutor(im.getObjectStore(), profile, null, im.getBagManager());
        try {
            ExportResultsIterator iterator = executor.execute(pathQuery);
            while (iterator.hasNext()) {
                List elem = iterator.next();
                String name = (String)((ResultElement)elem.get(0)).getField();
                String description = (String)((ResultElement)elem.get(1)).getField();
                String url = (String)((ResultElement)elem.get(2)).getField();
                String licence = (String)((ResultElement)elem.get(3)).getField();
                dataSets.add(SemanticMarkupFormatter.formatDataSet((String)name, (String)description, (String)url, (String)licence, (HttpServletRequest)request));
            }
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
        return dataSets;
    }

    private static Map<String, Object> formatDataSet(String name, String description, String url, String licence, HttpServletRequest request) {
        LinkedHashMap<String, Object> semanticMarkup = new LinkedHashMap<String, Object>();
        semanticMarkup.put("@context", "https://schema.org");
        semanticMarkup.put("@type", "DataSet");
        semanticMarkup.put("name", name);
        if (description != null && !description.isEmpty()) {
            semanticMarkup.put("description", description);
        } else {
            semanticMarkup.put("description", name);
        }
        if (licence != null && !licence.isEmpty()) {
            semanticMarkup.put("licence", licence);
        }
        PermanentURIHelper helper = new PermanentURIHelper(request);
        InterMineLUI lui = new InterMineLUI("DataSet", name);
        String imUrlPage = helper.getPermanentURL(lui);
        semanticMarkup.put("identifier", lui.toString());
        semanticMarkup.put("url", imUrlPage);
        semanticMarkup.put("@id", imUrlPage);
        if (url != null && !url.trim().equals("")) {
            semanticMarkup.put("sameAs", url);
        }
        return semanticMarkup;
    }

    private static Map<String, Object> formatDataSet(HttpServletRequest request, InterMineObject entity) {
        try {
            String name = (String)entity.getFieldValue("name");
            String description = (String)entity.getFieldValue("description");
            String url = (String)entity.getFieldValue("url");
            String licence = (String)entity.getFieldValue("licence");
            return SemanticMarkupFormatter.formatDataSet((String)name, (String)description, (String)url, (String)licence, (HttpServletRequest)request);
        }
        catch (IllegalAccessException iae) {
            LOG.warn((Object)("Failed to access object with id: " + entity.getId()), (Throwable)iae);
            return null;
        }
    }

    public static Map<String, Object> formatBioEntity(HttpServletRequest request, int id) {
        if (!SemanticMarkupFormatter.isEnabled()) {
            return null;
        }
        InterMineAPI im = InterMineContext.getInterMineAPI();
        ObjectStore os = im.getObjectStore();
        InterMineObject entity = null;
        String type = null;
        try {
            entity = os.getObjectById(Integer.valueOf(id));
            type = DynamicUtil.getSimpleClass((FastPathObject)entity).getSimpleName();
            if ("DataSet".equalsIgnoreCase(type)) {
                return SemanticMarkupFormatter.formatDataSet((HttpServletRequest)request, (InterMineObject)entity);
            }
        }
        catch (ObjectStoreException ose) {
            LOG.warn((Object)("Failed to find object with id: " + id), (Throwable)ose);
        }
        Map semanticMarkup = SemanticMarkupFormatter.formatBioEntity((InterMineObject)entity);
        if (semanticMarkup == null) {
            return null;
        }
        semanticMarkup.put("@context", "https://schema.org");
        Properties props = PropertiesUtil.getProperties();
        semanticMarkup.put("version", props.getProperty("project.releaseVersion"));
        LinkedHashMap<String, String> isPartOf = new LinkedHashMap<String, String>();
        isPartOf.put("@type", "DataSet");
        isPartOf.put("name", props.getProperty("project.title"));
        isPartOf.put("description", props.getProperty("project.subTitle"));
        semanticMarkup.put("isPartOf", isPartOf);
        return semanticMarkup;
    }

    private static Map<String, Object> formatBioEntity(InterMineObject imObject) {
        String type = DynamicUtil.getSimpleClass((FastPathObject)imObject).getSimpleName();
        if ("Gene".equalsIgnoreCase(type)) {
            return SemanticMarkupFormatter.formatGene((InterMineObject)imObject, (boolean)false);
        }
        if ("Protein".equalsIgnoreCase(type)) {
            return SemanticMarkupFormatter.formatProtein((InterMineObject)imObject, (boolean)false);
        }
        if (SemanticMarkupFormatter.isBioChemEntityType((String)type)) {
            return SemanticMarkupFormatter.formatBioChemEntity((InterMineObject)imObject);
        }
        return null;
    }

    private static Map<String, Object> formatGene(InterMineObject gene, boolean onlyMinimun) {
        LinkedHashMap<String, Object> geneMarkups = new LinkedHashMap<String, Object>();
        geneMarkups.put("@type", "Gene");
        SemanticMarkupFormatter.setBasicProperties((Integer)gene.getId(), geneMarkups);
        SemanticMarkupFormatter.setName((InterMineObject)gene, geneMarkups);
        SemanticMarkupFormatter.setSameAs((InterMineObject)gene, geneMarkups);
        try {
            geneMarkups.put("description", (String)gene.getFieldValue("description"));
            SemanticMarkupFormatter.setTaxonomicRange((InterMineObject)gene, geneMarkups);
            if (!onlyMinimun) {
                ProxyCollection proteinsCollections;
                ProxyReference chromRef = (ProxyReference)gene.getFieldProxy("chromosome");
                if (chromRef != null) {
                    InterMineObject chromosome = chromRef.getObject();
                    geneMarkups.put("isPartOfBioChemEntity", SemanticMarkupFormatter.formatBioChemEntity((InterMineObject)chromosome));
                }
                if ((proteinsCollections = (ProxyCollection)gene.getFieldProxy("proteins")) != null) {
                    for (InterMineObject protein : proteinsCollections) {
                        geneMarkups.put("encodesBioChemEntity", SemanticMarkupFormatter.formatProtein((InterMineObject)protein, (boolean)true));
                    }
                }
            }
            return geneMarkups;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private static void setBasicProperties(Integer intermineId, Map<String, Object> entityMarkups) {
        InterMineLUI lui = new InterMineLUIConverter().getInterMineLUI(intermineId);
        if (lui != null) {
            String url = baseURI.concat(lui.toString());
            entityMarkups.put("url", url);
            entityMarkups.put("@id", url);
            entityMarkups.put("identifier", lui.toString());
        }
    }

    private static void setName(InterMineObject bioEntity, Map<String, Object> entityMarkups) {
        try {
            String symbol = (String)bioEntity.getFieldValue("symbol");
            String primaryIdentifier = (String)bioEntity.getFieldValue("primaryIdentifier");
            entityMarkups.put("name", !StringUtils.isEmpty((String)symbol) ? symbol : primaryIdentifier);
        }
        catch (IllegalAccessException iae) {
            LOG.warn((Object)("Failed to access object with id: " + bioEntity.getId()), (Throwable)iae);
        }
    }

    private static void setSameAs(InterMineObject bioEntity, Map<String, Object> entityMarkups) {
        String externalIdentifier = PurlConfig.getExternalIdentifier((InterMineObject)bioEntity);
        if (externalIdentifier != null) {
            entityMarkups.put("sameAs", externalIdentifier);
        }
    }

    private static void setTaxonomicRange(InterMineObject imObject, Map<String, Object> markups) {
        try {
            InterMineObject organism;
            InterMineLUI lui;
            ProxyReference organismRef = (ProxyReference)imObject.getFieldProxy("organism");
            if (organismRef != null && (lui = new InterMineLUIConverter().getInterMineLUI((organism = organismRef.getObject()).getId())) != null) {
                markups.put("taxonomicRange", baseURI.concat(lui.toString()));
            }
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
    }

    private static Map<String, Object> formatProtein(InterMineObject protein, boolean onlyMinimun) {
        LinkedHashMap<String, Object> proteinMarkups = new LinkedHashMap<String, Object>();
        proteinMarkups.put("@type", "Protein");
        SemanticMarkupFormatter.setBasicProperties((Integer)protein.getId(), proteinMarkups);
        SemanticMarkupFormatter.setName((InterMineObject)protein, proteinMarkups);
        SemanticMarkupFormatter.setSameAs((InterMineObject)protein, proteinMarkups);
        SemanticMarkupFormatter.setTaxonomicRange((InterMineObject)protein, proteinMarkups);
        try {
            ProxyCollection genesCollections;
            if (!onlyMinimun && (genesCollections = (ProxyCollection)protein.getFieldProxy("genes")) != null) {
                for (InterMineObject gene : genesCollections) {
                    proteinMarkups.put("isEncodedByBioChemEntity", SemanticMarkupFormatter.formatGene((InterMineObject)gene, (boolean)true));
                }
            }
            return proteinMarkups;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private static Map<String, Object> formatBioChemEntity(InterMineObject bioChemEntity) {
        LinkedHashMap<String, Object> bioChemEntityMarkups = new LinkedHashMap<String, Object>();
        bioChemEntityMarkups.put("@type", "BioChemEntity");
        SemanticMarkupFormatter.setBasicProperties((Integer)bioChemEntity.getId(), bioChemEntityMarkups);
        SemanticMarkupFormatter.setName((InterMineObject)bioChemEntity, bioChemEntityMarkups);
        SemanticMarkupFormatter.setSameAs((InterMineObject)bioChemEntity, bioChemEntityMarkups);
        return bioChemEntityMarkups;
    }

    public static boolean isEnabled() {
        Properties props = InterMineContext.getWebProperties();
        return props.containsKey("markup.webpages.enable") && "true".equals(props.getProperty("markup.webpages.enable").trim());
    }

    private static boolean isBioChemEntityType(String inputType) {
        try {
            if (ClassDescriptor.findInherithance((Model)Model.getInstanceByName((String)"genomic"), (String)inputType, (String)"BioEntity")) {
                return true;
            }
        }
        catch (MetaDataException mde) {
            LOG.warn((Object)("Type " + inputType + " is not in the model"));
            return false;
        }
        return false;
    }
}

