/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.results.RDFObject;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InvalidPermanentURLException;

public class EntityRepresentationFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        try {
            String requestURI = request.getRequestURI();
            requestURI = requestURI.substring(0, requestURI.lastIndexOf(".rdf"));
            InterMineLUI lui = new InterMineLUI(requestURI);
            RDFObject rdfObject = new RDFObject(lui, SessionMethods.getInterMineAPI((HttpSession)session), request);
            if (!rdfObject.isValid()) {
                response.setStatus(404);
                chain.doFilter(req, res);
            } else {
                response.setStatus(200);
                ResponseUtil.setRDFXMLContentType((HttpServletResponse)response);
                PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
                rdfObject.serializeAsRDF((Writer)out);
                response.flushBuffer();
            }
        }
        catch (InvalidPermanentURLException ex) {
            chain.doFilter(req, res);
        }
        catch (Exception ex) {
            response.setStatus(500);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

