/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.util.PathUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.metadata.StringUtil;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.util.DynamicUtil;
import org.intermine.web.displayer.DisplayerManager;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.fair.SemanticMarkupFormatter;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.HeaderConfigLink;
import org.intermine.web.logic.config.HeaderConfigTitle;
import org.intermine.web.logic.config.InlineListConfig;
import org.intermine.web.logic.config.Type;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.DisplayCollection;
import org.intermine.web.logic.results.DisplayField;
import org.intermine.web.logic.results.DisplayReference;
import org.intermine.web.logic.results.InlineList;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.results.ReportObjectField;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InterMineLUIConverter;
import org.json.JSONObject;

public class ReportObject {
    private InterMineObject object;
    private final WebConfig webConfig;
    private final String objectType;
    private Map<String, Object> fieldValues;
    private InterMineAPI im;
    private List<ReportObjectField> objectSummaryFields;
    private List<InlineList> inlineListsHeader = null;
    private List<InlineList> inlineListsNormal = null;
    private Map<String, Object> attributes = null;
    private Map<String, FieldDescriptor> attributeDescriptors = null;
    private Map<String, DisplayReference> references = null;
    private Map<String, DisplayCollection> collections = null;
    private Map<String, DisplayField> refsAndCollections = null;
    private Map<String, Map<String, TitleValue>> headerTitles = null;
    private Set<String> replacedFieldExprs = null;
    private HeaderConfigLink headerLink;
    private String pageTitle = null;
    private Set<String> nullRefsCols;
    private Properties webProperties;
    private static final Logger LOG = Logger.getLogger(ReportObject.class);

    public ReportObject(InterMineObject object, WebConfig webConfig, InterMineAPI im, Properties webProperties) throws Exception {
        this.object = object;
        this.webConfig = webConfig;
        this.im = im;
        this.webProperties = webProperties;
        this.objectType = DynamicUtil.getSimpleClass((FastPathObject)object).getSimpleName();
    }

    public Map<String, List<ReportDisplayer>> getReportDisplayers() {
        DisplayerManager displayerManager = DisplayerManager.getInstance((WebConfig)this.webConfig, (InterMineAPI)this.im);
        return displayerManager.getReportDisplayersForType(this.objectType);
    }

    public ReportDisplayer getReportDisplayer(String name) {
        DisplayerManager displayerManager = DisplayerManager.getInstance((WebConfig)this.webConfig, (InterMineAPI)this.im);
        return displayerManager.getReportDisplayerByName(this.objectType, name);
    }

    public int getId() {
        return this.object.getId();
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.initialise();
        }
        return this.attributes;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.im.getModel().getClassDescriptorByName(this.objectType);
    }

    public Map<String, DisplayCollection> getCollections() {
        if (this.collections == null) {
            this.initialise();
        }
        return this.collections;
    }

    private String stripTail(String input) {
        Integer dot = input.indexOf(".");
        if (dot > 0) {
            return input.substring(0, dot);
        }
        return input;
    }

    public List<ReportObjectField> getObjectSummaryFields() {
        long startTime = System.currentTimeMillis();
        if (this.objectSummaryFields == null) {
            this.objectSummaryFields = new ArrayList();
            ArrayList<ReportObjectField> objectOtherSummaryFields = new ArrayList<ReportObjectField>();
            Set replacedFields = this.getReplacedFieldExprs();
            HashSet<String> fieldConfigPaths = new HashSet<String>();
            for (FieldConfig fc : this.getFieldConfigs()) {
                String fieldName = fc.getFieldExpr();
                if (replacedFields.contains(this.stripTail(fieldName))) continue;
                Object fieldValue = this.getFieldValue(fieldName);
                String fieldDisplayer = fc.getDisplayer();
                if (!this.isAttribute(fieldName) && fieldDisplayer == null && !fc.getShowInSummary()) continue;
                ReportObjectField rof = new ReportObjectField(this.objectType, fieldName, fieldValue, fieldDisplayer, fc.getDoNotTruncate(), fc.getEscapeXml(), fc.getLabel());
                if (!fc.getHide()) {
                    if (fc.getShowInSummary()) {
                        this.objectSummaryFields.add(rof);
                    } else {
                        objectOtherSummaryFields.add(rof);
                    }
                }
                fieldConfigPaths.add(fc.getFieldExpr());
            }
            this.objectSummaryFields.addAll(objectOtherSummaryFields);
            if (this.attributes != null) {
                for (String attName : this.attributes.keySet()) {
                    if (fieldConfigPaths.contains(attName) || replacedFields.contains(attName)) continue;
                    ReportObjectField rof = new ReportObjectField(this.objectType, attName, this.attributes.get(attName), null, false, false);
                    this.objectSummaryFields.add(rof);
                }
            }
            Map mainTitles = this.getTitleMain();
            Map subTitles = this.getTitleSub();
            HashSet allTitles = new HashSet();
            if (mainTitles != null) {
                allTitles.addAll(mainTitles.keySet());
            }
            if (subTitles != null) {
                allTitles.addAll(subTitles.keySet());
            }
            if (allTitles.size() > 0) {
                ArrayList<ReportObjectField> temp = new ArrayList<ReportObjectField>();
                for (ReportObjectField rof : this.objectSummaryFields) {
                    String rofName = rof.getName();
                    if (allTitles.contains(rofName)) continue;
                    temp.add(rof);
                }
                this.objectSummaryFields = temp;
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("TIME objectSummaryFields creation took: " + (endTime - startTime) + "ms"));
        } else {
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("TIME objectSummaryFields already set, took: " + (endTime - startTime) + "ms"));
        }
        return this.objectSummaryFields;
    }

    public InterMineObject getObject() {
        return this.object;
    }

    public Collection<FieldConfig> getFieldConfigs() {
        String qualifiedType = DynamicUtil.getSimpleClass((FastPathObject)this.object).getName();
        return this.webConfig.getFieldConfigs(qualifiedType);
    }

    public String getFieldDisplayName(String fieldExpression) {
        Collection configs = this.getFieldConfigs();
        for (FieldConfig fc : configs) {
            if (fc.getFieldExpr() == null || !fc.getFieldExpr().equals(fieldExpression)) continue;
            if (fc.getLabel() != null) {
                return fc.getLabel();
            }
            return fieldExpression;
        }
        return fieldExpression;
    }

    public Object getFieldValue(String fieldExpression) {
        if (this.fieldValues == null) {
            this.setupFieldValues();
        }
        return this.fieldValues.get(fieldExpression);
    }

    private boolean isAttribute(String fieldName) {
        Path p = this.getPathForField(fieldName);
        return p.endIsAttribute();
    }

    private boolean isCollection(String fieldName) {
        Path p = this.getPathForField(fieldName);
        return p.endIsCollection();
    }

    private Path getPathForField(String fieldName) {
        Path p;
        String pathString = this.objectType + "." + fieldName;
        try {
            p = new Path(this.im.getModel(), pathString);
        }
        catch (PathException e) {
            throw new Error(e);
        }
        return p;
    }

    public String getSemanticMarkup(HttpServletRequest request) {
        if (!SemanticMarkupFormatter.isEnabled()) {
            return null;
        }
        Map markup = SemanticMarkupFormatter.formatBioEntity((HttpServletRequest)request, (int)this.getId());
        return new JSONObject(markup).toString(2);
    }

    public String getLUI() {
        InterMineLUI lui = new InterMineLUIConverter().getInterMineLUI(Integer.valueOf(this.object.getId()));
        return lui.toString();
    }

    protected void setupFieldValues() {
        this.fieldValues = new HashMap();
        for (FieldConfig fc : this.getFieldConfigs()) {
            if (this.isCollection(fc.getFieldExpr())) continue;
            String pathString = this.objectType + "." + fc.getFieldExpr();
            LOG.info((Object)("setupFieldValues " + pathString));
            try {
                this.fieldValues.put(fc.getFieldExpr(), this.resolvePath(pathString));
            }
            catch (PathException e) {
                throw new Error("There must be a bug", e);
            }
        }
    }

    private Object resolvePath(String pathString) throws PathException {
        Path path = new Path(this.im.getModel(), pathString);
        return PathUtil.resolvePath((Path)path, (Object)this.object);
    }

    public String getType() {
        return this.objectType;
    }

    public String getHtmlHeadTitle() {
        if (this.pageTitle == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.objectType);
            sb.append(" ");
            Map mainTitles = this.getTitles("main");
            if (!mainTitles.values().isEmpty()) {
                for (TitleValue mainTitle : mainTitles.values()) {
                    sb.append(mainTitle.getUnformatted());
                    sb.append(" ");
                }
            } else {
                Object keyFieldValue = ClassKeyHelper.getKeyFieldValue((FastPathObject)this.object, (Map)this.im.getClassKeys());
                if (keyFieldValue != null) {
                    sb.append(keyFieldValue);
                }
            }
            Map subTitles = this.getTitles("sub");
            for (TitleValue subTitle : subTitles.values()) {
                sb.append(subTitle.getUnformatted());
                sb.append(" ");
            }
            this.pageTitle = sb.toString().trim();
        }
        return this.pageTitle;
    }

    public Map<String, TitleValue> getTitleMain() {
        return this.getTitles("main");
    }

    public Map<String, TitleValue> getTitleSub() {
        return this.getTitles("sub");
    }

    private Map<String, TitleValue> getTitles(String key) {
        if (this.headerTitles == null) {
            this.headerTitles = new HashMap();
            Type type = (Type)this.webConfig.getTypes().get(DynamicUtil.getSimpleClassName((FastPathObject)this.object));
            HeaderConfigTitle hc = type.getHeaderConfigTitle();
            block2: for (String part : HeaderConfigTitle.TYPES) {
                this.headerTitles.put(part, new LinkedHashMap());
                if (hc == null) continue;
                for (HeaderConfigTitle.TitlePart tp : (List)hc.getTitles().get(part)) {
                    String fieldValueStr;
                    Object fieldValue = this.getFieldValue(tp.getPath());
                    if (fieldValue == null) {
                        try {
                            fieldValue = this.resolvePath(this.objectType + "." + tp.getPath());
                        }
                        catch (PathException e) {
                            LOG.warn((Object)("Error resolving path '" + tp.getPath() + "' in titles config for: " + this.objectType));
                        }
                    }
                    if (fieldValue != null && StringUtils.isNotBlank((String)(fieldValueStr = fieldValue.toString()))) {
                        String formatted = tp.getPrefix() + fieldValueStr + tp.getSuffix();
                        TitleValue tv = new TitleValue(this, formatted, fieldValueStr);
                        ((Map)this.headerTitles.get(part)).put(tp.getPath(), tv);
                    }
                    if (!part.equals("main") || ((Map)this.headerTitles.get("main")).size() < hc.getNumberOfMainTitlesToShow()) continue;
                    continue block2;
                }
            }
        }
        if (!this.headerTitles.containsKey(key)) {
            LOG.error((Object)("Requested invalid title part '" + key + "', valid parts are: " + StringUtil.prettyList(Arrays.asList(HeaderConfigTitle.TYPES))));
            return null;
        }
        return (Map)this.headerTitles.get(key);
    }

    public HeaderConfigLink getHeaderLink() {
        long startTime = System.currentTimeMillis();
        if (this.headerLink == null) {
            String linkUrl;
            Type type = (Type)this.webConfig.getTypes().get(this.getClassDescriptor().getName());
            HeaderConfigLink link = type.getHeaderConfigLink();
            if (link != null && (linkUrl = link.getUrl()) != null) {
                Pattern linkPattern = Pattern.compile("\\{(.*?)\\}");
                Matcher m = linkPattern.matcher(linkUrl);
                while (m.find()) {
                    String stringyStuff;
                    String path = m.group(1).replaceAll("[^a-zA-Z.]", "");
                    Object stuff = this.getFieldValue(path);
                    if (stuff == null || !StringUtils.isNotBlank((String)(stringyStuff = stuff.toString()))) continue;
                    link.setUrl(linkUrl.replace("{" + path + "}", stringyStuff));
                    this.headerLink = link;
                }
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("TIME getHeaderLink creation took: " + (endTime - startTime) + "ms"));
        } else {
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("TIME getHeaderLink already set, took: " + (endTime - startTime) + "ms"));
        }
        return this.headerLink;
    }

    public Integer getNumberOfTableRowsToShow() {
        String maxInlineTableSizeString = (String)this.webProperties.get("inline.table.size");
        try {
            return Integer.parseInt(maxInlineTableSizeString);
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Failed to parse inline.table.size property: " + maxInlineTableSizeString));
            return null;
        }
    }

    private void initialiseInlineList(InlineListConfig listConfig, HashMap<String, Boolean> bagOfInlineListNames) {
        Object path;
        long startTime = System.currentTimeMillis();
        Set listOfListObjects = null;
        String columnToDisplayBy = null;
        InlineList list = null;
        try {
            path = new Path(this.im.getModel(), DynamicUtil.getSimpleClass(this.object.getClass()).getSimpleName() + '.' + listConfig.getPath());
            try {
                columnToDisplayBy = path.getLastElement();
                path = path.getPrefix();
            }
            catch (Error e) {
                throw new RuntimeException("You need to specify a key to displaythe list by, not just the root element.");
            }
            listOfListObjects = PathUtil.resolveCollectionPath((Path)path, (Object)this.object);
            list = new InlineList(listOfListObjects, columnToDisplayBy, listConfig.getShowLinksToObjects(), listConfig.getPath(), listConfig.getLineLength());
        }
        catch (PathException e) {
            throw new RuntimeException("Your collections of inline listsare failing you", e);
        }
        if (listConfig.getShowInHeader().booleanValue()) {
            this.inlineListsHeader.add(list);
        } else {
            this.inlineListsNormal.add(list);
        }
        path = listConfig.getPath();
        bagOfInlineListNames.put(((String)path).substring(0, ((String)path).indexOf(46)), true);
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("TIME initialiseInlineLists took: " + (endTime - startTime) + "ms"));
    }

    private void initialiseAttribute(FieldDescriptor fd) {
        long startTime = System.currentTimeMillis();
        this.attributes = this.attributes != null ? this.attributes : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.attributeDescriptors = this.attributeDescriptors != null ? this.attributeDescriptors : new HashMap();
        Object fieldValue = null;
        try {
            fieldValue = this.object.getFieldValue(fd.getName());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (fieldValue != null) {
            if (fieldValue instanceof ClobAccess) {
                ClobAccess fieldClob = (ClobAccess)fieldValue;
                fieldValue = fieldClob.length() > 200 ? fieldClob.subSequence(0, 200).toString() : fieldClob.toString();
            }
            this.attributes.put(fd.getName(), fieldValue);
            this.attributeDescriptors.put(fd.getName(), fd);
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("TIME initialiseAttribute " + fd.getName() + " took: " + (endTime - startTime) + "ms"));
    }

    private void initialiseReference(FieldDescriptor fd) {
        long startTime = System.currentTimeMillis();
        this.references = this.references != null ? this.references : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        ReferenceDescriptor ref = (ReferenceDescriptor)fd;
        String refName = ref.getName();
        if (!this.nullRefsCols.contains(refName)) {
            Object proxyObject = null;
            ProxyReference proxy = null;
            try {
                proxyObject = this.object.getFieldProxy(refName);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (proxyObject instanceof ProxyReference) {
                proxy = (ProxyReference)proxyObject;
            }
            DisplayReference newReference = null;
            try {
                newReference = new DisplayReference(proxy, ref, this.webConfig, (Map)this.im.getClassKeys(), this.objectType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newReference != null) {
                this.references.put(refName, newReference);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("TIME initialiseReference " + fd.getName() + " took: " + (endTime - startTime) + "ms"));
    }

    private void initialiseCollection(FieldDescriptor fd) {
        long startTime = System.currentTimeMillis();
        this.collections = this.collections != null ? this.collections : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        String colName = fd.getName();
        if (!this.nullRefsCols.contains(colName)) {
            Object fieldValue = null;
            try {
                fieldValue = this.object.getFieldValue(colName);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            long queryStartTime = System.currentTimeMillis();
            List listOfTypes = PathQueryResultHelper.queryForTypesInCollection((InterMineObject)this.object, (String)colName, (ObjectStore)this.im.getObjectStore());
            long queryTime = System.currentTimeMillis() - queryStartTime;
            LOG.info((Object)("TIME - query for types in collection: " + colName + " took: " + queryTime));
            DisplayCollection newCollection = null;
            try {
                newCollection = new DisplayCollection((Collection)fieldValue, (CollectionDescriptor)fd, this.webConfig, this.webProperties, (Map)this.im.getClassKeys(), listOfTypes, this.objectType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newCollection != null) {
                this.collections.put(colName, newCollection);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("TIME initialiseCollection " + fd.getName() + " took: " + (endTime - startTime) + "ms"));
    }

    private void initialise() {
        long startTime = System.currentTimeMillis();
        this.refsAndCollections = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.inlineListsHeader = this.inlineListsHeader != null ? this.inlineListsHeader : new ArrayList();
        this.inlineListsNormal = this.inlineListsNormal != null ? this.inlineListsNormal : new ArrayList();
        Type type = (Type)this.webConfig.getTypes().get(this.getClassDescriptor().getName());
        List inlineListsWebConfig = type.getInlineListConfig();
        HashMap bagOfInlineListNames = new HashMap();
        for (Object listConfig : inlineListsWebConfig) {
            this.initialiseInlineList((InlineListConfig)listConfig, bagOfInlineListNames);
        }
        this.nullRefsCols = this.im.getObjectStoreSummary().getNullReferencesAndCollections(this.getClassDescriptor().getName());
        Set replacedFields = this.getReplacedFieldExprs();
        for (FieldDescriptor fd : this.getClassDescriptor().getAllFieldDescriptors()) {
            if (!bagOfInlineListNames.containsKey(fd.getName()) && !replacedFields.contains(fd.getName())) {
                if (fd.isAttribute() && !"id".equals(fd.getName())) {
                    this.initialiseAttribute(fd);
                    continue;
                }
                if (fd.isReference()) {
                    this.initialiseReference(fd);
                    continue;
                }
                if (!fd.isCollection()) continue;
                this.initialiseCollection(fd);
                continue;
            }
            this.setDescriptorOnInlineList(fd.getName(), fd);
        }
        if (this.references != null) {
            this.refsAndCollections.putAll(this.references);
        }
        if (this.collections != null) {
            this.refsAndCollections.putAll(this.collections);
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("TIME initialise took: " + (endTime - startTime) + "ms"));
    }

    public Map<String, DisplayField> getRefsAndCollections() {
        if (this.refsAndCollections == null) {
            this.initialise();
        }
        return this.refsAndCollections;
    }

    public Set<String> getReplacedFieldExprs() {
        if (this.replacedFieldExprs == null) {
            this.replacedFieldExprs = new HashSet();
            for (ReportDisplayer reportDisplayer : this.getAllReportDisplayers()) {
                this.replacedFieldExprs.addAll(reportDisplayer.getReplacedFieldExprs());
            }
        }
        return this.replacedFieldExprs;
    }

    private Set<ReportDisplayer> getAllReportDisplayers() {
        DisplayerManager displayerManager = DisplayerManager.getInstance((WebConfig)this.webConfig, (InterMineAPI)this.im);
        String clsName = DynamicUtil.getSimpleClass((FastPathObject)this.object).getSimpleName();
        return displayerManager.getAllReportDisplayersForType(clsName);
    }

    public Map<String, FieldDescriptor> getAttributeDescriptors() {
        if (this.attributeDescriptors == null) {
            this.initialise();
        }
        return this.attributeDescriptors;
    }

    private void setDescriptorOnInlineList(String name, FieldDescriptor fd) {
        for (InlineList list : this.inlineListsNormal) {
            String path = list.getPath();
            if (!path.substring(0, path.indexOf(46)).equals(name)) continue;
            list.setDescriptor(fd);
            break;
        }
    }

    public List<InlineList> getNormalInlineLists() {
        if (this.inlineListsNormal == null) {
            this.initialise();
        }
        return this.inlineListsNormal;
    }

    public List<InlineList> getHeaderInlineLists() {
        if (this.inlineListsHeader == null) {
            this.initialise();
        }
        return this.inlineListsHeader;
    }

    public Boolean getHasHeaderInlineLists() {
        return this.getHeaderInlineLists() != null;
    }

    public Boolean getHasNormalInlineLists() {
        return this.getNormalInlineLists() != null;
    }
}

