/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import org.intermine.web.logic.SortableMap;
import org.intermine.web.logic.widget.ErrorCorrection;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ErrorCorrection {
    protected static final BigDecimal ZERO = new BigDecimal(0);
    protected static final BigDecimal ONE = new BigDecimal(1);

    private ErrorCorrection() {
    }

    public static Map<String, BigDecimal> adjustPValues(Strategy errorCorrection, Map<String, BigDecimal> results, Double max, int testCount) {
        switch (1.$SwitchMap$org$intermine$web$logic$widget$ErrorCorrection$Strategy[errorCorrection.ordinal()]) {
            case 1: {
                return ErrorCorrection.calculate(results, (Double)max);
            }
            case 2: {
                return ErrorCorrection.calculateBonferroni(results, (int)testCount, (Double)max);
            }
            case 3: {
                return ErrorCorrection.calculateBenjaminiHochberg(results, (int)testCount, (Double)max);
            }
            case 4: {
                return ErrorCorrection.calculateBonferroniHolm(results, (int)testCount, (Double)max);
            }
        }
        throw new IllegalArgumentException("Unsupported strategy: " + errorCorrection);
    }

    public static Map<String, BigDecimal> sortMap(Map<String, BigDecimal> originalMap) {
        SortableMap sortedMap = new SortableMap(originalMap);
        sortedMap.sortValues(false, true);
        return sortedMap;
    }

    private static Map<String, BigDecimal> calculate(Map<String, BigDecimal> results, Double max) {
        HashMap<String, BigDecimal> adjustedMap = new HashMap<String, BigDecimal>();
        for (String id : results.keySet()) {
            BigDecimal pvalue = results.get(id);
            if (!(pvalue.doubleValue() <= max)) continue;
            adjustedMap.put(id, pvalue);
        }
        return adjustedMap;
    }

    private static Map<String, BigDecimal> calculateBonferroni(Map<String, BigDecimal> results, int numberOfTests, Double max) {
        HashMap<String, BigDecimal> adjustedMap = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, BigDecimal> entry : results.entrySet()) {
            BigDecimal p = entry.getValue();
            BigDecimal adjustedP = p.multiply(new BigDecimal(numberOfTests), MathContext.DECIMAL128);
            if (adjustedP.compareTo(ONE) >= 0) {
                adjustedP = ONE;
            }
            if (!(adjustedP.doubleValue() <= max)) continue;
            adjustedMap.put(entry.getKey(), adjustedP);
        }
        return adjustedMap;
    }

    private static Map<String, BigDecimal> calculateBenjaminiHochberg(Map<String, BigDecimal> results, int numberOfTests, Double max) {
        HashMap<String, BigDecimal> adjustedResults = new HashMap<String, BigDecimal>();
        Map sortedResults = ErrorCorrection.sortMap(results);
        BigDecimal lastValue = null;
        int i = 1;
        BigDecimal index = ONE;
        for (Map.Entry entry : sortedResults.entrySet()) {
            BigDecimal m;
            BigDecimal adjustedP;
            BigDecimal p = (BigDecimal)entry.getValue();
            if (lastValue == null || p.compareTo(lastValue) != 0) {
                index = new BigDecimal(i);
            }
            if ((adjustedP = p.multiply(m = new BigDecimal(numberOfTests).divide(index, MathContext.DECIMAL128), MathContext.DECIMAL128)).compareTo(ONE) > 0) {
                adjustedP = ONE;
            }
            if (!(adjustedP.doubleValue() <= max)) {
                return adjustedResults;
            }
            adjustedResults.put((String)entry.getKey(), adjustedP);
            lastValue = p;
            ++i;
        }
        return adjustedResults;
    }

    private static Map<String, BigDecimal> calculateBonferroniHolm(Map<String, BigDecimal> results, int numberOfTests, Double max) {
        HashMap<String, BigDecimal> adjustedResults = new HashMap<String, BigDecimal>();
        Map sortedResults = ErrorCorrection.sortMap(results);
        BigDecimal lastValue = null;
        int i = 0;
        BigDecimal rank = ZERO;
        for (Map.Entry entry : sortedResults.entrySet()) {
            BigDecimal adjustedP;
            BigDecimal p = (BigDecimal)entry.getValue();
            BigDecimal m = null;
            if (lastValue != null && p.compareTo(lastValue) != 0) {
                rank = new BigDecimal(i);
            }
            if (!((adjustedP = p.multiply(m = new BigDecimal(numberOfTests).subtract(rank, MathContext.DECIMAL128), MathContext.DECIMAL128)).doubleValue() <= max)) {
                return adjustedResults;
            }
            adjustedResults.put((String)entry.getKey(), adjustedP);
            lastValue = p;
            ++i;
        }
        return adjustedResults;
    }
}

