/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.TagManager;
import org.intermine.api.tag.AspectTagUtil;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.userprofile.Tag;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.logic.PermanentURIHelper;
import org.intermine.web.logic.results.DisplayCollection;
import org.intermine.web.logic.results.DisplayField;
import org.intermine.web.logic.results.DisplayReference;
import org.intermine.web.logic.results.InlineList;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.results.ReportObjectFactory;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportController
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(ReportController.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InterMineObject requestedObject;
        long startTime = System.currentTimeMillis();
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        if (im.getBagManager().isAnyBagToUpgrade(SessionMethods.getProfile((HttpSession)session))) {
            this.recordError(new ActionMessage("login.upgradeListManually"), request);
        }
        if ((requestedObject = this.getRequestedObject(im, request)) != null) {
            ReportObjectFactory reportObjectFactory = SessionMethods.getReportObjects((HttpSession)session);
            ReportObject reportObject = reportObjectFactory.get((Object)requestedObject);
            request.setAttribute("object", (Object)reportObject);
            request.setAttribute("reportObject", (Object)reportObject);
            request.setAttribute("requestedObject", (Object)requestedObject);
            TagManager tm = im.getTagManager();
            ServletContext servletContext = session.getServletContext();
            ObjectStore os = im.getObjectStore();
            String superuser = im.getProfileManager().getSuperuser();
            if (superuser.equals(SessionMethods.getProfile((HttpSession)session).getUsername())) {
                request.setAttribute("SHOW_TAGS", (Object)true);
            }
            TreeMap<String, ArrayList<InlineList>> placedInlineLists = new TreeMap<String, ArrayList<InlineList>>();
            for (InlineList list : reportObject.getNormalInlineLists()) {
                FieldDescriptor fd = list.getDescriptor();
                String taggedType = this.getTaggedType(fd);
                String fieldPath = fd.getClassDescriptor().getUnqualifiedName() + "." + fd.getName();
                for (String tagName : tm.getObjectTagNames(fieldPath, taggedType, superuser)) {
                    if (AspectTagUtil.isAspectTag((String)tagName)) {
                        ArrayList<InlineList> listsForAspect = (ArrayList<InlineList>)placedInlineLists.get(tagName);
                        if (listsForAspect == null) {
                            listsForAspect = new ArrayList<InlineList>();
                            placedInlineLists.put(tagName, listsForAspect);
                        }
                        listsForAspect.add(list);
                        continue;
                    }
                    if (!"im:summary".equals(tagName)) continue;
                    ArrayList<InlineList> summaryLists = (ArrayList<InlineList>)placedInlineLists.get(tagName);
                    if (summaryLists == null) {
                        summaryLists = new ArrayList<InlineList>();
                        placedInlineLists.put(tagName, summaryLists);
                    }
                    summaryLists.add(list);
                }
            }
            ArrayList unplacedInlineLists = new ArrayList(reportObject.getNormalInlineLists());
            unplacedInlineLists.removeAll(placedInlineLists.values());
            long now = System.currentTimeMillis();
            LOG.info((Object)("TIME placed inline lists: " + (now - startTime) + "ms"));
            long stepTime = now;
            request.setAttribute("mapOfInlineLists", placedInlineLists);
            request.setAttribute("listOfUnplacedInlineLists", unplacedInlineLists);
            TreeMap placementRefsAndCollections = new TreeMap();
            LinkedHashSet aspects = new LinkedHashSet(SessionMethods.getCategories((ServletContext)servletContext));
            Set cds = os.getModel().getClassDescriptorsForClass(requestedObject.getClass());
            for (String aspect : aspects) {
                placementRefsAndCollections.put("im:aspect:" + aspect, new TreeMap(String.CASE_INSENSITIVE_ORDER));
            }
            TreeMap miscRefs = new TreeMap(reportObject.getRefsAndCollections());
            placementRefsAndCollections.put("im:aspect:Miscellaneous", miscRefs);
            TreeMap summaryRefsCols = new TreeMap();
            placementRefsAndCollections.put("im:summary", summaryRefsCols);
            for (Map.Entry entry : reportObject.getRefsAndCollections().entrySet()) {
                DisplayField df = (DisplayField)entry.getValue();
                if (df instanceof DisplayReference) {
                    ReportController.categoriseBasedOnTags((FieldDescriptor)((DisplayReference)df).getDescriptor(), (String)"reference", (DisplayField)df, miscRefs, (TagManager)tm, (String)superuser, placementRefsAndCollections, (boolean)SessionMethods.isSuperUser((HttpSession)session));
                    continue;
                }
                if (!(df instanceof DisplayCollection)) continue;
                ReportController.categoriseBasedOnTags((FieldDescriptor)((DisplayCollection)df).getDescriptor(), (String)"collection", (DisplayField)df, miscRefs, (TagManager)tm, (String)superuser, placementRefsAndCollections, (boolean)SessionMethods.isSuperUser((HttpSession)session));
            }
            this.removeFieldsReplacedByReportDisplayers(reportObject, placementRefsAndCollections);
            request.setAttribute("placementRefsAndCollections", placementRefsAndCollections);
            String type = reportObject.getType();
            request.setAttribute("objectType", (Object)type);
            String idString = request.getParameter("id");
            String fairPermanentLink = new PermanentURIHelper(request).getPermanentURL(Integer.valueOf(Integer.parseInt(idString)));
            if (fairPermanentLink != null) {
                request.setAttribute("stableLink", (Object)fairPermanentLink);
            }
            startTime = stepTime = System.currentTimeMillis();
            HashSet<String> allClasses = new HashSet<String>();
            for (ClassDescriptor cld : cds) {
                allClasses.add(cld.getUnqualifiedName());
            }
            TemplateManager templateManager = im.getTemplateManager();
            Map displayerMap = reportObject.getReportDisplayers();
            startTime = stepTime = System.currentTimeMillis();
            LinkedList<String> categories = new LinkedList<String>();
            for (String aspect : aspects) {
                Iterator iterator;
                if (displayerMap != null && displayerMap.containsKey(aspect) || placedInlineLists.containsKey(aspect)) {
                    categories.add(aspect);
                    continue;
                }
                if (!templateManager.getReportPageTemplatesForAspect(aspect, allClasses).isEmpty()) {
                    categories.add(aspect);
                    continue;
                }
                if (!placementRefsAndCollections.containsKey("im:aspect:" + aspect) || placementRefsAndCollections.get("im:aspect:" + aspect) == null || !(iterator = ((Map)placementRefsAndCollections.get("im:aspect:" + aspect)).values().iterator()).hasNext()) continue;
                DisplayField df = (DisplayField)iterator.next();
                categories.add(aspect);
            }
            if (!categories.isEmpty()) {
                request.setAttribute("categories", categories);
            }
            now = System.currentTimeMillis();
            LOG.info((Object)("TIME made list of categories: " + (now - stepTime) + "ms"));
        }
        return null;
    }

    private InterMineObject getRequestedObject(InterMineAPI im, HttpServletRequest request) {
        String idString = request.getParameter("id");
        if (!StringUtils.isNumeric((String)idString) || StringUtils.isBlank((String)idString)) {
            return null;
        }
        Integer id = new Integer(Integer.parseInt(idString));
        ObjectStore os = im.getObjectStore();
        InterMineObject requestedObject = null;
        try {
            requestedObject = os.getObjectById(id);
        }
        catch (ObjectStoreException e) {
            LOG.warn((Object)("Accessed report page with id: " + id + " but failed to find object."), (Throwable)e);
        }
        return requestedObject;
    }

    private String getTaggedType(FieldDescriptor fd) {
        if (fd.isCollection()) {
            return "collection";
        }
        if (fd.isReference()) {
            return "reference";
        }
        return "attribute";
    }

    public static void categoriseBasedOnTags(FieldDescriptor fd, String taggedType, DisplayField dispRef, Map<String, DisplayField> miscRefs, TagManager tagManager, String sup, Map<String, Map<String, DisplayField>> placementRefsAndCollections, boolean isSuperUser) {
        List tags = tagManager.getTags(null, fd.getClassDescriptor().getUnqualifiedName() + "." + fd.getName(), taggedType, sup);
        for (Tag tag : tags) {
            String tagName = tag.getTagName();
            if (!isSuperUser && tagName.equals("im:hidden")) {
                ReportController.removeField((String)fd.getName(), placementRefsAndCollections);
                return;
            }
            if (AspectTagUtil.isAspectTag((String)tagName)) {
                Map<String, DisplayField> refs = placementRefsAndCollections.get(tagName);
                if (refs == null) continue;
                refs.put(fd.getName(), dispRef);
                miscRefs.remove(fd.getName());
                continue;
            }
            if (!tagName.equals("im:summary")) continue;
            Map<String, DisplayField> summary = placementRefsAndCollections.get("im:summary");
            if (summary != null) {
                summary.put(fd.getName(), dispRef);
                miscRefs.remove(fd.getName());
            }
            miscRefs.remove(fd.getName());
        }
    }

    private void removeFieldsReplacedByReportDisplayers(ReportObject reportObject, Map<String, Map<String, DisplayField>> placementRefsAndCollections) {
        for (String fieldName : reportObject.getReplacedFieldExprs()) {
            ReportController.removeField((String)fieldName, placementRefsAndCollections);
        }
    }

    private static void removeField(String name, Map<String, Map<String, DisplayField>> placementRefsAndCollections) {
        for (Map.Entry<String, Map<String, DisplayField>> entry : placementRefsAndCollections.entrySet()) {
            entry.getValue().remove(name);
        }
    }
}

