/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.StringUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;

public class VersionService
extends JSONService {
    private String versionType;

    public VersionService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        if (this.versionType.startsWith("release")) {
            this.addResultValue((CharSequence)this.webProperties.getProperty("project.releaseVersion"), false);
        } else if (this.versionType.startsWith("intermine")) {
            this.addResultValue((CharSequence)"5.1.0", false);
        } else {
            this.addResultValue((Number)35, false);
        }
    }

    protected void initState() {
        super.initState();
        this.versionType = StringUtils.lowerCase((String)StringUtil.trimSlashes((String)StringUtils.defaultString((String)this.request.getPathInfo(), (String)"ws")));
    }

    protected Map<String, Object> getHeaderAttributes() {
        Map attributes = super.getHeaderAttributes();
        if (Format.HTML == this.getFormat()) {
            ArrayList<String> headers = new ArrayList<String>();
            String header = null;
            header = this.versionType.startsWith("release") ? "Release" : (this.versionType.startsWith("intermine") ? "InterMine release" : "API Version");
            headers.add(header);
            attributes.put("headers", headers);
        }
        return attributes;
    }

    protected Format getDefaultFormat() {
        if (this.hasCallback()) {
            return Format.JSON;
        }
        return Format.TEXT;
    }

    protected String getResultsKey() {
        return "version";
    }

    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.HTML || format == Format.TEXT;
    }
}

