/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.metadata.StringUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebServiceInput;
import org.intermine.webservice.server.exceptions.BadRequestException;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebServiceRequestParser {
    public static final int MIN_LIMIT = 1;
    public static final String START_PARAMETER = "start";
    public static final String LIMIT_PARAMETER = "size";
    private static final Integer DEFAULT_START = new Integer(0);
    public static final Integer DEFAULT_LIMIT = new Integer(10000000);
    private static final Integer MAX_LIMIT = new Integer(10000000);
    public static final String FORMAT_PARAMETER_XML = "xml";
    public static final String FORMAT_PARAMETER_TAB = "tab";
    public static final String FORMAT_PARAMETER_TSV = "tsv";
    public static final String FORMAT_PARAMETER_TEXT = "text";
    public static final String FORMAT_PARAMETER_HTML = "html";
    public static final String FORMAT_PARAMETER_CSV = "csv";
    public static final String FORMAT_PARAMETER_COUNT = "count";
    public static final String FORMAT_PARAMETER_JSON = "json";
    public static final String FORMAT_PARAMETER_JSONP = "jsonp";
    public static final String FORMAT_PARAMETER_JSON_OBJ = "jsonobjects";
    public static final String FORMAT_PARAMETER_JSONP_OBJ = "jsonpobjects";
    public static final String FORMAT_PARAMETER_JSON_TABLE = "jsontable";
    public static final String FORMAT_PARAMETER_JSONP_TABLE = "jsonptable";
    public static final String FORMAT_PARAMETER_JSON_ROW = "jsonrows";
    public static final String FORMAT_PARAMETER_JSONP_ROW = "jsonprows";
    public static final String FORMAT_PARAMETER_JSON_COUNT = "jsoncount";
    public static final String FORMAT_PARAMETER_JSONP_COUNT = "jsonpcount";
    public static final String FORMAT_PARAMETER_RDF = "rdf";
    public static final String FORMAT_PARAMETER_N_TRIPLES = "ntriples";
    public static final String OUTPUT_PARAMETER = "format";
    public static final String CALLBACK_PARAMETER = "callback";
    public static final String ADD_HEADER_PARAMETER = "columnheaders";
    public static final String FORMAT_PARAMETER_ANY = "*/*";
    public static final String FILENAME_PARAMETER = "filename";
    private static final Map<String, Format> FORMAT_MAPPING = new /* Unavailable Anonymous Inner Class!! */;
    private static final Map<String, String> ACCEPT_TYPES = new /* Unavailable Anonymous Inner Class!! */;

    public void parseRequest(HttpServletRequest request, WebServiceInput input) {
        Integer limit;
        input.setLimit(DEFAULT_LIMIT);
        input.setStart(DEFAULT_START);
        Integer start = this.parseInteger(request.getParameter("start"), "start", 0, Integer.MAX_VALUE);
        if (start != null) {
            input.setStart(start);
        }
        if ((limit = this.parseInteger(request.getParameter("size"), "size", 1, MAX_LIMIT.intValue())) != null) {
            input.setLimit(limit);
        }
    }

    private Integer parseInteger(String stringValue, String name, int minValue, int maxValue) {
        Integer ret = null;
        if (stringValue != null && !"".equals(stringValue)) {
            try {
                ret = new Integer(stringValue);
                if (ret < minValue || ret > maxValue) {
                    throw new BadRequestException("Invalid value of " + name + " parameter: " + ret + " Parameter should have value from " + minValue + " to " + maxValue + ".");
                }
            }
            catch (Exception ex) {
                throw new BadRequestException("Invalid " + name + " parameter: " + stringValue);
            }
        }
        return ret;
    }

    protected static Format interpretFormat(String format) {
        if (StringUtils.isBlank((String)format)) {
            return Format.EMPTY;
        }
        Format mapped = (Format)FORMAT_MAPPING.get(format);
        if (mapped == null) {
            return Format.UNKNOWN;
        }
        return mapped;
    }

    public static boolean isJsonP(HttpServletRequest request) {
        if (!"GET".equals(request.getMethod())) {
            return false;
        }
        String accept = request.getHeader("Accept");
        if (StringUtils.isNotBlank((String)accept) && accept.startsWith("application/jsonp")) {
            return true;
        }
        String formatParam = request.getParameter("format");
        if (StringUtils.isNotBlank((String)formatParam) && formatParam.contains("jsonp")) {
            return true;
        }
        String callback = request.getParameter("callback");
        return StringUtils.isNotBlank((String)callback);
    }

    private static List<Format> parseAcceptHeader(HttpServletRequest request) {
        String[] preferences;
        ArrayList<Format> areAcceptable = new ArrayList<Format>();
        String accept = request.getHeader("Accept");
        if (accept != null && (preferences = accept.split(",")) != null) {
            for (String pref : preferences) {
                if (pref == null) {
                    areAcceptable.add(Format.EMPTY);
                    continue;
                }
                if ((pref = pref.trim().toLowerCase()).startsWith("*")) {
                    areAcceptable.add(Format.DEFAULT);
                    continue;
                }
                String[] parts = pref.split(";");
                String type = parts[0].trim();
                if (ACCEPT_TYPES.containsKey(type)) {
                    areAcceptable.add(Format.valueOf((String)((String)ACCEPT_TYPES.get(type))));
                    continue;
                }
                if ("application/json".equals(type) || "text/javascript".equals(type) || "application/javascript".equals(type) || "application/jsonp".equals(type)) {
                    if (parts.length > 1) {
                        for (int i = 1; i < parts.length; ++i) {
                            String option = parts[i].trim();
                            if (!option.startsWith("type=")) continue;
                            String subType = option.substring(5);
                            if ("objects".equalsIgnoreCase(subType)) {
                                areAcceptable.add(Format.OBJECTS);
                                continue;
                            }
                            if ("table".equalsIgnoreCase(subType)) {
                                areAcceptable.add(Format.TABLE);
                                continue;
                            }
                            if (!"rows".equalsIgnoreCase(subType)) continue;
                            areAcceptable.add(Format.ROWS);
                        }
                    }
                    areAcceptable.add(Format.JSON);
                    continue;
                }
                areAcceptable.add(Format.UNKNOWN);
            }
        }
        return areAcceptable;
    }

    protected static Format parseFormatFromPathInfo(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if ((pathInfo = StringUtil.trimSlashes((String)pathInfo)) != null) {
            if (!pathInfo.contains("/")) {
                pathInfo = "/" + pathInfo;
            }
            if (pathInfo.endsWith("/xml")) {
                return Format.XML;
            }
            if (pathInfo.endsWith("/json")) {
                return Format.JSON;
            }
            if (pathInfo.endsWith("/jsonp")) {
                return Format.JSON;
            }
            if (pathInfo.endsWith("/tsv")) {
                return Format.TSV;
            }
            if (pathInfo.endsWith("/csv")) {
                return Format.CSV;
            }
            if (pathInfo.endsWith("/txt")) {
                return Format.TEXT;
            }
            if (pathInfo.endsWith("/rdf")) {
                return Format.RDF;
            }
            if (pathInfo.endsWith("/ntriples")) {
                return Format.N_TRIPLES;
            }
        }
        return null;
    }

    public static List<Format> getAcceptableFormats(HttpServletRequest request) {
        String fromParameter;
        ArrayList<Format> areAcceptable = new ArrayList<Format>();
        Format fromPathInfo = WebServiceRequestParser.parseFormatFromPathInfo((HttpServletRequest)request);
        if (fromPathInfo != null) {
            areAcceptable.add(fromPathInfo);
        }
        if (StringUtils.isNotBlank((String)(fromParameter = request.getParameter("format")))) {
            areAcceptable.add(WebServiceRequestParser.interpretFormat((String)fromParameter.trim()));
        }
        areAcceptable.addAll(WebServiceRequestParser.parseAcceptHeader((HttpServletRequest)request));
        return areAcceptable;
    }

    public static boolean isCountRequest(HttpServletRequest request) {
        String accept;
        String param;
        String doCount = request.getParameter("count");
        boolean count = Boolean.parseBoolean(doCount);
        if (!count && (param = request.getParameter("format")) != null && param.contains("count")) {
            count = true;
        }
        if (!count && (accept = request.getHeader("Accept")) != null && accept.contains("type=count")) {
            count = true;
        }
        return count;
    }
}

