/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.core.ListManager;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.lists.AvailableListsService;
import org.intermine.webservice.server.lists.ListsRequestParser;
import org.intermine.webservice.server.lists.ListsServiceInput;

public class ListsService
extends AvailableListsService {
    public ListsService(InterMineAPI im) {
        super(im);
    }

    protected Collection<InterMineBag> getLists() {
        ListsServiceInput input = this.getInput();
        Integer objectId = null;
        if (input.getMineId() == null ? (objectId = this.resolveMineId(this.request, input)) == null : !this.objectExists(this.request, objectId = input.getMineId())) {
            throw new ResourceNotFoundException("object with specified id doesn't exist.");
        }
        return new ListManager(this.im, this.getPermission().getProfile()).getListsContaining(objectId);
    }

    private boolean objectExists(HttpServletRequest request, Integer objectId) {
        ObjectStore os = this.im.getObjectStore();
        try {
            InterMineObject objectById = os.getObjectById(objectId);
            return objectById != null;
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Getting object with id " + objectId + " failed.");
        }
    }

    private Integer resolveMineId(HttpServletRequest request, ListsServiceInput input) {
        ExportResultsIterator it;
        Model model = this.im.getModel();
        if (model.getClassDescriptorByName(input.getType()) == null) {
            throw new BadRequestException("invalid type parameter. The specified type of the object doesn't exist: " + input.getType());
        }
        PathQuery pathQuery = new PathQuery(model);
        pathQuery.addConstraint((PathConstraint)Constraints.lookup((String)input.getType(), (String)input.getPublicId(), (String)input.getExtraValue()));
        pathQuery.addViews((Collection)this.getViewAccordingClasskeys(request, input.getType()));
        Profile profile = this.getPermission().getProfile();
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
        try {
            it = executor.execute(pathQuery);
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Error resolving external id.", (Throwable)e);
        }
        if (it.hasNext()) {
            List row = (List)it.next();
            if (it.hasNext()) {
                throw new BadRequestException("Multiple objects of type " + input.getType() + " with public id " + input.getPublicId() + " were found.");
            }
            return ((ResultElement)row.get(0)).getId();
        }
        throw new ResourceNotFoundException("No objects of type " + input.getType() + " with public id " + input.getPublicId() + " were found.");
    }

    private List<String> getViewAccordingClasskeys(HttpServletRequest request, String type) {
        ArrayList<String> ret = new ArrayList<String>();
        List descs = (List)this.im.getClassKeys().get((Object)type);
        for (FieldDescriptor desc : descs) {
            ret.add(type + "." + desc.getName());
        }
        return ret;
    }

    private ListsServiceInput getInput() {
        return new ListsRequestParser(this.request).getInput();
    }
}

