/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.intermine.api.InterMineAPI;
import org.intermine.api.rdf.Namespaces;
import org.intermine.api.rdf.RDFHelper;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.web.logic.PermanentURIHelper;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InterMineLUIConverter;
import org.intermine.webservice.server.core.ResultProcessor;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.RDFOutput;

public class RDFProcessor
extends ResultProcessor {
    private String uri;
    private InterMineLUIConverter luiConverter;
    private final InterMineAPI im;

    public RDFProcessor(HttpServletRequest request, InterMineAPI im) {
        this.im = im;
        this.uri = new PermanentURIHelper(request).getPermanentBaseURI();
        this.luiConverter = new InterMineLUIConverter();
    }

    public void write(Iterator<List<ResultElement>> resultIt, Output output) {
        Model model = ModelFactory.createDefaultModel();
        this.setKnownPrefixes(model);
        while (resultIt.hasNext()) {
            Resource resource = null;
            ClassDescriptor classDescriptor = null;
            List<ResultElement> row = resultIt.next();
            ClassDescriptor currentClassDesc = null;
            HashMap<String, Resource> resources = new HashMap<String, Resource>();
            for (ResultElement item : row) {
                FieldDescriptor fd;
                Path path = item.getPath();
                classDescriptor = path.getLastClassDescriptor();
                if (currentClassDesc == null || currentClassDesc != classDescriptor) {
                    currentClassDesc = classDescriptor;
                    Integer id = item.getId();
                    InterMineLUI lui = this.luiConverter.getInterMineLUI(id);
                    String resourceURI = lui != null ? this.uri.concat(lui.toString()) : this.uri.concat(id.toString());
                    resource = RDFHelper.createResource((String)resourceURI, (ClassDescriptor)classDescriptor, (Model)model);
                    resources.put(currentClassDesc.getName(), resource);
                    String stringPath = path.toString();
                    stringPath = stringPath.substring(0, stringPath.lastIndexOf("."));
                    Path partialPath = null;
                    try {
                        partialPath = new Path(this.im.getModel(), stringPath);
                        if (partialPath.endIsReference() || partialPath.endIsCollection()) {
                            FieldDescriptor rd = partialPath.getEndFieldDescriptor();
                            String parentToLink = partialPath.getSecondLastClassDescriptor().getName();
                            Resource parentResource = (Resource)resources.get(parentToLink);
                            parentResource.addProperty(RDFHelper.createIMProperty((FieldDescriptor)rd), (RDFNode)resource);
                        }
                    }
                    catch (PathException pe) {
                        throw new BadRequestException(stringPath + " is not a valid path");
                    }
                }
                if (!(fd = path.getEndFieldDescriptor()).isAttribute() || item.getField() == null) continue;
                resource.addProperty(RDFHelper.createIMProperty((FieldDescriptor)fd), item.getField().toString());
            }
        }
        ((RDFOutput)output).addResultItem(model);
    }

    private void setKnownPrefixes(Model model) {
        Map namespaces = Namespaces.getNamespaces();
        for (String prefix : namespaces.keySet()) {
            model.setNsPrefix(prefix, (String)namespaces.get(prefix));
        }
    }
}

