/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.BagNotFound;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreQueryDurationException;
import org.intermine.objectstore.query.Results;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.webservice.server.ColumnHeaderStyle;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.core.CountProcessor;
import org.intermine.webservice.server.core.ResultProcessor;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.FilteringResultIterator;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.JSONCountFormatter;
import org.intermine.webservice.server.output.JSONObjResultProcessor;
import org.intermine.webservice.server.output.JSONRowResultProcessor;
import org.intermine.webservice.server.output.JSONSummaryProcessor;
import org.intermine.webservice.server.output.JSONTableFormatter;
import org.intermine.webservice.server.output.JSONTableResultProcessor;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.RDFProcessor;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.query.AbstractQueryService;
import org.intermine.webservice.server.query.result.FrictionlessDataPackage;
import org.intermine.webservice.server.query.result.PathQueryBuilder;
import org.intermine.webservice.server.query.result.QueryResultInput;
import org.intermine.webservice.server.query.result.QueryResultRequestParser;
import org.intermine.webservice.server.query.result.QueryResultService;

public class QueryResultService
extends AbstractQueryService {
    public static final int BATCH_SIZE = 5000;
    protected Map<String, Object> attributes = new HashMap();
    private boolean wantsCount = false;
    protected PathQueryExecutor executor;
    FrictionlessDataPackage fdp;
    private static final Set<Format> MENU = new /* Unavailable Anonymous Inner Class!! */;

    public QueryResultService(InterMineAPI im) {
        super(im);
    }

    protected void execute() {
        QueryResultInput input = this.getInput();
        PathQueryBuilder builder = this.getQueryBuilder(input.getXml());
        PathQuery query = builder.getQuery();
        this.setHeaderAttributes(query, input.getStart(), input.getLimit());
        this.runPathQuery(query, input.getStart().intValue(), input.getLimit().intValue());
        if (this.wantsDataPackage()) {
            this.fdp = new FrictionlessDataPackage();
            this.fdp.exportDataPackage(query, this.request, this.executor, this.getFormatType());
            this.writeDataPackageAttributes();
        }
    }

    protected void initState() {
        super.initState();
        this.wantsCount = WebServiceRequestParser.isCountRequest((HttpServletRequest)this.request);
    }

    protected Format getDefaultFormat() {
        return Format.TSV;
    }

    protected boolean canServe(Format format) {
        return MENU.contains(format);
    }

    protected void postInit() {
        this.executor = this.getPathQueryExecutor();
    }

    protected void writeDataPackageAttributes() {
        try {
            ((StreamedOutput)this.output).writeFooter();
            this.out.flush();
            this.dataPackageOutput = this.makeJSONOutput(this.out, this.getLineBreak());
            ((ZipOutputStream)this.os).putNextEntry(new ZipEntry("datapackage.json"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            ((StreamedOutput)this.dataPackageOutput).writeLn(mapper.writeValueAsString((Object)this.fdp.dataPackageAttributes));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected void setHeaderAttributes(PathQuery pq, Integer start, Integer size) {
        String summaryPath;
        if (this.formatIsJSON()) {
            this.attributes.put("modelName", pq.getModel().getName());
            this.attributes.put("views", pq.getView());
            this.attributes.put("columnHeaders", WebUtil.formatPathQueryView((PathQuery)pq, (WebConfig)InterMineContext.getWebConfig()));
            this.attributes.put("start", String.valueOf(start));
            try {
                this.attributes.put("rootClass", pq.getRootClass());
            }
            catch (PathException e) {
                throw new ServiceException((Throwable)e);
            }
            summaryPath = this.request.getParameter("summaryPath");
            if (!StringUtils.isBlank((String)summaryPath)) {
                int count;
                try {
                    count = this.executor.uniqueColumnValues(pq, summaryPath);
                }
                catch (BagNotFound e) {
                    throw new BadRequestException(e.getMessage());
                }
                catch (ObjectStoreException e) {
                    throw new ServiceException("Problem getting unique column value count.", (Throwable)e);
                }
                this.attributes.put("uniqueValues", count);
            }
            if (this.formatIsJSONP()) {
                String callback = StringUtils.defaultString((String)this.getCallback(), (String)"makeResultsTable");
                this.attributes.put("callback", callback);
            }
        } else if (this.formatIsFlatFile() && this.wantsColumnHeaders()) {
            if (ColumnHeaderStyle.FRIENDLY == this.getColumnHeaderStyle()) {
                this.attributes.put("view", WebUtil.formatPathQueryView((PathQuery)pq, (WebConfig)InterMineContext.getWebConfig()));
            } else {
                this.attributes.put("view", pq.getView());
            }
        }
        switch (2.$SwitchMap$org$intermine$webservice$server$Format[this.getFormat().ordinal()]) {
            case 1: {
                ArrayList<String> viewTypes = new ArrayList<String>();
                for (String v : pq.getView()) {
                    try {
                        Path p = pq.makePath(v);
                        AttributeDescriptor ad = (AttributeDescriptor)p.getEndFieldDescriptor();
                        viewTypes.add(ad.getType());
                    }
                    catch (PathException e) {
                        throw new ServiceException((Throwable)e);
                    }
                }
                String title = pq.getTitle();
                String description = StringUtils.defaultString((String)pq.getDescription(), (String)pq.toString());
                this.attributes.put("viewTypes", viewTypes);
                this.attributes.put("size", String.valueOf(size));
                this.attributes.put("title", title);
                this.attributes.put("description", description);
                break;
            }
            case 2: {
                this.attributes.put("headers", WebUtil.formatPathQueryView((PathQuery)pq, (WebConfig)InterMineContext.getWebConfig()));
                break;
            }
        }
        if (!this.wantsCount && StringUtils.isNotBlank((String)(summaryPath = this.getOptionalParameter("summaryPath")))) {
            Path p;
            try {
                p = pq.makePath(summaryPath);
            }
            catch (PathException e) {
                throw new BadRequestException("Summary path is invalid");
            }
            if (!p.endIsAttribute()) {
                throw new BadRequestException("Summary path is invalid");
            }
            AttributeDescriptor ad = (AttributeDescriptor)p.getEndFieldDescriptor();
            String type = ad.getType();
            ArrayList<String> colHeaders = new ArrayList<String>();
            if ("int".equals(type) || "Integer".equals(type) || "Float".equals(type) || "float".equals(type) || "Double".equals(type) || "double".equals(type) || "long".equals(type) || "Long".equals(type) || "Math.BigDecimal".equals(type)) {
                colHeaders.addAll(Arrays.asList("min", "max", "average", "standard-dev"));
            } else {
                colHeaders.addAll(Arrays.asList("item", "count"));
            }
            if (this.formatIsJSON()) {
                this.attributes.put("columnHeaders", colHeaders);
            } else if (this.formatIsFlatFile() && this.wantsColumnHeaders()) {
                this.attributes.put("view", colHeaders);
            }
        }
        this.output.setHeaderAttributes(this.attributes);
    }

    protected Output makeJSONOutput(PrintWriter out, String separator) {
        if (this.wantsCount) {
            return new StreamedOutput(out, (Formatter)new JSONCountFormatter(), separator);
        }
        return new StreamedOutput(out, (Formatter)new JSONTableFormatter(), separator);
    }

    protected static String encode(Object o) {
        if (o == null) {
            return "";
        }
        try {
            return URLEncoder.encode(o.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding string failed: " + o.toString(), e);
        }
    }

    private void runCount(PathQuery pathquery) {
        int count;
        try {
            count = this.executor.count(pathquery);
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Problem getting count.", (Throwable)e);
        }
        CountProcessor processor = new CountProcessor();
        processor.writeCount(count, this.output);
    }

    public void runPathQuery(PathQuery pathQuery, int firstResult, int maxResults) {
        if (this.wantsCount) {
            this.runCount(pathQuery);
        } else {
            this.runResults(pathQuery, firstResult, maxResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runResults(PathQuery pq, int firstResult, int maxResults) {
        boolean canGoFaster;
        ExportResultsIterator it;
        String summaryPath = this.getOptionalParameter("summaryPath");
        if (StringUtils.isNotBlank((String)summaryPath)) {
            Integer uniqs = (Integer)this.attributes.get("uniqueValues");
            boolean occurancesOnly = uniqs == null || uniqs < 2;
            try {
                String filterTerm = this.getOptionalParameter("filterTerm");
                Results r = this.executor.summariseQuery(pq, summaryPath, filterTerm, occurancesOnly);
                try {
                    r.range(0, 0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (filterTerm != null) {
                    this.attributes.put("filteredCount", r.size());
                }
                it = new FilteringResultIterator(r, firstResult, maxResults, filterTerm);
                canGoFaster = false;
            }
            catch (ObjectStoreQueryDurationException e) {
                throw new ServiceException("Query would take too long to run");
            }
            catch (ObjectStoreException e) {
                throw new ServiceException("Problem getting summary.", (Throwable)e);
            }
        }
        canGoFaster = maxResults > 10000;
        this.executor.setBatchSize(5000);
        try {
            it = this.executor.execute(pq, firstResult, maxResults);
        }
        catch (ObjectStoreQueryDurationException e) {
            throw new ServiceException("Query would take too long to run");
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Problem getting summary.", (Throwable)e);
        }
        ResultProcessor processor = this.makeResultProcessor();
        if (it.hasNext()) {
            try {
                if (canGoFaster) {
                    it.goFaster();
                }
                processor.write((Iterator)it, this.output);
            }
            finally {
                if (canGoFaster) {
                    it.releaseGoFaster();
                }
            }
        }
    }

    private ResultProcessor makeResultProcessor() {
        JSONObjResultProcessor processor;
        boolean summarising = StringUtils.isNotBlank((String)this.request.getParameter("summaryPath"));
        switch (2.$SwitchMap$org$intermine$webservice$server$Format[this.getFormat().ordinal()]) {
            case 3: {
                processor = new JSONRowResultProcessor(this.im, JSONRowResultProcessor.Verbosity.MINIMAL);
                break;
            }
            case 4: {
                processor = new JSONObjResultProcessor();
                break;
            }
            case 1: {
                processor = new JSONTableResultProcessor();
                break;
            }
            case 5: {
                if (summarising) {
                    processor = new JSONSummaryProcessor();
                    break;
                }
                processor = new JSONRowResultProcessor(this.im);
                break;
            }
            case 6: {
                processor = new RDFProcessor(this.request, this.im);
                break;
            }
            case 7: {
                processor = new RDFProcessor(this.request, this.im);
                break;
            }
            default: {
                processor = new ResultProcessor();
            }
        }
        return processor;
    }

    protected PathQueryExecutor getPathQueryExecutor() {
        Profile profile = this.getPermission().getProfile();
        return this.im.getPathQueryExecutor(profile);
    }

    private QueryResultInput getInput() {
        QueryResultInput qri = new QueryResultRequestParser(this.im.getQueryStore(), this.request).getInput();
        if (this.getFormat() == Format.TABLE) {
            qri.setLimit(Integer.valueOf(1));
        }
        return qri;
    }

    protected String getFormatType() {
        String format;
        switch (2.$SwitchMap$org$intermine$webservice$server$Format[this.getFormat().ordinal()]) {
            case 2: {
                format = "html";
                break;
            }
            case 8: {
                format = "xml";
                break;
            }
            case 9: {
                format = "tsv";
                break;
            }
            case 10: {
                format = "csv";
                break;
            }
            case 11: {
                format = "txt";
                break;
            }
            case 3: {
                format = "json";
                break;
            }
            case 4: {
                format = "objects";
                break;
            }
            case 1: {
                format = "table";
                break;
            }
            case 5: {
                format = "rows";
                break;
            }
            default: {
                format = "default";
            }
        }
        return format;
    }
}

