/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.webproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import org.intermine.api.InterMineAPI;
import org.intermine.util.PropertiesUtil;
import org.intermine.webservice.server.core.JSONService;

public class WebPropertiesService
extends JSONService {
    private static final String DEFAULT_PATH = "default";

    public WebPropertiesService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        HashMap webPropertiesMap = new HashMap();
        this.appendProperties(webPropertiesMap, "genomicRegionSearch");
        this.appendProperties(webPropertiesMap, "bag");
        this.appendProperties(webPropertiesMap, "quickSearch");
        this.appendProperties(webPropertiesMap, "project");
        this.appendProperties(webPropertiesMap, "bluegenes");
        this.appendProperties(webPropertiesMap, "list");
        this.appendProperties(webPropertiesMap, "services");
        this.appendOAuth2Providers(webPropertiesMap);
        this.addResultItem(webPropertiesMap, false);
    }

    public String getResultsKey() {
        return "web-properties";
    }

    private void appendProperties(Map<String, Object> webPropertiesMap, String startingPath) {
        Properties props = PropertiesUtil.getPropertiesStartingWith((String)startingPath, (Properties)this.webProperties);
        ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(keys, Collections.reverseOrder());
        HashMap thisPropertyMap = new HashMap();
        for (String keyString : keys) {
            String[] keyParts = keyString.split("\\.");
            LinkedList<String> path = new LinkedList<String>();
            for (int i = 1; i < keyParts.length; ++i) {
                path.add(keyParts[i]);
            }
            this.setProperty(thisPropertyMap, path, props.getProperty(keyString));
        }
        webPropertiesMap.put(startingPath, thisPropertyMap);
    }

    private void setProperty(Map<String, Object> propertyMap, Queue<String> path, String value) {
        String key = path.remove();
        if (path.isEmpty()) {
            Map thisLevel = (Map)propertyMap.get(key);
            if (thisLevel == null || thisLevel.isEmpty()) {
                propertyMap.put(key, value);
            } else {
                this.setProperty(thisLevel, new LinkedList<String>(Arrays.asList(DEFAULT_PATH)), value);
            }
        } else {
            Map thisLevel;
            if (!propertyMap.containsKey(key)) {
                thisLevel = new HashMap();
                propertyMap.put(key, thisLevel);
            } else {
                thisLevel = (Map)propertyMap.get(key);
            }
            this.setProperty(thisLevel, path, value);
        }
    }

    private void appendOAuth2Providers(Map<String, Object> webPropertiesMap) {
        LinkedHashSet<String> providers = new LinkedHashSet<String>();
        String oauth2Providers = this.webProperties.getProperty("oauth2.providers", "");
        for (String provider : oauth2Providers.split(",")) {
            String providerName = provider.trim().toUpperCase();
            if (!this.webProperties.containsKey("oauth2." + providerName + ".client-id")) continue;
            providers.add(providerName);
        }
        webPropertiesMap.put("OAUTH2_PROVIDERS".toLowerCase(), providers);
    }
}

