/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.widget.GraphWidget;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.WidgetOptions;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.widget.FlatFileWidgetResultProcessor;
import org.intermine.webservice.server.widget.GraphJSONProcessor;
import org.intermine.webservice.server.widget.GraphService;
import org.intermine.webservice.server.widget.GraphXMLProcessor;
import org.intermine.webservice.server.widget.WidgetResultProcessor;
import org.intermine.webservice.server.widget.WidgetService;
import org.intermine.webservice.server.widget.WidgetsRequestParser;
import org.intermine.webservice.server.widget.WidgetsServiceInput;

public class GraphService
extends WidgetService {
    private final WidgetsRequestParser requestParser = new WidgetsRequestParser();

    public GraphService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        WidgetsServiceInput input = this.requestParser.getInput(this.request);
        InterMineBag imBag = this.retrieveBag(input.getBagName());
        this.addOutputListInfo(imBag);
        WebConfig webConfig = InterMineContext.getWebConfig();
        WidgetConfig widgetConfig = (WidgetConfig)webConfig.getWidgets().get(input.getWidgetId());
        if (widgetConfig == null || !(widgetConfig instanceof GraphWidgetConfig)) {
            throw new ResourceNotFoundException("Could not find a graph widget called \"" + input.getWidgetId() + "\"");
        }
        this.addOutputConfig(widgetConfig);
        String ids = input.getIds();
        String type = input.getType();
        String populationIds = input.getPopulationIds();
        String filterSelectedValue = input.filter;
        if (StringUtils.isBlank((String)filterSelectedValue)) {
            filterSelectedValue = this.getDefaultFilterValue(widgetConfig, imBag, ids);
        }
        this.addOutputFilter(widgetConfig, filterSelectedValue, imBag, ids);
        GraphWidget widget = null;
        try {
            widget = (GraphWidget)widgetConfig.getWidget(imBag, null, this.im.getObjectStore(), (WidgetOptions)input, ids, populationIds);
            widget.setType(type);
            widget.setClassKeys(this.im.getClassKeys());
            if (filterSelectedValue != null) {
                widget.setFilter(filterSelectedValue);
            }
            widget.process();
        }
        catch (ClassCastException e) {
            throw new ResourceNotFoundException("Could not find a graph widget called \"" + input.getWidgetId() + "\"", (Throwable)e);
        }
        this.addOutputInfo("notAnalysed", Integer.toString(widget.getNotAnalysed()));
        this.addOutputInfo("simplePathQuery", widget.getSimplePathQuery().toJson());
        this.addOutputInfo("pathQuery", widget.getPathQuery().toJson());
        if (type != null) {
            this.addOutputInfo("type", type);
        }
        this.addOutputResult((Widget)widget);
    }

    protected void addOutputConfig(WidgetConfig config) {
        super.addOutputConfig(config);
        GraphWidgetConfig graphConfig = (GraphWidgetConfig)config;
        this.addOutputInfo("chartType", graphConfig.getGraphType());
        this.addOutputAttribute("seriesValues", graphConfig.getSeriesValues());
        this.addOutputAttribute("seriesLabels", graphConfig.getSeriesLabels());
        this.addOutputAttribute("seriesPath", graphConfig.getSeriesPath());
        this.addOutputAttribute("domainLabel", graphConfig.getDomainLabel());
        this.addOutputAttribute("rangeLabel", graphConfig.getRangeLabel());
    }

    protected WidgetResultProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return GraphJSONProcessor.instance();
        }
        if (this.formatIsXML()) {
            return new GraphXMLProcessor();
        }
        return FlatFileWidgetResultProcessor.instance();
    }

    protected Output makeXMLOutput(PrintWriter out) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"result.xml");
        return new StreamedOutput(out, (Formatter)new GraphXMLFormatter(this, null));
    }
}

