/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.widget.WidgetsServiceInput;

public class WidgetsRequestParser {
    private static final String WIDGET_ID = "widget";
    static final String BAG_NAME = "list";
    static final String POPULATION_BAG_NAME_OLD = "population";
    static final String SAVE_POPULATION = "remember_population";
    static final String FILTER = "filter";
    static final String MAXP = "maxp";
    static final String ERROR_CORRECTION = "correction";
    static final String EXTRA_ATTRIBUTE = "gene_length_correction";
    static final String POPULATION_BAG_NAME = "current_population";
    static final String IDS = "ids";
    static final String TYPE = "type";
    static final String POPULATION_IDS = "populationIds";
    private Set<String> requiredParameters = new HashSet();
    private Map<String, String> defaults;
    private Set<String> conditionalParameters = new HashSet();

    public WidgetsRequestParser() {
        this.defaults = new HashMap();
        this.conditionalParameters.add(BAG_NAME);
        this.conditionalParameters.add(IDS);
        this.conditionalParameters.add(TYPE);
        this.requiredParameters.add(WIDGET_ID);
    }

    public void setDefaultValue(String name, String value) {
        this.defaults.put(name, value);
    }

    public void parameterIsRequired(String parameter) {
        this.requiredParameters.add(parameter);
    }

    private String getOrDefault(HttpServletRequest request, String parameter) {
        return StringUtils.defaultIfBlank((String)request.getParameter(parameter), (String)((String)this.defaults.get(parameter)));
    }

    public WidgetsServiceInput getInput(HttpServletRequest request) {
        HashSet<String> missingParameters = new HashSet<String>();
        HashSet<String> foundParameters = new HashSet<String>();
        for (String param : this.conditionalParameters) {
            if (StringUtils.isBlank((String)request.getParameter(param))) {
                missingParameters.add(param);
                continue;
            }
            foundParameters.add(param);
        }
        if (!foundParameters.isEmpty()) {
            missingParameters = new HashSet();
        }
        for (String param : this.requiredParameters) {
            if (!StringUtils.isBlank((String)request.getParameter(param))) continue;
            missingParameters.add(param);
        }
        if (!missingParameters.isEmpty()) {
            throw new BadRequestException("Bad parameters. I expected a value for each of " + this.requiredParameters + " and one of " + this.conditionalParameters + " but I didn't get any values for " + missingParameters);
        }
        WidgetsServiceInput.Builder ret = new WidgetsServiceInput.Builder();
        String widgetId = request.getParameter(WIDGET_ID);
        String bagName = request.getParameter(BAG_NAME);
        String populationBagName = request.getParameter(POPULATION_BAG_NAME);
        String savePopulation = request.getParameter(SAVE_POPULATION);
        String ids = request.getParameter(IDS);
        String type = request.getParameter(TYPE);
        String populationIds = request.getParameter(POPULATION_IDS);
        String filter = this.getOrDefault(request, FILTER);
        String maxP = this.getOrDefault(request, MAXP);
        String errorCorrection = this.getOrDefault(request, ERROR_CORRECTION);
        String extraAttribute = this.getOrDefault(request, EXTRA_ATTRIBUTE);
        String oldPopName = request.getParameter(POPULATION_BAG_NAME_OLD);
        if (StringUtils.isBlank((String)populationBagName) && !StringUtils.isBlank((String)oldPopName)) {
            populationBagName = oldPopName;
        }
        ret.setBagName(bagName);
        ret.setWidgetId(widgetId);
        ret.setFilter(filter);
        ret.setExtraAttribute(extraAttribute);
        ret.setCorrection(errorCorrection);
        ret.setPopulationBagName(populationBagName);
        ret.setIds(ids);
        ret.setType(type);
        ret.setPopulationIds(populationIds);
        ret.setSavePopulation("true".equalsIgnoreCase(savePopulation));
        if (!StringUtils.isBlank((String)maxP)) {
            try {
                ret.setMaxP(Double.parseDouble(maxP));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("The value of maxp should be a valid number.");
            }
            if (ret.getMaxPValue() < 0.0 || ret.getMaxPValue() > 1.0) {
                throw new BadRequestException("The value of maxp should be between 0 and 1.");
            }
        }
        return ret;
    }
}

