/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.intermine.metadata.FieldDescriptor;

public class AttributeDescriptor
extends FieldDescriptor {
    protected final String type;
    protected final String fairTerm;
    public static final Set<String> VALID_TYPES = new LinkedHashSet<String>(Arrays.asList("short", "int", "long", "float", "double", "boolean", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean", "java.lang.String", "java.util.Date", "java.math.BigDecimal", "java.util.UUID", "org.intermine.objectstore.query.ClobAccess"));

    public AttributeDescriptor(String name, String type, String fairTerm) {
        super(name);
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Type cannot be null or empty");
        }
        if (!VALID_TYPES.contains(type)) {
            throw new IllegalArgumentException("Type \"" + type + "\" is not valid - must be one of " + VALID_TYPES);
        }
        this.type = type;
        this.fairTerm = fairTerm;
    }

    public String getType() {
        return this.type;
    }

    public String getFairTerm() {
        return this.fairTerm;
    }

    @Override
    public int relationType() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeDescriptor) {
            AttributeDescriptor attr = (AttributeDescriptor)obj;
            return this.name.equals(attr.name) && this.type.equals(attr.type);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.name.hashCode() + 7 * this.type.hashCode();
    }

    public String toString() {
        if (this.fairTerm != null) {
            return "<attribute name=\"" + this.name + "\" type=\"" + this.type + "\" term=\"" + this.fairTerm + "\"/>";
        }
        return "<attribute name=\"" + this.name + "\" type=\"" + this.type + "\"/>";
    }

    @Override
    public String toJSONString() {
        if (this.fairTerm != null) {
            return "{\"name\":\"" + this.name + "\",\"type\":\"" + this.type + "\",\"term\":\"" + this.fairTerm + "\"}";
        }
        return "{\"name\":\"" + this.name + "\",\"type\":\"" + this.type + "\"}";
    }

    public boolean isPrimitive() {
        return "short".equals(this.type) || "int".equals(this.type) || "long".equals(this.type) || "float".equals(this.type) || "double".equals(this.type) || "boolean".equals(this.type);
    }

    public boolean isNumeric() {
        return "short".equals(this.type) || "java.lang.Short".equals(this.type) || "int".equals(this.type) || "java.lang.Integer".equals(this.type) || "long".equals(this.type) || "java.lang.Long".equals(this.type) || "float".equals(this.type) || "java.lang.Float".equals(this.type) || "double".equals(this.type) || "java.lang.Double".equals(this.type);
    }
}

