/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.util.ArrayList;
import java.util.List;

public final class ConstraintOp {
    private static List<ConstraintOp> values = new ArrayList<ConstraintOp>();
    private final String name;
    public static final ConstraintOp EQUALS = new ConstraintOp("=");
    public static final ConstraintOp EXACT_MATCH = new ConstraintOp("==");
    public static final ConstraintOp NOT_EQUALS = new ConstraintOp("!=");
    public static final ConstraintOp STRICT_NOT_EQUALS = new ConstraintOp("!==");
    public static final ConstraintOp LESS_THAN = new ConstraintOp("<");
    public static final ConstraintOp LESS_THAN_EQUALS = new ConstraintOp("<=");
    public static final ConstraintOp GREATER_THAN = new ConstraintOp(">");
    public static final ConstraintOp GREATER_THAN_EQUALS = new ConstraintOp(">=");
    public static final ConstraintOp MATCHES = new ConstraintOp("LIKE");
    public static final ConstraintOp DOES_NOT_MATCH = new ConstraintOp("NOT LIKE");
    public static final ConstraintOp IS_NULL;
    public static final ConstraintOp IS_EMPTY;
    public static final ConstraintOp IS_NOT_NULL;
    public static final ConstraintOp IS_NOT_EMPTY;
    public static final ConstraintOp CONTAINS;
    public static final ConstraintOp DOES_NOT_CONTAIN;
    public static final ConstraintOp IN;
    public static final ConstraintOp NOT_IN;
    public static final ConstraintOp EXISTS;
    public static final ConstraintOp DOES_NOT_EXIST;
    public static final ConstraintOp AND;
    public static final ConstraintOp OR;
    public static final ConstraintOp NAND;
    public static final ConstraintOp NOR;
    public static final ConstraintOp LOOKUP;
    public static final ConstraintOp OVERLAPS;
    public static final ConstraintOp DOES_NOT_OVERLAP;
    public static final ConstraintOp ONE_OF;
    public static final ConstraintOp NONE_OF;
    public static final ConstraintOp WITHIN;
    public static final ConstraintOp OUTSIDE;
    public static final ConstraintOp ISA;
    public static final ConstraintOp ISNT;

    private ConstraintOp(String name) {
        this.name = name;
        values.add(this);
    }

    public String toString() {
        return this.name;
    }

    public Integer getIndex() {
        return new Integer(values.indexOf(this));
    }

    public static ConstraintOp getOpForIndex(Integer index) {
        return values.get(index);
    }

    public static List<ConstraintOp> getValues() {
        return values;
    }

    public ConstraintOp negate() {
        if (this == EQUALS) {
            return NOT_EQUALS;
        }
        if (this == EXACT_MATCH) {
            return STRICT_NOT_EQUALS;
        }
        if (this == NOT_EQUALS) {
            return EQUALS;
        }
        if (this == STRICT_NOT_EQUALS) {
            return EXACT_MATCH;
        }
        if (this == LESS_THAN) {
            return GREATER_THAN_EQUALS;
        }
        if (this == GREATER_THAN_EQUALS) {
            return LESS_THAN;
        }
        if (this == GREATER_THAN) {
            return LESS_THAN_EQUALS;
        }
        if (this == LESS_THAN_EQUALS) {
            return GREATER_THAN;
        }
        if (this == MATCHES) {
            return DOES_NOT_MATCH;
        }
        if (this == DOES_NOT_MATCH) {
            return MATCHES;
        }
        if (this == IS_NULL) {
            return IS_NOT_NULL;
        }
        if (this == IS_NOT_NULL) {
            return IS_NULL;
        }
        if (this == CONTAINS) {
            return DOES_NOT_CONTAIN;
        }
        if (this == DOES_NOT_CONTAIN) {
            return CONTAINS;
        }
        if (this == IN) {
            return NOT_IN;
        }
        if (this == NOT_IN) {
            return IN;
        }
        if (this == AND) {
            return NAND;
        }
        if (this == NAND) {
            return AND;
        }
        if (this == OR) {
            return NOR;
        }
        if (this == NOR) {
            return OR;
        }
        if (this == ONE_OF) {
            return NONE_OF;
        }
        if (this == NONE_OF) {
            return ONE_OF;
        }
        if (this == WITHIN) {
            return OUTSIDE;
        }
        if (this == OUTSIDE) {
            return WITHIN;
        }
        if (this == ISA) {
            return ISNT;
        }
        if (this == ISNT) {
            return ISA;
        }
        throw new IllegalArgumentException("Unknown op");
    }

    public static ConstraintOp getConstraintOp(String operationCode) {
        if (operationCode == null) {
            return null;
        }
        String opCode = operationCode.trim().toUpperCase();
        for (ConstraintOp op : values) {
            if (!op.getName().equalsIgnoreCase(opCode)) continue;
            return op;
        }
        return null;
    }

    private String getName() {
        return this.name;
    }

    static {
        IS_EMPTY = IS_NULL = new ConstraintOp("IS NULL");
        IS_NOT_EMPTY = IS_NOT_NULL = new ConstraintOp("IS NOT NULL");
        CONTAINS = new ConstraintOp("CONTAINS");
        DOES_NOT_CONTAIN = new ConstraintOp("DOES NOT CONTAIN");
        IN = new ConstraintOp("IN");
        NOT_IN = new ConstraintOp("NOT IN");
        EXISTS = CONTAINS;
        DOES_NOT_EXIST = DOES_NOT_CONTAIN;
        AND = new ConstraintOp("AND");
        OR = new ConstraintOp("OR");
        NAND = new ConstraintOp("NAND");
        NOR = new ConstraintOp("NOR");
        LOOKUP = new ConstraintOp("LOOKUP");
        OVERLAPS = new ConstraintOp("OVERLAPS");
        DOES_NOT_OVERLAP = new ConstraintOp("DOES NOT OVERLAP");
        ONE_OF = new ConstraintOp("ONE OF");
        NONE_OF = new ConstraintOp("NONE OF");
        WITHIN = new ConstraintOp("WITHIN");
        OUTSIDE = new ConstraintOp("OUTSIDE");
        ISA = new ConstraintOp("ISA");
        ISNT = new ConstraintOp("ISNT");
    }
}

