/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.MetaDataException;

public final class DescriptorUtils {
    private DescriptorUtils() {
    }

    public static ClassDescriptor findSumType(Collection<ClassDescriptor> classes) throws MetaDataException {
        return DescriptorUtils.findCommonClasses(classes).get(0);
    }

    public static ClassDescriptor findIntersectionType(Collection<ClassDescriptor> classes) throws MetaDataException {
        List<ClassDescriptor> commonTypes = DescriptorUtils.findCommonClasses(classes);
        ClassDescriptor commonSuperType = commonTypes.get(0);
        boolean isLineage = true;
        HashSet<ClassDescriptor> copyOfClasses = new HashSet<ClassDescriptor>(classes);
        ClassDescriptor lastCommonType = commonSuperType;
        while (isLineage) {
            copyOfClasses.remove(lastCommonType);
            if (copyOfClasses.isEmpty()) break;
            ClassDescriptor nextCommonSuperType = DescriptorUtils.findSumType(copyOfClasses);
            boolean bl = isLineage = nextCommonSuperType != lastCommonType;
            lastCommonType = nextCommonSuperType;
            if (classes.contains(lastCommonType) || lastCommonType.getAllSuperDescriptors().contains(commonSuperType)) continue;
            throw new MetaDataException("Disjoint set.");
        }
        if (isLineage) {
            ClassDescriptor mostSpecific = DescriptorUtils.sortClassesBySpecificity(classes).get(0);
            return mostSpecific;
        }
        return lastCommonType;
    }

    public static List<ClassDescriptor> findCommonClasses(Collection<ClassDescriptor> classes) throws MetaDataException {
        if (classes == null) {
            throw new IllegalArgumentException("classes is null");
        }
        if (classes.isEmpty()) {
            throw new MetaDataException("No classes provided");
        }
        if (classes.size() == 1) {
            return new ArrayList<ClassDescriptor>(classes);
        }
        Set<ClassDescriptor> superClasses = null;
        for (ClassDescriptor cd : classes) {
            Set<ClassDescriptor> ancestry = cd.getAllSuperDescriptors();
            ancestry.add(cd);
            if (superClasses == null) {
                superClasses = ancestry;
                continue;
            }
            superClasses.retainAll(ancestry);
        }
        CollectionUtils.filter(classes, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                ClassDescriptor cd = (ClassDescriptor)arg0;
                return cd.getAllSuperclassNames().contains("org.intermine.model.InterMineObject");
            }
        });
        if (superClasses == null || superClasses.isEmpty()) {
            throw new MetaDataException("No common type");
        }
        return DescriptorUtils.sortClassesBySpecificity((Collection<ClassDescriptor>)superClasses);
    }

    private static List<ClassDescriptor> sortClassesBySpecificity(Collection<ClassDescriptor> classes) {
        ArrayList<ClassDescriptor> superList = new ArrayList<ClassDescriptor>(classes);
        Collections.sort(superList, new Comparator<ClassDescriptor>(){

            @Override
            public int compare(ClassDescriptor o1, ClassDescriptor o2) {
                int depth2;
                int depth1 = o1.getAllSuperDescriptors().size();
                if (depth1 <= (depth2 = o2.getAllSuperDescriptors().size())) {
                    return 1;
                }
                if (depth1 >= depth2) {
                    return -1;
                }
                return 0;
            }
        });
        return superList;
    }
}

