/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import org.intermine.metadata.ClassDescriptor;

public abstract class FieldDescriptor {
    public static final int NOT_RELATION = 0;
    public static final int ONE_ONE_RELATION = 1;
    public static final int ONE_N_RELATION = 2;
    public static final int N_ONE_RELATION = 3;
    public static final int M_N_RELATION = 4;
    protected final String name;
    protected ClassDescriptor cld;
    private boolean cldSet = false;

    public FieldDescriptor(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new IllegalArgumentException("Java field names must start with a character, '$' or '_' but field name was: " + name);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            throw new IllegalArgumentException("Java field names may not contain character '" + name.charAt(i) + "' but field name was '" + name + "'");
        }
        this.name = name.intern();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.cld;
    }

    public String getName() {
        return this.name;
    }

    protected void setClassDescriptor(ClassDescriptor cld) {
        if (cld == null) {
            throw new NullPointerException("cld cannot be null");
        }
        if (this.cldSet) {
            throw new IllegalStateException("ClassDescriptor has already been set and may not be changed.");
        }
        this.cld = cld;
        this.cldSet = true;
    }

    public abstract int relationType();

    public boolean isAttribute() {
        return this.relationType() == 0;
    }

    public boolean isReference() {
        return this.relationType() == 1 || this.relationType() == 3;
    }

    public boolean isCollection() {
        return this.relationType() == 2 || this.relationType() == 4;
    }

    public abstract String toJSONString();
}

