/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ModelParser;
import org.intermine.metadata.ModelParserException;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.metadata.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class InterMineModelParser
implements ModelParser {
    private static final Logger LOG = Logger.getLogger(InterMineModelParser.class);

    @Override
    public Model process(Reader reader) throws ModelParserException {
        try {
            ModelHandler handler = new ModelHandler();
            SAXParser.parse(new InputSource(reader), handler);
            Model model = new Model(handler.modelName, handler.packageName, handler.version, handler.classes);
            return model;
        }
        catch (Exception e) {
            throw new ModelParserException(e);
        }
    }

    @Override
    public Set<ClassDescriptor> generateClassDescriptors(Reader reader, String packageName) throws ModelParserException {
        try {
            ModelHandler handler = new ModelHandler();
            handler.packageName = packageName;
            SAXParser.parse(new InputSource(reader), handler);
            return handler.classes;
        }
        catch (Exception e) {
            throw new ModelParserException(e);
        }
    }

    static class SkeletonClass {
        String name;
        String supers;
        String fairTerm;
        boolean isInterface;
        Set<AttributeDescriptor> attributes = new LinkedHashSet<AttributeDescriptor>();
        Set<ReferenceDescriptor> references = new LinkedHashSet<ReferenceDescriptor>();
        Set<CollectionDescriptor> collections = new LinkedHashSet<CollectionDescriptor>();

        SkeletonClass(String packageName, String name, String supers, boolean isInterface, String fairTerm) {
            this.name = name;
            if (this.name.startsWith(packageName + ".")) {
                this.name = this.name.substring(packageName.length() + 1);
            }
            if (this.name.contains(".")) {
                throw new IllegalArgumentException("Class " + name + " is not in the model package " + packageName);
            }
            if (!"".equals(packageName)) {
                this.name = packageName + "." + this.name;
            }
            if (supers != null) {
                String[] superNames = supers.split(" ");
                StringBuilder supersBuilder = new StringBuilder();
                boolean needComma = false;
                String[] stringArray = superNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String superName;
                    String origSuperName = superName = stringArray[i];
                    if (superName.startsWith(packageName + ".")) {
                        superName = superName.substring(packageName.length() + 1);
                    }
                    if (!"java.lang.Object".equals(superName)) {
                        if (superName.contains(".")) {
                            throw new IllegalArgumentException("Superclass " + origSuperName + " of class " + this.name + " is not in the model package " + packageName);
                        }
                        if (!"".equals(packageName)) {
                            superName = packageName + "." + superName;
                        }
                    }
                    if (needComma) {
                        supersBuilder.append(" ");
                    }
                    needComma = true;
                    supersBuilder.append(superName);
                }
                this.supers = supersBuilder.toString();
            } else {
                this.supers = null;
            }
            this.isInterface = isInterface;
            this.fairTerm = fairTerm;
        }
    }

    class ModelHandler
    extends DefaultHandler {
        String modelName;
        String packageName;
        int version = 0;
        Set<ClassDescriptor> classes = new LinkedHashSet<ClassDescriptor>();
        SkeletonClass cls;

        ModelHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            if ("model".equals(qName)) {
                this.modelName = attrs.getValue("name");
                this.packageName = attrs.getValue("package");
                String versionString = attrs.getValue("version");
                if (versionString != null) {
                    try {
                        this.version = Integer.parseInt(versionString);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Error - version = " + versionString + " is not a valid version");
                    }
                }
                if (this.packageName == null) {
                    throw new IllegalArgumentException("Error - package name of model is not defined");
                }
            } else if ("class".equals(qName)) {
                String name = attrs.getValue("name");
                String supers = attrs.getValue("extends");
                boolean isInterface = Boolean.valueOf(attrs.getValue("is-interface"));
                String fairTerm = attrs.getValue("term");
                this.cls = new SkeletonClass(this.packageName, name, supers, isInterface, fairTerm);
            } else if ("attribute".equals(qName)) {
                String name = attrs.getValue("name");
                String type = attrs.getValue("type");
                String fairTerm = null;
                if (attrs.getValue("term") != null) {
                    fairTerm = attrs.getValue("term");
                }
                if (StringUtils.isEmpty((String)name)) {
                    throw new IllegalArgumentException("Error - `" + this.cls.name + "` has an attribute with an empty/null name");
                }
                if (attrs.getType("type") == null) {
                    throw new IllegalArgumentException("Error - type of attribute `" + name + "` not defined for `" + this.cls.name + "`");
                }
                this.cls.attributes.add(new AttributeDescriptor(name, type, fairTerm));
            } else if ("reference".equals(qName)) {
                String origType;
                String name = attrs.getValue("name");
                String type = origType = attrs.getValue("referenced-type");
                if (StringUtils.isEmpty((String)name)) {
                    throw new IllegalArgumentException("Error - `" + this.cls.name + "` has a reference with an empty/null name");
                }
                if (type == null) {
                    throw new IllegalArgumentException("Error - type of reference `" + name + "` not defined for `" + this.cls.name + "`");
                }
                if (type.startsWith(this.packageName + ".")) {
                    type = type.substring(this.packageName.length() + 1);
                }
                if (type.contains(".")) {
                    throw new IllegalArgumentException("Class " + origType + " in reference " + this.cls.name + "." + name + " is not in the model package " + this.packageName);
                }
                if (!"".equals(this.packageName)) {
                    type = this.packageName + "." + type;
                }
                String reverseReference = attrs.getValue("reverse-reference");
                this.cls.references.add(new ReferenceDescriptor(name, type, reverseReference));
            } else if ("collection".equals(qName)) {
                String origType;
                String name = attrs.getValue("name");
                String type = origType = attrs.getValue("referenced-type");
                if (StringUtils.isEmpty((String)name)) {
                    throw new IllegalArgumentException("Error - `" + this.cls.name + "` has a collection with an empty/null name");
                }
                if (type == null) {
                    throw new IllegalArgumentException("Error - `" + name + "` collection missing a type for `" + this.cls.name + "`");
                }
                if (type.startsWith(this.packageName + ".")) {
                    type = type.substring(this.packageName.length() + 1);
                }
                if (type.contains(".")) {
                    throw new IllegalArgumentException("Class " + origType + " in reference " + this.cls.name + "." + name + " is not in the model package " + this.packageName);
                }
                if (!"".equals(this.packageName)) {
                    type = this.packageName + "." + type;
                }
                if (attrs.getValue("ordered") != null) {
                    LOG.warn((Object)("Deprecated \"ordered\" attribute on collection " + this.cls.name + "." + name));
                }
                String reverseReference = attrs.getValue("reverse-reference");
                this.cls.collections.add(new CollectionDescriptor(name, type, reverseReference));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("class".equals(qName)) {
                this.classes.add(new ClassDescriptor(this.cls.name, this.cls.supers, this.cls.isInterface, this.cls.attributes, this.cls.references, this.cls.collections, this.cls.fairTerm));
            }
        }
    }
}

