/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.io.InputStream;
import java.io.InputStreamReader;
import org.intermine.metadata.InterMineModelParser;
import org.intermine.metadata.Model;
import org.intermine.metadata.Util;

public final class ModelFactory {
    private static final String MODEL = "model";

    private ModelFactory() {
    }

    public static Model loadModel(String name) {
        String filename = Util.getFilename(MODEL, name);
        InputStream is = Model.class.getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IllegalArgumentException("Model definition file '" + filename + "' cannot be found");
        }
        Model model = null;
        try {
            model = new InterMineModelParser().process(new InputStreamReader(is));
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing model definition file '" + filename + "'", e);
        }
        return model;
    }
}

