/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.PrimaryKey;
import org.intermine.metadata.Util;

public abstract class PrimaryKeyUtil {
    protected static Map<String, Properties> modelKeys = new HashMap<String, Properties>();
    protected static Map<ClassDescriptor, Map<String, PrimaryKey>> primaryKeyCache = new IdentityHashMap<ClassDescriptor, Map<String, PrimaryKey>>();

    private PrimaryKeyUtil() {
    }

    public static Map<String, PrimaryKey> getPrimaryKeys(ClassDescriptor cld) {
        Map<String, PrimaryKey> keyMap = primaryKeyCache.get(cld);
        if (keyMap == null) {
            keyMap = new LinkedHashMap<String, PrimaryKey>();
            Properties keys = PrimaryKeyUtil.getKeyProperties(cld.getModel().getName());
            String cldName = Util.unqualifiedName(cld.getName());
            Properties cldKeys = Util.getPropertiesStartingWith(cldName, keys);
            cldKeys = Util.stripStart(cldName, cldKeys);
            ArrayList<String> keyNames = new ArrayList<String>();
            for (Object key : cldKeys.keySet()) {
                if (!(key instanceof String)) continue;
                keyNames.add((String)key);
            }
            Collections.sort(keyNames);
            for (String keyName : keyNames) {
                PrimaryKey key = new PrimaryKey(keyName, (String)cldKeys.get(keyName), cld);
                keyMap.put(keyName, key);
            }
            primaryKeyCache.put(cld, keyMap);
        }
        return keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getKeyProperties(String modelName) {
        Properties keys = null;
        Map<String, Properties> map = modelKeys;
        synchronized (map) {
            keys = modelKeys.get(modelName);
            if (keys == null) {
                keys = Util.loadKeyDefinitions(modelName);
                modelKeys.put(modelName, keys);
            }
        }
        return keys;
    }
}

