/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.metadata.Util;
import org.intermine.model.FastPathObject;

public final class TypeUtil {
    private static Map<Class<?>, Map<String, FieldInfo>> classToFieldnameToFieldInfo = new HashMap();
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DATE_FORMAT;

    private TypeUtil() {
    }

    public static String packageName(String className) {
        if (className.lastIndexOf(".") >= 0) {
            return className.substring(0, className.lastIndexOf("."));
        }
        return "";
    }

    public static String unqualifiedName(String className) {
        if (className.lastIndexOf(".") >= 0) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    public static Object getFieldValue(Object o, String fieldName) throws IllegalAccessException {
        try {
            return TypeUtil.getGetter(o.getClass(), fieldName).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            String type = "";
            try {
                type = " (a " + TypeUtil.getFieldInfo(o.getClass(), fieldName).getGetter().getReturnType().getName() + ")";
            }
            catch (Exception e3) {
                type = " (available fields are " + TypeUtil.getFieldInfos(o.getClass()).keySet() + ")";
            }
            IllegalAccessException e2 = new IllegalAccessException("Couldn't get field \"" + Util.decomposeClass(o.getClass()) + "." + fieldName + "\"" + type);
            e2.initCause(e);
            throw e2;
        }
    }

    public static Object getFieldProxy(Object o, String fieldName) throws IllegalAccessException {
        try {
            Method proxyGetter = TypeUtil.getProxyGetter(o.getClass(), fieldName);
            if (proxyGetter == null) {
                proxyGetter = TypeUtil.getGetter(o.getClass(), fieldName);
            }
            return proxyGetter.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            String type = null;
            try {
                type = TypeUtil.getFieldInfo(o.getClass(), fieldName).getGetter().getReturnType().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IllegalAccessException e2 = new IllegalAccessException("Couldn't proxyGet field \"" + o.getClass().getName() + "." + fieldName + "\"" + (type == null ? "" : " (a " + type + ")"));
            e2.initCause(e);
            throw e2;
        }
    }

    public static void addCollectionElement(Object o, String fieldName, Object element) {
        try {
            TypeUtil.getAdder(o.getClass(), fieldName).invoke(o, element);
        }
        catch (Exception e) {
            String type = null;
            try {
                type = TypeUtil.getFieldInfo(o.getClass(), fieldName).getElementType().getName();
            }
            catch (Exception e3) {
                IllegalArgumentException e2 = new IllegalArgumentException("Couldn't add element to collection \"" + Util.getFriendlyName(o.getClass()) + "." + fieldName + "\" - not an accessible collection");
                e2.initCause(e);
                throw e2;
            }
            IllegalArgumentException e2 = new IllegalArgumentException("Couldn't add element to collection \"" + Util.getFriendlyName(o.getClass()) + "." + fieldName + "\" (a " + type + ") with \"" + element + "\" (a " + element.getClass().getName() + ")");
            e2.initCause(e);
            throw e2;
        }
    }

    public static Method getGetter(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            return info.getGetter();
        }
        return null;
    }

    public static Method getSetter(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            return info.getSetter();
        }
        return null;
    }

    public static Method getProxySetter(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            return info.getProxySetter();
        }
        return null;
    }

    public static Method getProxyGetter(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            return info.getProxyGetter();
        }
        return null;
    }

    public static Method getAdder(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            return info.getAdder();
        }
        return null;
    }

    public static Class<?> getFieldType(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            return info.getType();
        }
        return null;
    }

    public static Class<? extends FastPathObject> getElementType(Class<?> c, String fieldName) {
        FieldInfo info = TypeUtil.getFieldInfo(c, fieldName);
        if (info != null) {
            try {
                return info.getElementType();
            }
            catch (NullPointerException e) {
                IllegalArgumentException e2 = new IllegalArgumentException("Field " + Util.getFriendlyName(c) + "." + fieldName + " is not a collection");
                e2.initCause(e);
                throw e2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, FieldInfo> getFieldInfos(Class<?> c) {
        Map<String, FieldInfo> infos = null;
        Map<Class<?>, Map<String, FieldInfo>> map = classToFieldnameToFieldInfo;
        synchronized (map) {
            infos = classToFieldnameToFieldInfo.get(c);
            if (infos == null) {
                infos = new TreeMap<String, FieldInfo>();
                HashMap<String, Method> methods = new HashMap<String, Method>();
                Method[] methodArray = c.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    String methodName = methodArray[i].getName();
                    methods.put(methodName, methodArray[i]);
                }
                for (String getterName : methods.keySet()) {
                    if (!getterName.startsWith("get")) continue;
                    String setterName = "set" + getterName.substring(3);
                    String proxySetterName = "proxy" + getterName.substring(3);
                    String proxyGetterName = "proxGet" + getterName.substring(3);
                    String adderName = "add" + getterName.substring(3);
                    if (!methods.containsKey(setterName)) continue;
                    Method getter = (Method)methods.get(getterName);
                    Method setter = (Method)methods.get(setterName);
                    Method proxySetter = (Method)methods.get(proxySetterName);
                    Method proxyGetter = (Method)methods.get(proxyGetterName);
                    Method adder = (Method)methods.get(adderName);
                    String fieldName = getterName.substring(3);
                    fieldName = StringUtil.reverseCapitalisation(fieldName).intern();
                    if ("getClass".equals(getter.getName()) || "getCallback".equals(getter.getName()) || "getCallbacks".equals(getter.getName()) || "getoBJECT".equals(getter.getName()) || "getFieldValue".equals(getter.getName()) || "getFieldProxy".equals(getter.getName()) || "getFieldType".equals(getter.getName()) || "getElementType".equals(getter.getName())) continue;
                    FieldInfo info = new FieldInfo(fieldName, getter, setter, proxySetter, proxyGetter, adder);
                    infos.put(fieldName, info);
                }
                classToFieldnameToFieldInfo.put(c, infos);
            }
        }
        return infos;
    }

    public static FieldInfo getFieldInfo(Class<?> c, String fieldname) {
        return TypeUtil.getFieldInfos(c).get(fieldname);
    }

    public static Method[] getGetters(Class<?> c) throws IntrospectionException {
        PropertyDescriptor[] pd = Introspector.getBeanInfo(c).getPropertyDescriptors();
        HashSet<Method> getters = new HashSet<Method>();
        for (int i = 0; i < pd.length; ++i) {
            Method getter = pd[i].getReadMethod();
            if ("getClass".equals(getter.getName()) || "getoBJECT".equals(getter.getName()) || "getCallback".equals(getter.getName()) || "getCallbacks".equals(getter.getName()) || "getFieldValue".equals(getter.getName()) || "getFieldProxy".equals(getter.getName()) || "getFieldType".equals(getter.getName()) || "getElementType".equals(getter.getName())) continue;
            getters.add(getter);
        }
        return getters.toArray(new Method[0]);
    }

    public static List<Object> flatten(Object obj) throws Exception {
        List<Object> c = obj instanceof Collection ? (List<Object>)obj : Arrays.asList(obj);
        try {
            ArrayList<Object> toStore = new ArrayList<Object>();
            for (Object e : c) {
                TypeUtil.flatten(e, toStore);
            }
            return toStore;
        }
        catch (Exception e) {
            throw new Exception("Problem occurred flattening object", e);
        }
    }

    private static void flatten(Object o, Collection<Object> c) throws Exception {
        if (o == null || c.contains(o)) {
            return;
        }
        c.add(o);
        Method[] getters = TypeUtil.getGetters(o.getClass());
        for (int i = 0; i < getters.length; ++i) {
            Method getter = getters[i];
            Class<?> returnType = getter.getReturnType();
            if (Collection.class.isAssignableFrom(returnType)) {
                for (Object obj : (Collection)getter.invoke(o, new Object[0])) {
                    TypeUtil.flatten(obj, c);
                }
                continue;
            }
            if (returnType.isPrimitive() || returnType.getName().startsWith("java")) continue;
            TypeUtil.flatten(getter.invoke(o, new Object[0]), c);
        }
    }

    public static <T> T createNew(String typeName) {
        Class<?> clazz = TypeUtil.getTypeByName(typeName);
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot get class for " + typeName);
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create new " + typeName, e);
        }
    }

    public static Class<?> getTypeByName(String name) {
        if (name.equals(Integer.TYPE.toString())) {
            return Integer.class;
        }
        if (name.equals(Boolean.TYPE.toString())) {
            return Boolean.class;
        }
        if (name.equals(Double.TYPE.toString())) {
            return Double.class;
        }
        if (name.equals(Float.TYPE.toString())) {
            return Float.class;
        }
        if (name.equals(Long.TYPE.toString())) {
            return Long.class;
        }
        if (name.equals(Short.TYPE.toString())) {
            return Short.class;
        }
        if (name.equals(Byte.TYPE.toString())) {
            return Byte.class;
        }
        if (name.equals(Character.TYPE.toString())) {
            return Character.class;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cls;
    }

    @Deprecated
    public static Class<?> instantiate(String type) {
        return TypeUtil.getTypeByName(type);
    }

    public static String javaiseClassName(String s) {
        String filtered = s;
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(filtered, " _-");
        while (st.hasMoreTokens()) {
            sb.append(StringUtil.capitalise(st.nextToken().replaceAll("\\W", "")));
        }
        filtered = sb.toString();
        return filtered;
    }

    public static String generateClassName(String packageName, String className) {
        return packageName + "." + TypeUtil.javaiseClassName(className);
    }

    public static boolean isInstanceOf(FastPathObject object, String className) throws ClassNotFoundException {
        Set<Class<?>> classes = Util.decomposeClass(object.getClass());
        Class<?> testClass = Class.forName(className);
        for (Class<?> objectClass : classes) {
            if (!testClass.isAssignableFrom(objectClass)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getClass(String className) {
        Class<Object> cls = TypeUtil.instantiate(className);
        if (cls == null) {
            if ("Date".equals(className)) {
                cls = Date.class;
            } else if ("BigDecimal".equals(className)) {
                cls = BigDecimal.class;
            } else {
                try {
                    cls = Class.forName("java.lang." + className);
                }
                catch (Exception e) {
                    throw new RuntimeException("unknown class: " + className);
                }
            }
        }
        return cls;
    }

    public static Class<?> getClass(String className, Model model) throws ClassNotFoundException {
        String qualifiedName = className;
        qualifiedName = "InterMineObject".equals(className) ? "org.intermine.model.InterMineObject" : model.getPackageName() + "." + qualifiedName;
        return Class.forName(qualifiedName);
    }

    public static String javaisePackageName(String s) {
        String normalRegex = "[A-Za-z0-9]*";
        String illRegex = "[. _#$%&()*+,\"'/:;<=>?@\\^`{|}~-]";
        if (Pattern.matches(normalRegex, s)) {
            return s.toLowerCase();
        }
        String[] splitedStr = s.split(illRegex);
        StringBuffer sb = new StringBuffer();
        for (String str : splitedStr) {
            sb.append(str.toLowerCase());
        }
        return sb.toString();
    }

    public static Object stringToObject(Class<?> clazz, String value) {
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Integer.valueOf(value.replace(",", ""));
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            if ("NULL".equals(value)) {
                return "NULL";
            }
            return Boolean.valueOf(value);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Double.valueOf(value.replace(",", ""));
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(value.replace(",", ""));
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Long.valueOf(value.replace(",", ""));
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return Short.valueOf(value.replace(",", ""));
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return Byte.valueOf(value.replace(",", ""));
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return new Character(value.charAt(0));
        }
        if (clazz.equals(Date.class)) {
            if (value.matches("^\\d+$")) {
                return new Date(Long.parseLong(value));
            }
            try {
                return DATE_TIME_FORMAT.parse(value);
            }
            catch (Exception e) {
                try {
                    return DATE_FORMAT.parse(value);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Failed to parse " + value + " as a Date", e);
                }
            }
        }
        if (clazz.equals(BigDecimal.class)) {
            return new BigDecimal(value.replace(",", ""));
        }
        if (clazz.equals(String.class)) {
            return value;
        }
        if (clazz.equals(URL.class)) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if ("org.intermine.objectstore.query.ClobAccess".equals(clazz)) {
            throw new IllegalStateException("Cannot convert - we need an ObjectStore");
        }
        return value;
    }

    static {
        DATE_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class FieldInfo {
        private String name;
        private Method getter;
        private Method setter;
        private Method proxySetter;
        private Method proxyGetter;
        private Method adder;

        public FieldInfo(String name, Method getter, Method setter, Method proxySetter, Method proxyGetter, Method adder) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.proxySetter = proxySetter;
            this.proxyGetter = proxyGetter;
            this.adder = adder;
        }

        public String getName() {
            return this.name;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public Method getProxySetter() {
            return this.proxySetter;
        }

        public Method getProxyGetter() {
            return this.proxyGetter;
        }

        public Method getAdder() {
            return this.adder;
        }

        public Class<?> getType() {
            return this.getter.getReturnType();
        }

        public Class<? extends FastPathObject> getElementType() {
            Class<?> retval = this.adder.getParameterTypes()[0];
            return retval;
        }
    }
}

