/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sf.cglib.proxy.Factory;
import org.apache.log4j.Logger;
import org.intermine.metadata.NonOverrideableProperties;
import org.intermine.model.ShadowClass;

public final class Util {
    private static final Logger LOG = Logger.getLogger(Util.class);
    public static final String KEY_DEFINITIONS = "keyDefs";
    private static final String CLASS_KEYS = "class_keys";
    public static final String MODEL = "model";
    private static HashMap<Class<?>, Set<Class<?>>> decomposeMap = new HashMap();
    private static Map<Class<?>, String> friendlyNameMap = new HashMap();

    private Util() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static Exception verboseException(Exception e) {
        boolean needComma = false;
        StringWriter message = new StringWriter();
        PrintWriter pMessage = new PrintWriter(message);
        Class<?> c = e.getClass();
        while (e != null) {
            if (needComma) {
                pMessage.println("\n---------------NEXT EXCEPTION");
            }
            needComma = true;
            e.printStackTrace(pMessage);
            if (e instanceof SQLException) {
                e = ((SQLException)e).getNextException();
                continue;
            }
            e = null;
        }
        try {
            Constructor<?> cons = c.getConstructor(String.class);
            Exception toThrow = (Exception)cons.newInstance(message.toString());
            return toThrow;
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("NoSuchMethodException thrown while handling " + c.getName() + ": " + message.toString());
        }
        catch (InstantiationException e2) {
            throw new RuntimeException("InstantiationException thrown while handling " + c.getName() + ": " + message.toString());
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException("IllegalAccessException thrown while handling " + c.getName() + ": " + message.toString());
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException("InvocationTargetException thrown while handling " + c.getName() + ": " + message.toString());
        }
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    public static int lcm(int a, int b) {
        return a / Util.gcd(a, b) * b;
    }

    @Deprecated
    public static String wildcardSqlToUser(String exp) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exp.length(); ++i) {
            String substring = exp.substring(i);
            if (substring.startsWith("%")) {
                sb.append("*");
                continue;
            }
            if (substring.startsWith("_")) {
                sb.append("?");
                continue;
            }
            if (substring.startsWith("\\%")) {
                sb.append("%");
                ++i;
                continue;
            }
            if (substring.startsWith("\\_")) {
                sb.append("_");
                ++i;
                continue;
            }
            if (substring.startsWith("*")) {
                sb.append("\\*");
                continue;
            }
            if (substring.startsWith("?")) {
                sb.append("\\?");
                continue;
            }
            if (substring.startsWith("\\\\")) {
                ++i;
                sb.append("\\");
                continue;
            }
            sb.append(substring.charAt(0));
        }
        return sb.toString();
    }

    public static String wildcardUserToSql(String exp) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exp.length(); ++i) {
            String substring = exp.substring(i);
            if (substring.startsWith("*")) {
                sb.append("%");
                continue;
            }
            if (substring.startsWith("?")) {
                sb.append("_");
                continue;
            }
            if (substring.startsWith("\\*")) {
                sb.append("*");
                ++i;
                continue;
            }
            if (substring.startsWith("\\?")) {
                sb.append("?");
                ++i;
                continue;
            }
            if (substring.startsWith("%")) {
                sb.append("\\%");
                continue;
            }
            if (substring.startsWith("_")) {
                sb.append("\\_");
                continue;
            }
            if (substring.startsWith("\\")) {
                sb.append("\\\\");
                continue;
            }
            sb.append(substring.charAt(0));
        }
        return sb.toString();
    }

    public static String getMd5checksum(String sequence) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] buffer = sequence.getBytes();
        md5.update(buffer);
        byte[] bits = md5.digest();
        StringBuilder checksum = new StringBuilder();
        for (int i = 0; i < bits.length; ++i) {
            checksum.append(Integer.toHexString(0xFF & bits[i] | 0xFFFFFF00).substring(6));
        }
        return checksum.toString().toLowerCase();
    }

    public static Class<?> getClassFromString(String type) {
        if ("short".equals(type) || "java.lang.Short".equals(type)) {
            return Short.class;
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return Integer.class;
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return Long.class;
        }
        if ("java.lang.String".equals(type)) {
            return String.class;
        }
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Boolean".equals(type)) {
            return Boolean.class;
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return Float.class;
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return Double.class;
        }
        if ("java.util.Date".equals(type)) {
            return Date.class;
        }
        if ("java.math.BigDecimal".equals(type)) {
            return BigDecimal.class;
        }
        if ("org.intermine.objectstore.query.ClobAccess".equals(type)) {
            return String.class;
        }
        throw new IllegalArgumentException("Unknown type \"" + type + "\"");
    }

    public static <K, V> void addToSetMap(Map<K, Set<V>> map, K key, Collection<V> newValues) {
        if (map == null) {
            throw new IllegalArgumentException("invalid map");
        }
        if (key == null) {
            throw new IllegalArgumentException("invalid map key");
        }
        if (newValues == null) {
            throw new IllegalArgumentException("invalid new values");
        }
        Set<V> values = map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            map.put(key, values);
        }
        values.addAll(newValues);
    }

    public static <K, V> void addToSetMap(Map<K, Set<V>> map, K key, V value) {
        if (map == null) {
            throw new IllegalArgumentException("invalid map");
        }
        if (key == null) {
            throw new IllegalArgumentException("invalid map key");
        }
        Set<V> values = map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    public static <K, V> void addToListMap(Map<K, List<V>> map, K key, V value) {
        if (map == null) {
            throw new IllegalArgumentException("invalid map");
        }
        if (key == null) {
            throw new IllegalArgumentException("invalid map key");
        }
        List<V> valuesList = map.get(key);
        if (valuesList == null) {
            valuesList = new ArrayList<V>();
            map.put(key, valuesList);
        }
        valuesList.add(value);
    }

    protected static List<String> tokenize(String str) {
        if (str == null) {
            throw new NullPointerException("Cannot pass null arguments to tokenize");
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    protected static String unqualifiedName(String className) {
        if (className.lastIndexOf(".") >= 0) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    protected static String join(Collection<?> c, String delimiter) {
        StringBuffer sb = new StringBuffer();
        boolean needComma = false;
        for (Object o : c) {
            if (needComma) {
                sb.append(delimiter);
            }
            needComma = true;
            sb.append(o.toString());
        }
        return sb.toString();
    }

    protected static Class<?> instantiate(String type) {
        if (type.equals(Integer.TYPE.toString())) {
            return Integer.class;
        }
        if (type.equals(Boolean.TYPE.toString())) {
            return Boolean.class;
        }
        if (type.equals(Double.TYPE.toString())) {
            return Double.class;
        }
        if (type.equals(Float.TYPE.toString())) {
            return Float.class;
        }
        if (type.equals(Long.TYPE.toString())) {
            return Long.class;
        }
        if (type.equals(Short.TYPE.toString())) {
            return Short.class;
        }
        if (type.equals(Byte.TYPE.toString())) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE.toString())) {
            return Character.class;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cls;
    }

    protected static Properties getPropertiesStartingWith(String str, Properties props) {
        if (str == null) {
            throw new NullPointerException("str cannot be null, props param: " + props);
        }
        if (props == null) {
            throw new NullPointerException("props cannot be null, str param: " + str);
        }
        Properties subset = new Properties();
        Enumeration<Object> propertyEnum = props.keys();
        while (propertyEnum.hasMoreElements()) {
            String propertyName = (String)propertyEnum.nextElement();
            if (!propertyName.startsWith(str)) continue;
            subset.put(propertyName, props.get(propertyName));
        }
        return subset;
    }

    protected static Properties stripStart(String prefix, Properties props) {
        if (prefix == null) {
            throw new NullPointerException("prefix cannot be null");
        }
        if (props == null) {
            throw new NullPointerException("props cannot be null");
        }
        Properties ret = new Properties();
        Enumeration<Object> propertyEnum = props.keys();
        while (propertyEnum.hasMoreElements()) {
            String propertyName = (String)propertyEnum.nextElement();
            if (!propertyName.startsWith(prefix + ".")) continue;
            ret.put(propertyName.substring(prefix.length() + 1), props.get(propertyName));
        }
        return ret;
    }

    protected static Properties loadProperties(String filename) {
        NonOverrideableProperties props = new NonOverrideableProperties();
        try {
            ClassLoader loader = Util.class.getClassLoader();
            InputStream is = loader.getResourceAsStream(filename);
            if (is == null) {
                LOG.error((Object)("Could not find file " + filename + " from " + loader));
                return null;
            }
            props.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load :" + filename, e);
        }
        return props;
    }

    protected static String getFilename(String key, String modelName) {
        String filename = modelName == null ? key : modelName + "_" + key;
        if (MODEL.equals(key)) {
            return filename + ".xml";
        }
        if (KEY_DEFINITIONS.equals(key) || CLASS_KEYS.equals(key)) {
            return filename + ".properties";
        }
        throw new IllegalArgumentException("Unrecognised key '" + key + "'");
    }

    public static Properties loadKeyDefinitions(String modelName) {
        return Util.loadProperties(Util.getFilename(KEY_DEFINITIONS, modelName));
    }

    public static synchronized Set<Class<?>> decomposeClass(Class<?> clazz) {
        Set<Class<?>> retval = decomposeMap.get(clazz);
        if (retval == null) {
            if (Factory.class.isAssignableFrom(clazz)) {
                retval = new TreeSet(new ClassNameComparator());
                retval.add(clazz.getSuperclass());
                Class<?>[] interfs = clazz.getInterfaces();
                for (int i = 0; i < interfs.length; ++i) {
                    Class<?> inter = interfs[i];
                    if (Factory.class == inter) continue;
                    boolean notIn = true;
                    Iterator<Class<?>> inIter = retval.iterator();
                    while (inIter.hasNext() && notIn) {
                        Class<?> in = inIter.next();
                        if (in.isAssignableFrom(inter)) {
                            inIter.remove();
                        }
                        if (!inter.isAssignableFrom(in)) continue;
                        notIn = false;
                    }
                    if (!notIn) continue;
                    retval.add(inter);
                }
            } else if (ShadowClass.class.isAssignableFrom(clazz)) {
                try {
                    retval = new TreeSet(new ClassNameComparator());
                    retval.add((Class)clazz.getField("shadowOf").get(null));
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("ShadowClass " + clazz.getName() + " has no shadowOf method", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(clazz.getName() + ".shadowOf method is inaccessible", e);
                }
            } else {
                retval = new TreeSet(new ClassNameComparator());
                retval.add(clazz);
            }
            decomposeMap.put(clazz, retval);
        }
        return retval;
    }

    public static synchronized String getFriendlyName(Class<?> clazz) {
        String retval = friendlyNameMap.get(clazz);
        if (retval == null) {
            retval = "";
            Iterator<Class<?>> iter = Util.decomposeClass(clazz).iterator();
            boolean needComma = false;
            while (iter.hasNext()) {
                Class<?> constit = iter.next();
                retval = retval + (needComma ? "," : "");
                needComma = true;
                retval = retval + constit.getName().substring(constit.getName().lastIndexOf(46) + 1);
            }
            friendlyNameMap.put(clazz, retval);
        }
        return retval;
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<?> a, Class<?> b) {
            return a.getName().compareTo(b.getName());
        }
    }
}

