/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.plugin.project;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.intermine.plugin.project.Action;
import org.intermine.plugin.project.PostProcess;
import org.intermine.plugin.project.Project;
import org.intermine.plugin.project.Source;
import org.intermine.plugin.project.UserProperty;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ProjectXmlBinding {
    private ProjectXmlBinding() {
    }

    public static Project unmarshall(File file) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            ProjectXmlHandler handler = new ProjectXmlHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.newSAXParser().parse(new InputSource(reader), (DefaultHandler)handler);
            Project project = handler.project;
            project.validate(file);
            return project;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("The underlying parser does not support  the requested features", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing the project.xml file, please check the format.", e);
        }
    }

    private static class ProjectXmlHandler
    extends DefaultHandler {
        private final Pattern projectPattern = Pattern.compile(".*project$");
        private final Matcher projectMatcher = this.projectPattern.matcher("");
        Project project;
        Action action;

        private ProjectXmlHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            if (qName == null) {
                return;
            }
            this.projectMatcher.reset(qName);
            if (this.projectMatcher.matches()) {
                this.project = new Project();
                if (attrs.getValue("type") == null) {
                    throw new IllegalArgumentException("project type must be set in project.xml");
                }
                this.project.setType(attrs.getValue("type"));
            } else if ("post-process".equals(qName)) {
                PostProcess postProcess = new PostProcess();
                String version = attrs.getValue("version");
                if (version != null && !"".equals(version)) {
                    postProcess.setVersion(version);
                }
                this.action = postProcess;
                this.project.addPostProcess(attrs.getValue("name"), postProcess);
            } else if ("source".equals(qName)) {
                Source source = new Source();
                source.setType(attrs.getValue("type"));
                source.setName(attrs.getValue("name"));
                String version = attrs.getValue("version");
                if (version != null && !"".equals(version)) {
                    source.setVersion(version);
                }
                this.project.addSource(attrs.getValue("name"), source);
                this.action = source;
            } else if ("property".equals(qName)) {
                UserProperty property = new UserProperty();
                property.setName(attrs.getValue("name"));
                property.setValue(attrs.getValue("value"));
                property.setLocation(attrs.getValue("location"));
                if (this.action == null) {
                    this.project.addProperty(property);
                } else {
                    this.action.addUserProperty(property);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName == null) {
                return;
            }
            if ("source".equals(qName) || "post-process".equals(qName)) {
                this.action = null;
            }
        }
    }
}

