/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.plugin.ant;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.ClasspathUtils;
import org.intermine.plugin.project.Project;
import org.intermine.plugin.project.ProjectXmlBinding;
import org.intermine.plugin.project.Source;

public class MergeSourceModelsTask
extends Task {
    private File modelFile;
    private String extraModelsStart;
    private String extraModelsEnd;
    private File projectXml;
    private static final String MODEL_MERGER_TASK = "org.intermine.task.ModelMergerTask";

    public void setProjectXmlPath(File projectXml) {
        this.projectXml = projectXml;
    }

    public void setModelFilePath(File file) {
        this.modelFile = file;
    }

    public void setExtraModelsStart(String extraModelsStart) {
        this.extraModelsStart = extraModelsStart;
    }

    public void setExtraModelsEnd(String extraModelsEnd) {
        this.extraModelsEnd = extraModelsEnd;
    }

    public void execute() throws BuildException {
        if (this.projectXml == null) {
            throw new BuildException("no projectXml specified");
        }
        Project imProject = ProjectXmlBinding.unmarshall(this.projectXml);
        ArrayList<String> pathsToMerge = new ArrayList<String>();
        if (this.extraModelsStart != null) {
            String[] bits = this.extraModelsStart.split("\\s+");
            for (int i = 0; i < bits.length; ++i) {
                if (bits[i].length() <= 0) continue;
                this.addToAdditionsList(pathsToMerge, bits[i]);
            }
        }
        Collection<Source> sources = imProject.getSources().values();
        for (Source source : sources) {
            String additionsFileName = source.getType() + "_additions.xml";
            this.addToAdditionsList(pathsToMerge, additionsFileName);
        }
        if (this.extraModelsEnd != null) {
            String[] bits = this.extraModelsEnd.split("\\s+");
            for (int i = 0; i < bits.length; ++i) {
                if (bits[i].length() <= 0) continue;
                this.addToAdditionsList(pathsToMerge, bits[i]);
            }
        }
        Task mergeTask = this.newModelMergerTask();
        this.setProperty(mergeTask, "inputModelFile", this.modelFile);
        this.setProperty(mergeTask, "outputFile", this.modelFile);
        try {
            Method addFileSetMethod = mergeTask.getClass().getMethod("setAdditionsFiles", List.class);
            addFileSetMethod.invoke((Object)mergeTask, pathsToMerge);
        }
        catch (Exception e) {
            throw new BuildException("exception while adding files to org.intermine.task.ModelMergerTask", (Throwable)e);
        }
        try {
            Method method = mergeTask.getClass().getMethod("execute", new Class[0]);
            method.invoke((Object)mergeTask, new Object[0]);
        }
        catch (Exception e) {
            throw new BuildException("exception while invoking execute on org.intermine.task.ModelMergerTask", (Throwable)e);
        }
    }

    private void addToAdditionsList(List<String> pathsToMerge, String additionsFile) throws BuildException {
        if (MergeSourceModelsTask.class.getClassLoader().getResourceAsStream(additionsFile) != null) {
            pathsToMerge.add(additionsFile);
        } else {
            System.err.println("warning: " + additionsFile + " not found");
        }
    }

    private Task newModelMergerTask() {
        ClassLoader cl = MergeSourceModelsTask.class.getClassLoader();
        Task mergeTask = (Task)ClasspathUtils.newInstance((String)MODEL_MERGER_TASK, (ClassLoader)cl);
        try {
            this.setProperty(mergeTask, "project", this.getProject());
        }
        catch (Exception err) {
            throw new BuildException("error setting up PostProcessTask", (Throwable)err);
        }
        return mergeTask;
    }

    private void setProperty(Object obj, String property, Object value) throws BuildException {
        try {
            Method method = obj.getClass().getMethod("set" + property.substring(0, 1).toUpperCase() + property.substring(1), value.getClass());
            method.invoke(obj, value);
        }
        catch (Exception e) {
            throw new BuildException("exception while setting property " + property + " to " + value, (Throwable)e);
        }
    }
}

