/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.plugin.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.intermine.plugin.project.PostProcess;
import org.intermine.plugin.project.Source;
import org.intermine.plugin.project.UserProperty;

public class Project {
    String type = null;
    Map<String, Source> sources = new LinkedHashMap<String, Source>();
    List<UserProperty> properties = new ArrayList<UserProperty>();
    Map<String, PostProcess> postProcesses = new LinkedHashMap<String, PostProcess>();
    Set<String> srcLocations = new HashSet<String>();

    public void addSource(String name, Source source) {
        if (this.sources.containsKey(name)) {
            throw new RuntimeException("project.xml contains more than one source named: " + name);
        }
        this.sources.put(name, source);
    }

    public void addProperty(UserProperty property) {
        this.properties.add(property);
    }

    public void addPostProcess(String name, PostProcess postProcess) {
        this.postProcesses.put(name, postProcess);
    }

    public Map<String, Source> getSources() {
        return this.sources;
    }

    public List<UserProperty> getProperties() {
        return this.properties;
    }

    public Map<String, PostProcess> getPostProcesses() {
        return this.postProcesses;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void validate(File projectXml) {
        File baseDir = projectXml.getParentFile();
        String endl = System.getProperty("line.separator");
        if (!this.sources.isEmpty() && this.getSourceLocations().isEmpty()) {
            return;
        }
        ArrayList<String> badLocations = new ArrayList<String>();
        for (String string : this.getSourceLocations()) {
            String canonicalPath;
            if (string.indexOf(126) >= 0 || string.indexOf(36) >= 0) {
                throw new BuildException("Error in project.xml: invalid 'source.location' property: " + string + ".  Must a be relative or absolute path and cannot contain '~' or environment variables: ");
            }
            File tmpDir = string.startsWith("/") ? new File(string) : new File(baseDir, string);
            try {
                canonicalPath = tmpDir.getCanonicalPath();
            }
            catch (IOException e) {
                throw new BuildException("Error finding canonical path for 'source.location': " + tmpDir.getPath());
            }
            if (tmpDir.exists()) {
                this.visitAllDirs(tmpDir);
                continue;
            }
            badLocations.add(canonicalPath);
        }
        if (!badLocations.isEmpty()) {
            StringBuffer message = new StringBuffer("Error in project.xml: Can't open directories specified by 'source.location' properties in project.xml: ");
            for (String badLocation : badLocations) {
                message.append(endl + "\t\t" + badLocation);
            }
            throw new BuildException(message.toString());
        }
        HashSet<String> badSources = new HashSet<String>();
        for (Source s : this.sources.values()) {
            File sourceDir = null;
            for (String srcLocation : this.srcLocations) {
                File tmpDir = new File(srcLocation, s.getType());
                if (!tmpDir.exists()) continue;
                if (sourceDir != null) {
                    throw new BuildException("Error in project.xml: multiple directories found for source '" + s.getType() + "'.  Each source type must be uniquely named within the 'source.location' directories specified. Found in: " + endl + "\t\t" + sourceDir.getParent() + endl + "\t\t" + tmpDir.getParent());
                }
                sourceDir = tmpDir;
            }
            if (sourceDir != null) {
                s.setLocation(sourceDir);
                continue;
            }
            badSources.add(s.getType());
        }
        if (!badSources.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("Error in project.xml: Can't find directories for sources: ");
            for (String badSource : badSources) {
                stringBuffer.append("'" + badSource + "', ");
            }
            stringBuffer.append(" looked in: ");
            for (String srcLocation : this.srcLocations) {
                stringBuffer.append(endl + "\t\t" + srcLocation);
            }
            throw new BuildException(stringBuffer.toString());
        }
    }

    public List<String> getSourceLocations() {
        ArrayList<String> sourceLocations = new ArrayList<String>();
        for (UserProperty up : this.properties) {
            if (!"source.location".equals(up.getName())) continue;
            if (up.getLocation() == null) {
                throw new BuildException("Error in project.xml: no 'location' attribute given for a 'source.location' property element.  You must specify the location attribute.");
            }
            sourceLocations.add(up.getLocation());
        }
        return sourceLocations;
    }

    private void visitAllDirs(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            try {
                this.srcLocations.add(dir.getCanonicalPath());
            }
            catch (IOException e) {
                throw new BuildException("Error finding canonical path for 'source.location': " + dir.getPath());
            }
            for (String child : children = dir.list()) {
                this.visitAllDirs(new File(dir, child));
            }
        }
    }
}

