/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.fmi.jnifmuapi.Factory;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        Thread wokrer;
        File testDir = new File("target/conc-test");
        FileUtils.deleteDirectory((File)testDir);
        testDir.mkdirs();
        String fmuPath = args[0];
        System.out.println("FMU is: " + fmuPath);
        System.out.println("Starting replication...");
        File sourceFmu = new File(fmuPath);
        Vector<File> fmus = new Vector<File>();
        for (int i = 0; i < Integer.parseInt(args[1]); ++i) {
            File destFmu = new File(new File(testDir, "test-" + i), sourceFmu.getName());
            destFmu.getParentFile().mkdirs();
            FileUtils.copyFile((File)sourceFmu, (File)destFmu);
            fmus.add(destFmu);
            System.out.println("\tGenerated: " + destFmu.getPath());
        }
        System.out.println("Forking threads ...");
        Vector<Thread> threads = new Vector<Thread>();
        int tid = 0;
        for (File file : fmus) {
            wokrer = Main.createWorker(threads, file, tid++);
            wokrer.start();
            threads.add(wokrer);
        }
        Thread.sleep(200L);
        for (File file : fmus) {
            wokrer = Main.createWorker(threads, file, tid++);
            wokrer.start();
            threads.add(wokrer);
        }
        boolean finished = false;
        while (!finished) {
            Thread.sleep(1000L);
            Vector<Thread> vector = threads;
            synchronized (vector) {
                finished = threads.isEmpty();
                if (!finished) {
                    System.out.println("Waiting for " + threads.size() + " threads");
                }
            }
        }
        System.out.println(" ### DONE ###");
    }

    private static Thread createWorker(final List<Thread> threads, final File file, final int ftid) {
        System.out.println("\tForking thread (" + ftid + ") for: " + file.getPath());
        Thread wokrer = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object fmu = Factory.create((File)file);
                    fmu.load();
                    fmu.getVersion();
                    int INSTANCE_COUNT = 1000;
                    Thread helper = new Thread(new Runnable((IFmu)fmu){
                        final /* synthetic */ IFmu val$fmu;
                        {
                            this.val$fmu = iFmu;
                        }

                        @Override
                        public void run() {
                            try {
                                for (int i = 0; i < 500; ++i) {
                                    IFmiComponent comp = this.val$fmu.instantiate("{8c4e810f-3df3-4a00-8276-176fa3c9f000}", "n", false, false, Main.createCallback());
                                    if (comp == null) {
                                        System.err.println("No instance created(" + ftid + "). Aborting: " + file.getPath());
                                        return;
                                    }
                                    comp.enterInitializationMode();
                                    comp.exitInitializationMode();
                                    comp.freeInstance();
                                }
                            }
                            catch (FmiInvalidNativeStateException e) {
                                Main.handleError(e);
                            }
                            catch (FmuInvocationException e) {
                                Main.handleError(e);
                            }
                            catch (XPathExpressionException e) {
                                Main.handleError(e);
                            }
                        }
                    });
                    helper.start();
                    for (int i = 0; i < 500; ++i) {
                        IFmiComponent comp = fmu.instantiate("{8c4e810f-3df3-4a00-8276-176fa3c9f000}", "n", false, false, Main.createCallback());
                        if (comp == null) {
                            System.err.println("No instance created(" + ftid + "). Aborting: " + file.getPath());
                            return;
                        }
                        comp.enterInitializationMode();
                        comp.exitInitializationMode();
                        comp.freeInstance();
                    }
                    helper.join();
                    fmu.unLoad();
                    System.out.println("\tComplete (" + ftid + "): " + file.getPath());
                }
                catch (IOException | FmuInvocationException e) {
                    Main.handleError(e);
                }
                catch (FmuMissingLibraryException e) {
                    Main.handleError(e);
                }
                catch (XPathExpressionException e) {
                    Main.handleError(e);
                }
                catch (InterruptedException e) {
                    Main.handleError(e);
                }
                finally {
                    List e = threads;
                    synchronized (e) {
                        threads.remove(Thread.currentThread());
                    }
                }
            }
        });
        return wokrer;
    }

    private static void handleError(Throwable t) {
        t.printStackTrace();
    }

    private static IFmuCallback createCallback() {
        return new IFmuCallback(){

            public void stepFinished(Fmi2Status status) {
            }

            public void log(String instanceName, Fmi2Status status, String category, String message) {
                System.out.println(message);
            }
        };
    }
}

