/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.analysis;


import org.intocps.maestro.ast.node.AModuleType;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.node.AWhileStm;
import java.lang.Integer;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.node.PParameter;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.AParExp;
import java.lang.Long;
import org.intocps.maestro.ast.node.PDocument;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.SUnaryExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AFunctionType;
import java.util.Set;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.node.SNumericPrimitiveType;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.LexIdentifier;
import java.lang.Double;
import org.intocps.maestro.ast.node.AUnknownType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AObservableStm;
import java.util.ArrayList;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.PDeclaration;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.SLiteralExp;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.PStm;
import java.lang.Boolean;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.ABlockStm;
import java.lang.String;
import org.intocps.maestro.ast.node.IToken;
import java.util.LinkedList;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.SBinaryExp;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.node.SPrimitiveType;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.PFramework;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.AVoidType;
import org.intocps.maestro.ast.node.ARootDocument;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public abstract class DepthFirstAnalysisAdaptorQuestionAnswer<Q, A> implements IQuestionAnswer<Q, A>
{
	private static final long serialVersionUID = 1L;

	protected Set<INode> _visitedNodes = new java.util.HashSet<INode>();
	final protected IQuestionAnswer<Q, A> THIS;

	/**
	* Creates a new complete constructor {@code DepthFirstAnalysisAdaptorQuestionAnswer} node with the given nodes as children.
	* The basic child nodes are removed from their previous parents.
	* @param visitedNodes_ the {@link Set} node for the {@code visitedNodes} child of this {@link DepthFirstAnalysisAdaptorQuestionAnswer} node
	* @param THIS_ the {@link IQuestionAnswer} <b>graph</a> node for the {@code THIS} child of this {@link DepthFirstAnalysisAdaptorQuestionAnswer} node.
	*  <i>The parent of this {@code THIS } will not be changed by adding it to this node.</i>
	*/
	public DepthFirstAnalysisAdaptorQuestionAnswer(Set<INode> visitedNodes_, IQuestionAnswer<Q, A> THIS_)
	{
		super();
		this.setVisitedNodes(visitedNodes_);
		this.THIS = THIS_;

	}


	/**
	 * Creates a new default constructor {@link DepthFirstAnalysisAdaptorQuestionAnswer} node with no children.
	 */
	public DepthFirstAnalysisAdaptorQuestionAnswer()
	{
		this.THIS=this;

	}


	/**
	 * Sets the {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptorQuestionAnswer} node.
	 * @param value the new {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptorQuestionAnswer} node
	*/
	public void setVisitedNodes(Set<INode> value)
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseString(String node, Q question) throws AnalysisException
	{
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inString(node, question));


		mergeReturns(retVal,outString(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inString(String node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outString(String node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseBoolean(Boolean node, Q question) throws AnalysisException
	{
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inBoolean(node, question));


		mergeReturns(retVal,outBoolean(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inBoolean(Boolean node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outBoolean(Boolean node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseInteger(Integer node, Q question) throws AnalysisException
	{
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inInteger(node, question));


		mergeReturns(retVal,outInteger(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inInteger(Integer node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outInteger(Integer node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseDouble(Double node, Q question) throws AnalysisException
	{
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inDouble(node, question));


		mergeReturns(retVal,outDouble(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inDouble(Double node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outDouble(Double node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseLong(Long node, Q question) throws AnalysisException
	{
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inLong(node, question));


		mergeReturns(retVal,outLong(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inLong(Long node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outLong(Long node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseLexIdentifier(LexIdentifier node, Q question) throws AnalysisException
	{
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inLexIdentifier(node, question));


		mergeReturns(retVal,outLexIdentifier(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inLexIdentifier(LexIdentifier node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outLexIdentifier(LexIdentifier node, Q question) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseLexToken(LexToken node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inLexToken(node, question));


		mergeReturns(retVal,outLexToken(node, question));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inLexToken(LexToken node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outLexToken(LexToken node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A defaultInPDocument(PDocument node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A defaultOutPDocument(PDocument node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A defaultPDocument(PDocument node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A inPDocument(PDocument node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A outPDocument(PDocument node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public A caseARootDocument(ARootDocument node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inARootDocument(node, question));

		{
			List<PCompilationUnit> copy = new ArrayList<PCompilationUnit>(node.getContent());
			for( PCompilationUnit e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outARootDocument(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public A inARootDocument(ARootDocument node, Q question) throws AnalysisException
	{
		return defaultInPDocument(node, question);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public A outARootDocument(ARootDocument node, Q question) throws AnalysisException
	{
		return defaultOutPDocument(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A defaultInPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A defaultOutPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A defaultPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A inPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A outPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public A caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAImportedModuleCompilationUnit(node, question));

		{
			List<AFunctionDeclaration> copy = new ArrayList<AFunctionDeclaration>(node.getFunctions());
			for( AFunctionDeclaration e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outAImportedModuleCompilationUnit(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public A inAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultInPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public A outAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultOutPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public A caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inASimulationSpecificationCompilationUnit(node, question));

		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			mergeReturns(retVal,node.getBody().apply(this, question));
		}
		{
			List<AConfigFramework> copy = new ArrayList<AConfigFramework>(node.getFrameworkConfigs());
			for( AConfigFramework e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outASimulationSpecificationCompilationUnit(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public A inASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultInPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public A outASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Q question) throws AnalysisException
	{
		return defaultOutPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A defaultInPFramework(PFramework node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A defaultOutPFramework(PFramework node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A defaultPFramework(PFramework node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A inPFramework(PFramework node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A outPFramework(PFramework node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public A caseAConfigFramework(AConfigFramework node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAConfigFramework(node, question));


		mergeReturns(retVal,outAConfigFramework(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public A inAConfigFramework(AConfigFramework node, Q question) throws AnalysisException
	{
		return defaultInPFramework(node, question);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public A outAConfigFramework(AConfigFramework node, Q question) throws AnalysisException
	{
		return defaultOutPFramework(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A defaultInPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A defaultOutPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A defaultPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A inPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A outPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public A caseAFunctionDeclaration(AFunctionDeclaration node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAFunctionDeclaration(node, question));

		if(node.getReturnType() != null && !_visitedNodes.contains(node.getReturnType())) 
		{
			mergeReturns(retVal,node.getReturnType().apply(this, question));
		}
		{
			List<AFormalParameter> copy = new ArrayList<AFormalParameter>(node.getFormals());
			for( AFormalParameter e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outAFunctionDeclaration(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public A inAFunctionDeclaration(AFunctionDeclaration node, Q question) throws AnalysisException
	{
		return defaultInPDeclaration(node, question);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public A outAFunctionDeclaration(AFunctionDeclaration node, Q question) throws AnalysisException
	{
		return defaultOutPDeclaration(node, question);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public A caseAVariableDeclaration(AVariableDeclaration node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAVariableDeclaration(node, question));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this, question));
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getSize());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}
		if(node.getInitializer() != null && !_visitedNodes.contains(node.getInitializer())) 
		{
			mergeReturns(retVal,node.getInitializer().apply(this, question));
		}

		mergeReturns(retVal,outAVariableDeclaration(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public A inAVariableDeclaration(AVariableDeclaration node, Q question) throws AnalysisException
	{
		return defaultInPDeclaration(node, question);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public A outAVariableDeclaration(AVariableDeclaration node, Q question) throws AnalysisException
	{
		return defaultOutPDeclaration(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A defaultInPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A defaultOutPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A defaultPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A inPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A outPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public A caseAExpInitializer(AExpInitializer node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAExpInitializer(node, question));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAExpInitializer(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public A inAExpInitializer(AExpInitializer node, Q question) throws AnalysisException
	{
		return defaultInPInitializer(node, question);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public A outAExpInitializer(AExpInitializer node, Q question) throws AnalysisException
	{
		return defaultOutPInitializer(node, question);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public A caseAArrayInitializer(AArrayInitializer node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAArrayInitializer(node, question));

		{
			List<PExp> copy = new ArrayList<PExp>(node.getExp());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outAArrayInitializer(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public A inAArrayInitializer(AArrayInitializer node, Q question) throws AnalysisException
	{
		return defaultInPInitializer(node, question);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public A outAArrayInitializer(AArrayInitializer node, Q question) throws AnalysisException
	{
		return defaultOutPInitializer(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A defaultInPParameter(PParameter node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A defaultOutPParameter(PParameter node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A defaultPParameter(PParameter node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A inPParameter(PParameter node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A outPParameter(PParameter node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public A caseAFormalParameter(AFormalParameter node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAFormalParameter(node, question));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this, question));
		}

		mergeReturns(retVal,outAFormalParameter(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public A inAFormalParameter(AFormalParameter node, Q question) throws AnalysisException
	{
		return defaultInPParameter(node, question);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public A outAFormalParameter(AFormalParameter node, Q question) throws AnalysisException
	{
		return defaultOutPParameter(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A defaultInPExp(PExp node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A defaultOutPExp(PExp node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A defaultPExp(PExp node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A inPExp(PExp node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A outPExp(PExp node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public A caseAIdentifierExp(AIdentifierExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAIdentifierExp(node, question));


		mergeReturns(retVal,outAIdentifierExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public A inAIdentifierExp(AIdentifierExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public A outAIdentifierExp(AIdentifierExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A defaultInSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A defaultOutSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A defaultSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		return defaultPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A inSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A outSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public A caseALoadExp(ALoadExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inALoadExp(node, question));

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outALoadExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public A inALoadExp(ALoadExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public A outALoadExp(ALoadExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public A caseAUnloadExp(AUnloadExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAUnloadExp(node, question));

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outAUnloadExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public A inAUnloadExp(AUnloadExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public A outAUnloadExp(AUnloadExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A defaultInSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A defaultOutSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A defaultSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		return defaultPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A inSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A outSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A defaultInSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A defaultOutSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A defaultSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		return defaultPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A inSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A outSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public A caseAFieldExp(AFieldExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAFieldExp(node, question));

		if(node.getRoot() != null && !_visitedNodes.contains(node.getRoot())) 
		{
			mergeReturns(retVal,node.getRoot().apply(this, question));
		}

		mergeReturns(retVal,outAFieldExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public A inAFieldExp(AFieldExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public A outAFieldExp(AFieldExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public A caseACallExp(ACallExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inACallExp(node, question));

		if(node.getObject() != null && !_visitedNodes.contains(node.getObject())) 
		{
			mergeReturns(retVal,node.getObject().apply(this, question));
		}
		if(node.getExpand() != null ) 
		{
			mergeReturns(retVal,node.getExpand().apply(this, question));
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outACallExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public A inACallExp(ACallExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public A outACallExp(ACallExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public A caseAArrayIndexExp(AArrayIndexExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAArrayIndexExp(node, question));

		if(node.getArray() != null && !_visitedNodes.contains(node.getArray())) 
		{
			mergeReturns(retVal,node.getArray().apply(this, question));
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getIndices());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outAArrayIndexExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public A inAArrayIndexExp(AArrayIndexExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public A outAArrayIndexExp(AArrayIndexExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public A caseAParExp(AParExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAParExp(node, question));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAParExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public A inAParExp(AParExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public A outAParExp(AParExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public A caseANullExp(ANullExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inANullExp(node, question));

		if(node.getToken() != null ) 
		{
			mergeReturns(retVal,node.getToken().apply(this, question));
		}

		mergeReturns(retVal,outANullExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public A inANullExp(ANullExp node, Q question) throws AnalysisException
	{
		return defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public A outANullExp(ANullExp node, Q question) throws AnalysisException
	{
		return defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public A caseAStringLiteralExp(AStringLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAStringLiteralExp(node, question));


		mergeReturns(retVal,outAStringLiteralExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public A inAStringLiteralExp(AStringLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public A outAStringLiteralExp(AStringLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public A caseABoolLiteralExp(ABoolLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inABoolLiteralExp(node, question));


		mergeReturns(retVal,outABoolLiteralExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public A inABoolLiteralExp(ABoolLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public A outABoolLiteralExp(ABoolLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public A caseAIntLiteralExp(AIntLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAIntLiteralExp(node, question));


		mergeReturns(retVal,outAIntLiteralExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public A inAIntLiteralExp(AIntLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public A outAIntLiteralExp(AIntLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public A caseAUIntLiteralExp(AUIntLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAUIntLiteralExp(node, question));


		mergeReturns(retVal,outAUIntLiteralExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public A inAUIntLiteralExp(AUIntLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public A outAUIntLiteralExp(AUIntLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public A caseARealLiteralExp(ARealLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inARealLiteralExp(node, question));


		mergeReturns(retVal,outARealLiteralExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public A inARealLiteralExp(ARealLiteralExp node, Q question) throws AnalysisException
	{
		return defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public A outARealLiteralExp(ARealLiteralExp node, Q question) throws AnalysisException
	{
		return defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public A caseAPlusBinaryExp(APlusBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAPlusBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAPlusBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public A inAPlusBinaryExp(APlusBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public A outAPlusBinaryExp(APlusBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public A caseAMinusBinaryExp(AMinusBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAMinusBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAMinusBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public A inAMinusBinaryExp(AMinusBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public A outAMinusBinaryExp(AMinusBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public A caseALessEqualBinaryExp(ALessEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inALessEqualBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outALessEqualBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public A inALessEqualBinaryExp(ALessEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public A outALessEqualBinaryExp(ALessEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public A caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAGreaterEqualBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAGreaterEqualBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public A inAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public A outAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public A caseALessBinaryExp(ALessBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inALessBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outALessBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public A inALessBinaryExp(ALessBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public A outALessBinaryExp(ALessBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public A caseAGreaterBinaryExp(AGreaterBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAGreaterBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAGreaterBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public A inAGreaterBinaryExp(AGreaterBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public A outAGreaterBinaryExp(AGreaterBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public A caseAEqualBinaryExp(AEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAEqualBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAEqualBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public A inAEqualBinaryExp(AEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public A outAEqualBinaryExp(AEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public A caseANotEqualBinaryExp(ANotEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inANotEqualBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outANotEqualBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public A inANotEqualBinaryExp(ANotEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public A outANotEqualBinaryExp(ANotEqualBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public A caseAOrBinaryExp(AOrBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAOrBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAOrBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public A inAOrBinaryExp(AOrBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public A outAOrBinaryExp(AOrBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public A caseAAndBinaryExp(AAndBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAAndBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAAndBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public A inAAndBinaryExp(AAndBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public A outAAndBinaryExp(AAndBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public A caseADivideBinaryExp(ADivideBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inADivideBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outADivideBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public A inADivideBinaryExp(ADivideBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public A outADivideBinaryExp(ADivideBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public A caseAMultiplyBinaryExp(AMultiplyBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAMultiplyBinaryExp(node, question));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this, question));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this, question));
		}

		mergeReturns(retVal,outAMultiplyBinaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public A inAMultiplyBinaryExp(AMultiplyBinaryExp node, Q question) throws AnalysisException
	{
		return defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public A outAMultiplyBinaryExp(AMultiplyBinaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public A caseANotUnaryExp(ANotUnaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inANotUnaryExp(node, question));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outANotUnaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public A inANotUnaryExp(ANotUnaryExp node, Q question) throws AnalysisException
	{
		return defaultInSUnaryExp(node, question);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public A outANotUnaryExp(ANotUnaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSUnaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public A caseAMinusUnaryExp(AMinusUnaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAMinusUnaryExp(node, question));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAMinusUnaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public A inAMinusUnaryExp(AMinusUnaryExp node, Q question) throws AnalysisException
	{
		return defaultInSUnaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public A outAMinusUnaryExp(AMinusUnaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSUnaryExp(node, question);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public A caseAPlusUnaryExp(APlusUnaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAPlusUnaryExp(node, question));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAPlusUnaryExp(node, question));
		return retVal;
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public A inAPlusUnaryExp(APlusUnaryExp node, Q question) throws AnalysisException
	{
		return defaultInSUnaryExp(node, question);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public A outAPlusUnaryExp(APlusUnaryExp node, Q question) throws AnalysisException
	{
		return defaultOutSUnaryExp(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A defaultInPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A defaultOutPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A defaultPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A inPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A outPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public A caseAIdentifierStateDesignator(AIdentifierStateDesignator node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAIdentifierStateDesignator(node, question));


		mergeReturns(retVal,outAIdentifierStateDesignator(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public A inAIdentifierStateDesignator(AIdentifierStateDesignator node, Q question) throws AnalysisException
	{
		return defaultInPStateDesignator(node, question);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public A outAIdentifierStateDesignator(AIdentifierStateDesignator node, Q question) throws AnalysisException
	{
		return defaultOutPStateDesignator(node, question);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public A caseAArrayStateDesignator(AArrayStateDesignator node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAArrayStateDesignator(node, question));

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			mergeReturns(retVal,node.getTarget().apply(this, question));
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAArrayStateDesignator(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public A inAArrayStateDesignator(AArrayStateDesignator node, Q question) throws AnalysisException
	{
		return defaultInPStateDesignator(node, question);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public A outAArrayStateDesignator(AArrayStateDesignator node, Q question) throws AnalysisException
	{
		return defaultOutPStateDesignator(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A defaultInPStm(PStm node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A defaultOutPStm(PStm node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A defaultPStm(PStm node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A inPStm(PStm node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A outPStm(PStm node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link ABlockStm} node from {@link ABlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABlockStm} node
	*/
	public A caseABlockStm(ABlockStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inABlockStm(node, question));

		{
			List<PStm> copy = new ArrayList<PStm>(node.getBody());
			for( PStm e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outABlockStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ABlockStm} node from {@link ABlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABlockStm} node
	*/
	public A inABlockStm(ABlockStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ABlockStm} node from {@link ABlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABlockStm} node
	*/
	public A outABlockStm(ABlockStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public A caseAAssigmentStm(AAssigmentStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAAssigmentStm(node, question));

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			mergeReturns(retVal,node.getTarget().apply(this, question));
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAAssigmentStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public A inAAssigmentStm(AAssigmentStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public A outAAssigmentStm(AAssigmentStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public A caseALocalVariableStm(ALocalVariableStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inALocalVariableStm(node, question));

		if(node.getDeclaration() != null && !_visitedNodes.contains(node.getDeclaration())) 
		{
			mergeReturns(retVal,node.getDeclaration().apply(this, question));
		}

		mergeReturns(retVal,outALocalVariableStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public A inALocalVariableStm(ALocalVariableStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public A outALocalVariableStm(ALocalVariableStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public A caseAIfStm(AIfStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAIfStm(node, question));

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			mergeReturns(retVal,node.getTest().apply(this, question));
		}
		if(node.getThen() != null && !_visitedNodes.contains(node.getThen())) 
		{
			mergeReturns(retVal,node.getThen().apply(this, question));
		}
		if(node.getElse() != null && !_visitedNodes.contains(node.getElse())) 
		{
			mergeReturns(retVal,node.getElse().apply(this, question));
		}

		mergeReturns(retVal,outAIfStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public A inAIfStm(AIfStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public A outAIfStm(AIfStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public A caseAWhileStm(AWhileStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAWhileStm(node, question));

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			mergeReturns(retVal,node.getTest().apply(this, question));
		}
		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			mergeReturns(retVal,node.getBody().apply(this, question));
		}

		mergeReturns(retVal,outAWhileStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public A inAWhileStm(AWhileStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public A outAWhileStm(AWhileStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public A caseAExpressionStm(AExpressionStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAExpressionStm(node, question));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this, question));
		}

		mergeReturns(retVal,outAExpressionStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public A inAExpressionStm(AExpressionStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public A outAExpressionStm(AExpressionStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public A caseAObservableStm(AObservableStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAObservableStm(node, question));

		if(node.getIdentifier() != null && !_visitedNodes.contains(node.getIdentifier())) 
		{
			mergeReturns(retVal,node.getIdentifier().apply(this, question));
		}

		mergeReturns(retVal,outAObservableStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public A inAObservableStm(AObservableStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public A outAObservableStm(AObservableStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public A caseABreakStm(ABreakStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inABreakStm(node, question));

		if(node.getToken() != null ) 
		{
			mergeReturns(retVal,node.getToken().apply(this, question));
		}

		mergeReturns(retVal,outABreakStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public A inABreakStm(ABreakStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public A outABreakStm(ABreakStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public A caseAInstanceMappingStm(AInstanceMappingStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAInstanceMappingStm(node, question));


		mergeReturns(retVal,outAInstanceMappingStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public A inAInstanceMappingStm(AInstanceMappingStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public A outAInstanceMappingStm(AInstanceMappingStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public A caseAConfigStm(AConfigStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAConfigStm(node, question));


		mergeReturns(retVal,outAConfigStm(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public A inAConfigStm(AConfigStm node, Q question) throws AnalysisException
	{
		return defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public A outAConfigStm(AConfigStm node, Q question) throws AnalysisException
	{
		return defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A defaultInPType(PType node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A defaultOutPType(PType node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A defaultPType(PType node, Q question) throws AnalysisException
	{
		return defaultINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A inPType(PType node, Q question) throws AnalysisException
	{
		return defaultInINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A outPType(PType node, Q question) throws AnalysisException
	{
		return defaultOutINode(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A defaultInSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A defaultOutSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A defaultSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A inSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A outSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public A caseANameType(ANameType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inANameType(node, question));


		mergeReturns(retVal,outANameType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public A inANameType(ANameType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public A outANameType(ANameType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public A caseAFunctionType(AFunctionType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAFunctionType(node, question));

		if(node.getResult() != null && !_visitedNodes.contains(node.getResult())) 
		{
			mergeReturns(retVal,node.getResult().apply(this, question));
		}
		{
			List<PType> copy = new ArrayList<PType>(node.getParameters());
			for( PType e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this, question));
				}
			}
		}

		mergeReturns(retVal,outAFunctionType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public A inAFunctionType(AFunctionType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public A outAFunctionType(AFunctionType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public A caseAArrayType(AArrayType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAArrayType(node, question));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this, question));
		}

		mergeReturns(retVal,outAArrayType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public A inAArrayType(AArrayType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public A outAArrayType(AArrayType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public A caseAUnknownType(AUnknownType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAUnknownType(node, question));


		mergeReturns(retVal,outAUnknownType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public A inAUnknownType(AUnknownType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public A outAUnknownType(AUnknownType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public A caseAVoidType(AVoidType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAVoidType(node, question));


		mergeReturns(retVal,outAVoidType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public A inAVoidType(AVoidType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public A outAVoidType(AVoidType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public A caseAModuleType(AModuleType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAModuleType(node, question));

		if(node.getName() != null && !_visitedNodes.contains(node.getName())) 
		{
			mergeReturns(retVal,node.getName().apply(this, question));
		}

		mergeReturns(retVal,outAModuleType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public A inAModuleType(AModuleType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public A outAModuleType(AModuleType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public A caseAReferenceType(AReferenceType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAReferenceType(node, question));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this, question));
		}

		mergeReturns(retVal,outAReferenceType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public A inAReferenceType(AReferenceType node, Q question) throws AnalysisException
	{
		return defaultInPType(node, question);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public A outAReferenceType(AReferenceType node, Q question) throws AnalysisException
	{
		return defaultOutPType(node, question);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public A caseABooleanPrimitiveType(ABooleanPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inABooleanPrimitiveType(node, question));


		mergeReturns(retVal,outABooleanPrimitiveType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public A inABooleanPrimitiveType(ABooleanPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public A outABooleanPrimitiveType(ABooleanPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public A caseAStringPrimitiveType(AStringPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAStringPrimitiveType(node, question));


		mergeReturns(retVal,outAStringPrimitiveType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public A inAStringPrimitiveType(AStringPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public A outAStringPrimitiveType(AStringPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A defaultInSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A defaultOutSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A defaultSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A inSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A outSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public A caseARealNumericPrimitiveType(ARealNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inARealNumericPrimitiveType(node, question));


		mergeReturns(retVal,outARealNumericPrimitiveType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public A inARealNumericPrimitiveType(ARealNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public A outARealNumericPrimitiveType(ARealNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public A caseAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAIntNumericPrimitiveType(node, question));


		mergeReturns(retVal,outAIntNumericPrimitiveType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public A inAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public A outAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public A caseAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node, question);
		mergeReturns(retVal,inAUIntNumericPrimitiveType(node, question));


		mergeReturns(retVal,outAUIntNumericPrimitiveType(node, question));
		return retVal;
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public A inAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public A outAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		return defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public A defaultOutINode(INode node, Q question) throws AnalysisException
	{
		return createNewReturnValue(node, question);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public A defaultInINode(INode node, Q question) throws AnalysisException
	{
		return createNewReturnValue(node, question);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public A defaultINode(INode node, Q question) throws AnalysisException
	{
		return createNewReturnValue(node, question);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A defaultOutIToken(IToken node, Q question) throws AnalysisException
	{
		return createNewReturnValue(node, question);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A defaultInIToken(IToken node, Q question) throws AnalysisException
	{
		return createNewReturnValue(node, question);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A defaultIToken(IToken node, Q question) throws AnalysisException
	{
		return createNewReturnValue(node, question);
	}



	public abstract A mergeReturns(A original, A new_);


	public abstract A createNewReturnValue(INode node, Q question) throws AnalysisException;


	public abstract A createNewReturnValue(Object node, Q question) throws AnalysisException;


}
