/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AArrayIndexExp extends PExpBase
{
	private static final long serialVersionUID = 1L;

	private PExp _array;
	private NodeList<PExp> _indices = new NodeList<PExp>(this);


	/**
	 * Creates a new default constructor {@link AArrayIndexExp} node with no children.
	 */
	public AArrayIndexExp()
	{

	}


	/**
	* Creates a new complete constructor {@code AArrayIndexExp} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param array_ the {@link PExp} node for the {@code array} child of this {@link AArrayIndexExp} node
	* @param indices_ the {@link NodeList} node for the {@code indices} child of this {@link AArrayIndexExp} node
	*/
	public AArrayIndexExp(PExp array_, List<? extends PExp> indices_)
	{
		super();
		this.setArray(array_);
		this.setIndices(indices_);

	}



	public String toString()
	{
		return "" + ""+ _array +"[" +_indices.stream().map(Object::toString).collect(Collectors.joining(", "))+"]";
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Returns a deep clone of this {@link AArrayIndexExp} node.
	 * @return a deep clone of this {@link AArrayIndexExp} node
	 */
	public AArrayIndexExp clone()
	{
		return new AArrayIndexExp(
			cloneNode(_array),
			cloneList(_indices)
		);
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_array",this._array);
		fields.put("_indices",this._indices);
		return fields;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AArrayIndexExp} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AArrayIndexExp} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AArrayIndexExp} node
	 */
	public void removeChild(INode child)
	{
		if (this._array == child) {
			this._array = null;
			return;
		}

		if (this._indices.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AArrayIndexExp)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Creates a deep clone of this {@link AArrayIndexExp} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AArrayIndexExp} node
	 */
	public AArrayIndexExp clone(Map<INode,INode> oldToNewMap)
	{
		AArrayIndexExp node = new AArrayIndexExp(
			cloneNode(_array, oldToNewMap),
			cloneList(_indices, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Sets the {@code _array} child of this {@link AArrayIndexExp} node.
	 * @param value the new {@code _array} child of this {@link AArrayIndexExp} node
	*/
	public void setArray(PExp value)
	{
		if (this._array != null) {
			this._array.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._array = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _array} child of this {@link AArrayIndexExp} node
	*/
	public PExp getArray()
	{
		return this._array;
	}


	/**
	 * Sets the {@code _indices} child of this {@link AArrayIndexExp} node.
	 * @param value the new {@code _indices} child of this {@link AArrayIndexExp} node
	*/
	public void setIndices(List<? extends PExp> value)
	{
		if (this._indices.equals(value)) {
			return;
		}
		this._indices.clear();
		if (value != null) {
			this._indices.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _indices} child of this {@link AArrayIndexExp} node
	*/
	public LinkedList<PExp> getIndices()
	{
		return this._indices;
	}


	/**
	* Calls the {@link IAnalysis#caseAArrayIndexExp(AArrayIndexExp)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AArrayIndexExp} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAArrayIndexExp(this);
	}


	/**
	* Calls the {@link IAnswer#caseAArrayIndexExp(AArrayIndexExp)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AArrayIndexExp} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAArrayIndexExp(this);
	}


	/**
	* Calls the {@link IQuestion#caseAArrayIndexExp(AArrayIndexExp, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AArrayIndexExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAArrayIndexExp(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAArrayIndexExp(AArrayIndexExp, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AArrayIndexExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAArrayIndexExp(this,question);
	}



}
