/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PTypeBase;
import org.intocps.maestro.ast.node.GraphNodeList;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AFunctionType;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.List;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AFunctionType extends PTypeBase
{
	private static final long serialVersionUID = 1L;

	/**
	* Graph field, parent will not be removed when added and parent 
	*  of this field may not be this node. Also excluded for visitor.
	*/
	private PType _result;
	/**
	* Graph field, parent will not be removed when added and parent 
	*  of this field may not be this node. Also excluded for visitor.
	*/
	private GraphNodeList<PType> _parameters = new GraphNodeList<PType>(this);

	/**
	* Creates a new complete constructor {@code AFunctionType} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param result_ the {@link PType} <b>graph</a> node for the {@code result} child of this {@link AFunctionType} node.
	*  <i>The parent of this {@code result } will not be changed by adding it to this node.</i>
	* @param parameters_ the {@link GraphNodeList} <b>graph</a> node for the {@code parameters} child of this {@link AFunctionType} node.
	*  <i>The parent of this {@code parameters } will not be changed by adding it to this node.</i>
	*/
	public AFunctionType(PType result_, List<? extends PType> parameters_)
	{
		super();
		this.setResult(result_);
		this.setParameters(parameters_);

	}


	/**
	 * Creates a new default constructor {@link AFunctionType} node with no children.
	 */
	public AFunctionType()
	{

	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_result",this._result);
		fields.put("_parameters",this._parameters);
		return fields;
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a deep clone of this {@link AFunctionType} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AFunctionType} node
	 */
	public AFunctionType clone(Map<INode,INode> oldToNewMap)
	{
		AFunctionType node = new AFunctionType(
			_result,
			_parameters
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AFunctionType} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AFunctionType} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AFunctionType} node
	 */
	public void removeChild(INode child)
	{
		if (this._result == child) {
			return;
		}

		if (this._parameters.contains(child)) {
			return;
		}

		throw new RuntimeException("Not a child.");
	}



	public String toString()
	{
		return (_result!=null?_result.toString():this.getClass().getSimpleName())+ (_parameters!=null?_parameters.toString():this.getClass().getSimpleName());
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AFunctionType)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Returns a deep clone of this {@link AFunctionType} node.
	 * @return a deep clone of this {@link AFunctionType} node
	 */
	public AFunctionType clone()
	{
		return new AFunctionType(
			_result,
			_parameters
		);
	}


	/**
	 * Sets the {@code _result} child of this {@link AFunctionType} node.
	 * @param value the new {@code _result} child of this {@link AFunctionType} node
	*/
	public void setResult(PType value)
	{
		if( value != null && value.parent() == null) {
			value.parent(this);
		}
		this._result = value;

	}


	/**
	 * @return the {@link PType} node which is the {@code _result} child of this {@link AFunctionType} node
	*/
	public PType getResult()
	{
		return this._result;
	}


	/**
	 * Sets the {@code _parameters} child of this {@link AFunctionType} node.
	 * @param value the new {@code _parameters} child of this {@link AFunctionType} node
	*/
	public void setParameters(List<? extends PType> value)
	{
		if (this._parameters.equals(value)) {
			return;
		}
		this._parameters.clear();
		if (value != null) {
			this._parameters.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _parameters} child of this {@link AFunctionType} node
	*/
	public LinkedList<PType> getParameters()
	{
		return this._parameters;
	}


	/**
	* Calls the {@link IAnalysis#caseAFunctionType(AFunctionType)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AFunctionType} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAFunctionType(this);
	}


	/**
	* Calls the {@link IAnswer#caseAFunctionType(AFunctionType)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AFunctionType} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAFunctionType(this);
	}


	/**
	* Calls the {@link IQuestion#caseAFunctionType(AFunctionType, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AFunctionType} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAFunctionType(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAFunctionType(AFunctionType, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AFunctionType} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAFunctionType(this,question);
	}



}
