/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.PCompilationUnitBase;
import java.util.HashMap;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import java.util.List;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AImportedModuleCompilationUnit extends PCompilationUnitBase
{
	private static final long serialVersionUID = 1L;

	private LexIdentifier _name;
	private NodeList<AFunctionDeclaration> _functions = new NodeList<AFunctionDeclaration>(this);

	/**
	 * Creates a new default constructor {@link AImportedModuleCompilationUnit} node with no children.
	 */
	public AImportedModuleCompilationUnit()
	{

	}


	/**
	* Creates a new complete constructor {@code AImportedModuleCompilationUnit} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param name_ the {@link LexIdentifier} node for the {@code name} child of this {@link AImportedModuleCompilationUnit} node
	* @param functions_ the {@link NodeList} node for the {@code functions} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public AImportedModuleCompilationUnit(LexIdentifier name_, List<? extends AFunctionDeclaration> functions_)
	{
		super();
		this.setName(name_);
		this.setFunctions(functions_);

	}



	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AImportedModuleCompilationUnit} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AImportedModuleCompilationUnit} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AImportedModuleCompilationUnit} node
	 */
	public void removeChild(INode child)
	{
		if (this._functions.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_name",this._name);
		fields.put("_functions",this._functions);
		return fields;
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}



	public String toString()
	{
		return "" + "imported "+ _name+" {"+ _functions.stream().map(Object::toString).collect(Collectors.joining(";\n","\n","\n"))+"}";
	}


	/**
	 * Returns a deep clone of this {@link AImportedModuleCompilationUnit} node.
	 * @return a deep clone of this {@link AImportedModuleCompilationUnit} node
	 */
	public AImportedModuleCompilationUnit clone()
	{
		return new AImportedModuleCompilationUnit(
			_name,
			cloneList(_functions)
		);
	}


	/**
	 * Creates a deep clone of this {@link AImportedModuleCompilationUnit} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AImportedModuleCompilationUnit} node
	 */
	public AImportedModuleCompilationUnit clone(Map<INode,INode> oldToNewMap)
	{
		AImportedModuleCompilationUnit node = new AImportedModuleCompilationUnit(
			_name,
			cloneList(_functions, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AImportedModuleCompilationUnit)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Sets the {@code _name} child of this {@link AImportedModuleCompilationUnit} node.
	 * @param value the new {@code _name} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public void setName(LexIdentifier value)
	{
		this._name = value;
	}


	/**
	 * @return the {@link LexIdentifier} node which is the {@code _name} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public LexIdentifier getName()
	{
		return this._name;
	}


	/**
	 * Sets the {@code _functions} child of this {@link AImportedModuleCompilationUnit} node.
	 * @param value the new {@code _functions} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public void setFunctions(List<? extends AFunctionDeclaration> value)
	{
		if (this._functions.equals(value)) {
			return;
		}
		this._functions.clear();
		if (value != null) {
			this._functions.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _functions} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public LinkedList<AFunctionDeclaration> getFunctions()
	{
		return this._functions;
	}


	/**
	* Calls the {@link IAnalysis#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AImportedModuleCompilationUnit} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAImportedModuleCompilationUnit(this);
	}


	/**
	* Calls the {@link IAnswer#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AImportedModuleCompilationUnit} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAImportedModuleCompilationUnit(this);
	}


	/**
	* Calls the {@link IQuestion#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AImportedModuleCompilationUnit} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAImportedModuleCompilationUnit(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AImportedModuleCompilationUnit} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAImportedModuleCompilationUnit(this,question);
	}



}
