/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.PDeclaration;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AFunctionType;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.AModuleType;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.AObservableStm;
import org.intocps.maestro.ast.node.AParExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AUnknownType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AVoidType;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.IToken;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.PDocument;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PFramework;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PParameter;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBinaryExp;
import org.intocps.maestro.ast.node.SLiteralExp;
import org.intocps.maestro.ast.node.SNumericPrimitiveType;
import org.intocps.maestro.ast.node.SPrimitiveType;
import org.intocps.maestro.ast.node.SUnaryExp;

public abstract class DepthFirstAnalysisAdaptor
implements IAnalysis {
    private static final long serialVersionUID = 1L;
    protected Set<INode> _visitedNodes = new HashSet<INode>();
    protected final IAnalysis THIS;

    public DepthFirstAnalysisAdaptor(Set<INode> visitedNodes_, IAnalysis THIS_) {
        this.setVisitedNodes(visitedNodes_);
        this.THIS = THIS_;
    }

    public DepthFirstAnalysisAdaptor() {
        this.THIS = this;
    }

    public void setVisitedNodes(Set<INode> value) {
    }

    @Override
    public void caseString(String node) throws AnalysisException {
        this.inString(node);
        this.outString(node);
    }

    public void inString(String node) throws AnalysisException {
    }

    public void outString(String node) throws AnalysisException {
    }

    @Override
    public void caseBoolean(Boolean node) throws AnalysisException {
        this.inBoolean(node);
        this.outBoolean(node);
    }

    public void inBoolean(Boolean node) throws AnalysisException {
    }

    public void outBoolean(Boolean node) throws AnalysisException {
    }

    @Override
    public void caseInteger(Integer node) throws AnalysisException {
        this.inInteger(node);
        this.outInteger(node);
    }

    public void inInteger(Integer node) throws AnalysisException {
    }

    public void outInteger(Integer node) throws AnalysisException {
    }

    @Override
    public void caseDouble(Double node) throws AnalysisException {
        this.inDouble(node);
        this.outDouble(node);
    }

    public void inDouble(Double node) throws AnalysisException {
    }

    public void outDouble(Double node) throws AnalysisException {
    }

    @Override
    public void caseLong(Long node) throws AnalysisException {
        this.inLong(node);
        this.outLong(node);
    }

    public void inLong(Long node) throws AnalysisException {
    }

    public void outLong(Long node) throws AnalysisException {
    }

    @Override
    public void caseLexIdentifier(LexIdentifier node) throws AnalysisException {
        this.inLexIdentifier(node);
        this.outLexIdentifier(node);
    }

    public void inLexIdentifier(LexIdentifier node) throws AnalysisException {
    }

    public void outLexIdentifier(LexIdentifier node) throws AnalysisException {
    }

    @Override
    public void caseLexToken(LexToken node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inLexToken(node);
        this.outLexToken(node);
    }

    public void inLexToken(LexToken node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outLexToken(LexToken node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    public void defaultInPDocument(PDocument node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPDocument(PDocument node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPDocument(PDocument node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPDocument(PDocument node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPDocument(PDocument node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseARootDocument(ARootDocument node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inARootDocument(node);
        ArrayList<PCompilationUnit> copy = new ArrayList<PCompilationUnit>(node.getContent());
        for (PCompilationUnit e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outARootDocument(node);
    }

    public void inARootDocument(ARootDocument node) throws AnalysisException {
        this.defaultInPDocument(node);
    }

    public void outARootDocument(ARootDocument node) throws AnalysisException {
        this.defaultOutPDocument(node);
    }

    public void defaultInPCompilationUnit(PCompilationUnit node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPCompilationUnit(PCompilationUnit node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPCompilationUnit(PCompilationUnit node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPCompilationUnit(PCompilationUnit node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPCompilationUnit(PCompilationUnit node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAImportedModuleCompilationUnit(node);
        ArrayList<AFunctionDeclaration> copy = new ArrayList<AFunctionDeclaration>(node.getFunctions());
        for (AFunctionDeclaration e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outAImportedModuleCompilationUnit(node);
    }

    public void inAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException {
        this.defaultInPCompilationUnit(node);
    }

    public void outAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException {
        this.defaultOutPCompilationUnit(node);
    }

    @Override
    public void caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inASimulationSpecificationCompilationUnit(node);
        if (node.getBody() != null && !this._visitedNodes.contains(node.getBody())) {
            node.getBody().apply(this);
        }
        ArrayList<AConfigFramework> copy = new ArrayList<AConfigFramework>(node.getFrameworkConfigs());
        for (AConfigFramework e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outASimulationSpecificationCompilationUnit(node);
    }

    public void inASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException {
        this.defaultInPCompilationUnit(node);
    }

    public void outASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException {
        this.defaultOutPCompilationUnit(node);
    }

    public void defaultInPFramework(PFramework node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPFramework(PFramework node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPFramework(PFramework node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPFramework(PFramework node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPFramework(PFramework node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAConfigFramework(AConfigFramework node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAConfigFramework(node);
        this.outAConfigFramework(node);
    }

    public void inAConfigFramework(AConfigFramework node) throws AnalysisException {
        this.defaultInPFramework(node);
    }

    public void outAConfigFramework(AConfigFramework node) throws AnalysisException {
        this.defaultOutPFramework(node);
    }

    public void defaultInPDeclaration(PDeclaration node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPDeclaration(PDeclaration node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPDeclaration(PDeclaration node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPDeclaration(PDeclaration node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPDeclaration(PDeclaration node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAFunctionDeclaration(node);
        if (node.getReturnType() != null && !this._visitedNodes.contains(node.getReturnType())) {
            node.getReturnType().apply(this);
        }
        ArrayList<AFormalParameter> copy = new ArrayList<AFormalParameter>(node.getFormals());
        for (AFormalParameter e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outAFunctionDeclaration(node);
    }

    public void inAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException {
        this.defaultInPDeclaration(node);
    }

    public void outAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException {
        this.defaultOutPDeclaration(node);
    }

    @Override
    public void caseAVariableDeclaration(AVariableDeclaration node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAVariableDeclaration(node);
        if (node.getType() != null && !this._visitedNodes.contains(node.getType())) {
            node.getType().apply(this);
        }
        ArrayList<PExp> copy = new ArrayList<PExp>(node.getSize());
        for (PExp e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        if (node.getInitializer() != null && !this._visitedNodes.contains(node.getInitializer())) {
            node.getInitializer().apply(this);
        }
        this.outAVariableDeclaration(node);
    }

    public void inAVariableDeclaration(AVariableDeclaration node) throws AnalysisException {
        this.defaultInPDeclaration(node);
    }

    public void outAVariableDeclaration(AVariableDeclaration node) throws AnalysisException {
        this.defaultOutPDeclaration(node);
    }

    public void defaultInPInitializer(PInitializer node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPInitializer(PInitializer node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPInitializer(PInitializer node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPInitializer(PInitializer node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPInitializer(PInitializer node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAExpInitializer(AExpInitializer node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAExpInitializer(node);
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAExpInitializer(node);
    }

    public void inAExpInitializer(AExpInitializer node) throws AnalysisException {
        this.defaultInPInitializer(node);
    }

    public void outAExpInitializer(AExpInitializer node) throws AnalysisException {
        this.defaultOutPInitializer(node);
    }

    @Override
    public void caseAArrayInitializer(AArrayInitializer node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAArrayInitializer(node);
        ArrayList<PExp> copy = new ArrayList<PExp>(node.getExp());
        for (PExp e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outAArrayInitializer(node);
    }

    public void inAArrayInitializer(AArrayInitializer node) throws AnalysisException {
        this.defaultInPInitializer(node);
    }

    public void outAArrayInitializer(AArrayInitializer node) throws AnalysisException {
        this.defaultOutPInitializer(node);
    }

    public void defaultInPParameter(PParameter node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPParameter(PParameter node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPParameter(PParameter node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPParameter(PParameter node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPParameter(PParameter node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAFormalParameter(AFormalParameter node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAFormalParameter(node);
        if (node.getType() != null && !this._visitedNodes.contains(node.getType())) {
            node.getType().apply(this);
        }
        this.outAFormalParameter(node);
    }

    public void inAFormalParameter(AFormalParameter node) throws AnalysisException {
        this.defaultInPParameter(node);
    }

    public void outAFormalParameter(AFormalParameter node) throws AnalysisException {
        this.defaultOutPParameter(node);
    }

    public void defaultInPExp(PExp node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPExp(PExp node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPExp(PExp node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPExp(PExp node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPExp(PExp node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAIdentifierExp(AIdentifierExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAIdentifierExp(node);
        this.outAIdentifierExp(node);
    }

    public void inAIdentifierExp(AIdentifierExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outAIdentifierExp(AIdentifierExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    public void defaultInSLiteralExp(SLiteralExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void defaultOutSLiteralExp(SLiteralExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void defaultSLiteralExp(SLiteralExp node) throws AnalysisException {
        this.defaultPExp(node);
    }

    public void inSLiteralExp(SLiteralExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outSLiteralExp(SLiteralExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseALoadExp(ALoadExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inALoadExp(node);
        ArrayList<PExp> copy = new ArrayList<PExp>(node.getArgs());
        for (PExp e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outALoadExp(node);
    }

    public void inALoadExp(ALoadExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outALoadExp(ALoadExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseAUnloadExp(AUnloadExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAUnloadExp(node);
        ArrayList<PExp> copy = new ArrayList<PExp>(node.getArgs());
        for (PExp e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outAUnloadExp(node);
    }

    public void inAUnloadExp(AUnloadExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outAUnloadExp(AUnloadExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    public void defaultInSBinaryExp(SBinaryExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void defaultOutSBinaryExp(SBinaryExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void defaultSBinaryExp(SBinaryExp node) throws AnalysisException {
        this.defaultPExp(node);
    }

    public void inSBinaryExp(SBinaryExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outSBinaryExp(SBinaryExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    public void defaultInSUnaryExp(SUnaryExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void defaultOutSUnaryExp(SUnaryExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void defaultSUnaryExp(SUnaryExp node) throws AnalysisException {
        this.defaultPExp(node);
    }

    public void inSUnaryExp(SUnaryExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outSUnaryExp(SUnaryExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseAFieldExp(AFieldExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAFieldExp(node);
        if (node.getRoot() != null && !this._visitedNodes.contains(node.getRoot())) {
            node.getRoot().apply(this);
        }
        this.outAFieldExp(node);
    }

    public void inAFieldExp(AFieldExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outAFieldExp(AFieldExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseACallExp(ACallExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inACallExp(node);
        if (node.getObject() != null && !this._visitedNodes.contains(node.getObject())) {
            node.getObject().apply(this);
        }
        if (node.getExpand() != null) {
            node.getExpand().apply(this);
        }
        ArrayList<PExp> copy = new ArrayList<PExp>(node.getArgs());
        for (PExp e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outACallExp(node);
    }

    public void inACallExp(ACallExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outACallExp(ACallExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseAArrayIndexExp(AArrayIndexExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAArrayIndexExp(node);
        if (node.getArray() != null && !this._visitedNodes.contains(node.getArray())) {
            node.getArray().apply(this);
        }
        ArrayList<PExp> copy = new ArrayList<PExp>(node.getIndices());
        for (PExp e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outAArrayIndexExp(node);
    }

    public void inAArrayIndexExp(AArrayIndexExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outAArrayIndexExp(AArrayIndexExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseAParExp(AParExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAParExp(node);
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAParExp(node);
    }

    public void inAParExp(AParExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outAParExp(AParExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseANullExp(ANullExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inANullExp(node);
        if (node.getToken() != null) {
            node.getToken().apply(this);
        }
        this.outANullExp(node);
    }

    public void inANullExp(ANullExp node) throws AnalysisException {
        this.defaultInPExp(node);
    }

    public void outANullExp(ANullExp node) throws AnalysisException {
        this.defaultOutPExp(node);
    }

    @Override
    public void caseAStringLiteralExp(AStringLiteralExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAStringLiteralExp(node);
        this.outAStringLiteralExp(node);
    }

    public void inAStringLiteralExp(AStringLiteralExp node) throws AnalysisException {
        this.defaultInSLiteralExp(node);
    }

    public void outAStringLiteralExp(AStringLiteralExp node) throws AnalysisException {
        this.defaultOutSLiteralExp(node);
    }

    @Override
    public void caseABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inABoolLiteralExp(node);
        this.outABoolLiteralExp(node);
    }

    public void inABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException {
        this.defaultInSLiteralExp(node);
    }

    public void outABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException {
        this.defaultOutSLiteralExp(node);
    }

    @Override
    public void caseAIntLiteralExp(AIntLiteralExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAIntLiteralExp(node);
        this.outAIntLiteralExp(node);
    }

    public void inAIntLiteralExp(AIntLiteralExp node) throws AnalysisException {
        this.defaultInSLiteralExp(node);
    }

    public void outAIntLiteralExp(AIntLiteralExp node) throws AnalysisException {
        this.defaultOutSLiteralExp(node);
    }

    @Override
    public void caseAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAUIntLiteralExp(node);
        this.outAUIntLiteralExp(node);
    }

    public void inAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException {
        this.defaultInSLiteralExp(node);
    }

    public void outAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException {
        this.defaultOutSLiteralExp(node);
    }

    @Override
    public void caseARealLiteralExp(ARealLiteralExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inARealLiteralExp(node);
        this.outARealLiteralExp(node);
    }

    public void inARealLiteralExp(ARealLiteralExp node) throws AnalysisException {
        this.defaultInSLiteralExp(node);
    }

    public void outARealLiteralExp(ARealLiteralExp node) throws AnalysisException {
        this.defaultOutSLiteralExp(node);
    }

    @Override
    public void caseAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAPlusBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAPlusBinaryExp(node);
    }

    public void inAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAMinusBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAMinusBinaryExp(node);
    }

    public void inAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inALessEqualBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outALessEqualBinaryExp(node);
    }

    public void inALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAGreaterEqualBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAGreaterEqualBinaryExp(node);
    }

    public void inAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseALessBinaryExp(ALessBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inALessBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outALessBinaryExp(node);
    }

    public void inALessBinaryExp(ALessBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outALessBinaryExp(ALessBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAGreaterBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAGreaterBinaryExp(node);
    }

    public void inAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAEqualBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAEqualBinaryExp(node);
    }

    public void inAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inANotEqualBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outANotEqualBinaryExp(node);
    }

    public void inANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAOrBinaryExp(AOrBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAOrBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAOrBinaryExp(node);
    }

    public void inAOrBinaryExp(AOrBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAOrBinaryExp(AOrBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAAndBinaryExp(AAndBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAAndBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAAndBinaryExp(node);
    }

    public void inAAndBinaryExp(AAndBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAAndBinaryExp(AAndBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inADivideBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outADivideBinaryExp(node);
    }

    public void inADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAMultiplyBinaryExp(node);
        if (node.getLeft() != null && !this._visitedNodes.contains(node.getLeft())) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null && !this._visitedNodes.contains(node.getRight())) {
            node.getRight().apply(this);
        }
        this.outAMultiplyBinaryExp(node);
    }

    public void inAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException {
        this.defaultInSBinaryExp(node);
    }

    public void outAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException {
        this.defaultOutSBinaryExp(node);
    }

    @Override
    public void caseANotUnaryExp(ANotUnaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inANotUnaryExp(node);
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outANotUnaryExp(node);
    }

    public void inANotUnaryExp(ANotUnaryExp node) throws AnalysisException {
        this.defaultInSUnaryExp(node);
    }

    public void outANotUnaryExp(ANotUnaryExp node) throws AnalysisException {
        this.defaultOutSUnaryExp(node);
    }

    @Override
    public void caseAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAMinusUnaryExp(node);
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAMinusUnaryExp(node);
    }

    public void inAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException {
        this.defaultInSUnaryExp(node);
    }

    public void outAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException {
        this.defaultOutSUnaryExp(node);
    }

    @Override
    public void caseAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAPlusUnaryExp(node);
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAPlusUnaryExp(node);
    }

    public void inAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException {
        this.defaultInSUnaryExp(node);
    }

    public void outAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException {
        this.defaultOutSUnaryExp(node);
    }

    public void defaultInPStateDesignator(PStateDesignator node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPStateDesignator(PStateDesignator node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPStateDesignator(PStateDesignator node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPStateDesignator(PStateDesignator node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPStateDesignator(PStateDesignator node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAIdentifierStateDesignator(node);
        this.outAIdentifierStateDesignator(node);
    }

    public void inAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException {
        this.defaultInPStateDesignator(node);
    }

    public void outAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException {
        this.defaultOutPStateDesignator(node);
    }

    @Override
    public void caseAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAArrayStateDesignator(node);
        if (node.getTarget() != null && !this._visitedNodes.contains(node.getTarget())) {
            node.getTarget().apply(this);
        }
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAArrayStateDesignator(node);
    }

    public void inAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException {
        this.defaultInPStateDesignator(node);
    }

    public void outAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException {
        this.defaultOutPStateDesignator(node);
    }

    public void defaultInPStm(PStm node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPStm(PStm node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPStm(PStm node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPStm(PStm node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPStm(PStm node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void caseABlockStm(ABlockStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inABlockStm(node);
        ArrayList<PStm> copy = new ArrayList<PStm>(node.getBody());
        for (PStm e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outABlockStm(node);
    }

    public void inABlockStm(ABlockStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outABlockStm(ABlockStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAAssigmentStm(AAssigmentStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAAssigmentStm(node);
        if (node.getTarget() != null && !this._visitedNodes.contains(node.getTarget())) {
            node.getTarget().apply(this);
        }
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAAssigmentStm(node);
    }

    public void inAAssigmentStm(AAssigmentStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAAssigmentStm(AAssigmentStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseALocalVariableStm(ALocalVariableStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inALocalVariableStm(node);
        if (node.getDeclaration() != null && !this._visitedNodes.contains(node.getDeclaration())) {
            node.getDeclaration().apply(this);
        }
        this.outALocalVariableStm(node);
    }

    public void inALocalVariableStm(ALocalVariableStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outALocalVariableStm(ALocalVariableStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAIfStm(AIfStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAIfStm(node);
        if (node.getTest() != null && !this._visitedNodes.contains(node.getTest())) {
            node.getTest().apply(this);
        }
        if (node.getThen() != null && !this._visitedNodes.contains(node.getThen())) {
            node.getThen().apply(this);
        }
        if (node.getElse() != null && !this._visitedNodes.contains(node.getElse())) {
            node.getElse().apply(this);
        }
        this.outAIfStm(node);
    }

    public void inAIfStm(AIfStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAIfStm(AIfStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAWhileStm(AWhileStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAWhileStm(node);
        if (node.getTest() != null && !this._visitedNodes.contains(node.getTest())) {
            node.getTest().apply(this);
        }
        if (node.getBody() != null && !this._visitedNodes.contains(node.getBody())) {
            node.getBody().apply(this);
        }
        this.outAWhileStm(node);
    }

    public void inAWhileStm(AWhileStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAWhileStm(AWhileStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAExpressionStm(AExpressionStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAExpressionStm(node);
        if (node.getExp() != null && !this._visitedNodes.contains(node.getExp())) {
            node.getExp().apply(this);
        }
        this.outAExpressionStm(node);
    }

    public void inAExpressionStm(AExpressionStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAExpressionStm(AExpressionStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAObservableStm(AObservableStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAObservableStm(node);
        if (node.getIdentifier() != null && !this._visitedNodes.contains(node.getIdentifier())) {
            node.getIdentifier().apply(this);
        }
        this.outAObservableStm(node);
    }

    public void inAObservableStm(AObservableStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAObservableStm(AObservableStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseABreakStm(ABreakStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inABreakStm(node);
        if (node.getToken() != null) {
            node.getToken().apply(this);
        }
        this.outABreakStm(node);
    }

    public void inABreakStm(ABreakStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outABreakStm(ABreakStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAInstanceMappingStm(node);
        this.outAInstanceMappingStm(node);
    }

    public void inAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    @Override
    public void caseAConfigStm(AConfigStm node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAConfigStm(node);
        this.outAConfigStm(node);
    }

    public void inAConfigStm(AConfigStm node) throws AnalysisException {
        this.defaultInPStm(node);
    }

    public void outAConfigStm(AConfigStm node) throws AnalysisException {
        this.defaultOutPStm(node);
    }

    public void defaultInPType(PType node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void defaultOutPType(PType node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    @Override
    public void defaultPType(PType node) throws AnalysisException {
        this.defaultINode(node);
    }

    public void inPType(PType node) throws AnalysisException {
        this.defaultInINode(node);
    }

    public void outPType(PType node) throws AnalysisException {
        this.defaultOutINode(node);
    }

    public void defaultInSPrimitiveType(SPrimitiveType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void defaultOutSPrimitiveType(SPrimitiveType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void defaultSPrimitiveType(SPrimitiveType node) throws AnalysisException {
        this.defaultPType(node);
    }

    public void inSPrimitiveType(SPrimitiveType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outSPrimitiveType(SPrimitiveType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseANameType(ANameType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inANameType(node);
        this.outANameType(node);
    }

    public void inANameType(ANameType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outANameType(ANameType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseAFunctionType(AFunctionType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAFunctionType(node);
        if (node.getResult() != null && !this._visitedNodes.contains(node.getResult())) {
            node.getResult().apply(this);
        }
        ArrayList<PType> copy = new ArrayList<PType>(node.getParameters());
        for (PType e : copy) {
            if (this._visitedNodes.contains(e)) continue;
            e.apply(this);
        }
        this.outAFunctionType(node);
    }

    public void inAFunctionType(AFunctionType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outAFunctionType(AFunctionType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseAArrayType(AArrayType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAArrayType(node);
        if (node.getType() != null && !this._visitedNodes.contains(node.getType())) {
            node.getType().apply(this);
        }
        this.outAArrayType(node);
    }

    public void inAArrayType(AArrayType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outAArrayType(AArrayType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseAUnknownType(AUnknownType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAUnknownType(node);
        this.outAUnknownType(node);
    }

    public void inAUnknownType(AUnknownType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outAUnknownType(AUnknownType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseAVoidType(AVoidType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAVoidType(node);
        this.outAVoidType(node);
    }

    public void inAVoidType(AVoidType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outAVoidType(AVoidType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseAModuleType(AModuleType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAModuleType(node);
        if (node.getName() != null && !this._visitedNodes.contains(node.getName())) {
            node.getName().apply(this);
        }
        this.outAModuleType(node);
    }

    public void inAModuleType(AModuleType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outAModuleType(AModuleType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseAReferenceType(AReferenceType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAReferenceType(node);
        if (node.getType() != null && !this._visitedNodes.contains(node.getType())) {
            node.getType().apply(this);
        }
        this.outAReferenceType(node);
    }

    public void inAReferenceType(AReferenceType node) throws AnalysisException {
        this.defaultInPType(node);
    }

    public void outAReferenceType(AReferenceType node) throws AnalysisException {
        this.defaultOutPType(node);
    }

    @Override
    public void caseABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inABooleanPrimitiveType(node);
        this.outABooleanPrimitiveType(node);
    }

    public void inABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException {
        this.defaultInSPrimitiveType(node);
    }

    public void outABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException {
        this.defaultOutSPrimitiveType(node);
    }

    @Override
    public void caseAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAStringPrimitiveType(node);
        this.outAStringPrimitiveType(node);
    }

    public void inAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException {
        this.defaultInSPrimitiveType(node);
    }

    public void outAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException {
        this.defaultOutSPrimitiveType(node);
    }

    public void defaultInSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException {
        this.defaultInSPrimitiveType(node);
    }

    public void defaultOutSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException {
        this.defaultOutSPrimitiveType(node);
    }

    @Override
    public void defaultSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException {
        this.defaultSPrimitiveType(node);
    }

    public void inSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException {
        this.defaultInSPrimitiveType(node);
    }

    public void outSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException {
        this.defaultOutSPrimitiveType(node);
    }

    @Override
    public void caseARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inARealNumericPrimitiveType(node);
        this.outARealNumericPrimitiveType(node);
    }

    public void inARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException {
        this.defaultInSNumericPrimitiveType(node);
    }

    public void outARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException {
        this.defaultOutSNumericPrimitiveType(node);
    }

    @Override
    public void caseAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAIntNumericPrimitiveType(node);
        this.outAIntNumericPrimitiveType(node);
    }

    public void inAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException {
        this.defaultInSNumericPrimitiveType(node);
    }

    public void outAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException {
        this.defaultOutSNumericPrimitiveType(node);
    }

    @Override
    public void caseAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException {
        this._visitedNodes.add(node);
        this.inAUIntNumericPrimitiveType(node);
        this.outAUIntNumericPrimitiveType(node);
    }

    public void inAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException {
        this.defaultInSNumericPrimitiveType(node);
    }

    public void outAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException {
        this.defaultOutSNumericPrimitiveType(node);
    }

    public void defaultOutINode(INode node) throws AnalysisException {
    }

    public void defaultInINode(INode node) throws AnalysisException {
    }

    @Override
    public void defaultINode(INode node) throws AnalysisException {
    }

    public void defaultOutIToken(IToken node) throws AnalysisException {
    }

    public void defaultInIToken(IToken node) throws AnalysisException {
    }

    @Override
    public void defaultIToken(IToken node) throws AnalysisException {
    }
}

