/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.GraphNodeList;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.PTypeBase;

public class AFunctionType
extends PTypeBase {
    private static final long serialVersionUID = 1L;
    private PType _result;
    private GraphNodeList<PType> _parameters = new GraphNodeList(this);

    public AFunctionType(PType result_, List<? extends PType> parameters_) {
        this.setResult(result_);
        this.setParameters(parameters_);
    }

    public AFunctionType() {
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_result", this._result);
        fields.put("_parameters", this._parameters);
        return fields;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public AFunctionType clone(Map<INode, INode> oldToNewMap) {
        AFunctionType node = new AFunctionType(this._result, this._parameters);
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public void removeChild(INode child) {
        if (this._result == child) {
            return;
        }
        if (this._parameters.contains(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public String toString() {
        return (this._result != null ? this._result.toString() : this.getClass().getSimpleName()) + (this._parameters != null ? this._parameters.toString() : this.getClass().getSimpleName());
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof AFunctionType) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public AFunctionType clone() {
        return new AFunctionType(this._result, this._parameters);
    }

    public void setResult(PType value) {
        if (value != null && value.parent() == null) {
            value.parent(this);
        }
        this._result = value;
    }

    public PType getResult() {
        return this._result;
    }

    public void setParameters(List<? extends PType> value) {
        if (this._parameters.equals(value)) {
            return;
        }
        this._parameters.clear();
        if (value != null) {
            this._parameters.addAll(value);
        }
    }

    public LinkedList<PType> getParameters() {
        return this._parameters;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseAFunctionType(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseAFunctionType(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseAFunctionType(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseAFunctionType(this, question);
    }
}

