/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.lang.Integer;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.SLiteralExpBase;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AIntLiteralExp extends SLiteralExpBase
{
	private static final long serialVersionUID = 1L;

	private Integer _value;


	/**
	 * Creates a new default constructor {@link AIntLiteralExp} node with no children.
	 */
	public AIntLiteralExp()
	{

	}


	/**
	* Creates a new complete constructor {@code AIntLiteralExp} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param value_ the {@link Integer} node for the {@code value} child of this {@link AIntLiteralExp} node
	*/
	public AIntLiteralExp(Integer value_)
	{
		super();
		this.setValue(value_);

	}



	public String toString()
	{
		return (_value!=null?_value.toString():this.getClass().getSimpleName());
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_value",this._value);
		return fields;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AIntLiteralExp)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Returns a deep clone of this {@link AIntLiteralExp} node.
	 * @return a deep clone of this {@link AIntLiteralExp} node
	 */
	public AIntLiteralExp clone()
	{
		return new AIntLiteralExp(
			_value
		);
	}


	/**
	 * Creates a deep clone of this {@link AIntLiteralExp} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AIntLiteralExp} node
	 */
	public AIntLiteralExp clone(Map<INode,INode> oldToNewMap)
	{
		AIntLiteralExp node = new AIntLiteralExp(
			_value
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AIntLiteralExp} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AIntLiteralExp} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AIntLiteralExp} node
	 */
	public void removeChild(INode child)
	{
		throw new RuntimeException("Not a child.");
	}


	/**
	 * Sets the {@code _value} child of this {@link AIntLiteralExp} node.
	 * @param value the new {@code _value} child of this {@link AIntLiteralExp} node
	*/
	public void setValue(Integer value)
	{
		this._value = value;
	}


	/**
	 * @return the {@link Integer} node which is the {@code _value} child of this {@link AIntLiteralExp} node
	*/
	public Integer getValue()
	{
		return this._value;
	}


	/**
	* Calls the {@link IAnalysis#caseAIntLiteralExp(AIntLiteralExp)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AIntLiteralExp} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAIntLiteralExp(this);
	}


	/**
	* Calls the {@link IAnswer#caseAIntLiteralExp(AIntLiteralExp)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AIntLiteralExp} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAIntLiteralExp(this);
	}


	/**
	* Calls the {@link IQuestion#caseAIntLiteralExp(AIntLiteralExp, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AIntLiteralExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAIntLiteralExp(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAIntLiteralExp(AIntLiteralExp, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AIntLiteralExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAIntLiteralExp(this,question);
	}



}
