/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.analysis;


import org.intocps.maestro.ast.node.AModuleType;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.lang.Integer;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.node.PParameter;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.node.AParExp;
import java.lang.Long;
import org.intocps.maestro.ast.node.PDocument;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.SUnaryExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AFunctionType;
import java.util.Set;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.node.SNumericPrimitiveType;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.LexIdentifier;
import java.lang.Double;
import org.intocps.maestro.ast.node.AUnknownType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AObservableStm;
import java.util.ArrayList;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.PDeclaration;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.SLiteralExp;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.ANullType;
import org.intocps.maestro.ast.node.PStm;
import java.lang.Boolean;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.ABlockStm;
import java.lang.String;
import org.intocps.maestro.ast.node.IToken;
import java.util.LinkedList;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.SBinaryExp;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.node.SPrimitiveType;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.PFramework;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.AVoidType;
import org.intocps.maestro.ast.node.ARootDocument;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public abstract class DepthFirstAnalysisAdaptorAnswer<A> implements IAnswer<A>
{
	private static final long serialVersionUID = 1L;

	protected Set<INode> _visitedNodes = new java.util.HashSet<INode>();
	final protected IAnswer<A> THIS;

	/**
	* Creates a new complete constructor {@code DepthFirstAnalysisAdaptorAnswer} node with the given nodes as children.
	* The basic child nodes are removed from their previous parents.
	* @param visitedNodes_ the {@link Set} node for the {@code visitedNodes} child of this {@link DepthFirstAnalysisAdaptorAnswer} node
	* @param THIS_ the {@link IAnswer} <b>graph</a> node for the {@code THIS} child of this {@link DepthFirstAnalysisAdaptorAnswer} node.
	*  <i>The parent of this {@code THIS } will not be changed by adding it to this node.</i>
	*/
	public DepthFirstAnalysisAdaptorAnswer(Set<INode> visitedNodes_, IAnswer<A> THIS_)
	{
		super();
		this.setVisitedNodes(visitedNodes_);
		this.THIS = THIS_;

	}


	/**
	 * Creates a new default constructor {@link DepthFirstAnalysisAdaptorAnswer} node with no children.
	 */
	public DepthFirstAnalysisAdaptorAnswer()
	{
		this.THIS=this;

	}


	/**
	 * Sets the {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptorAnswer} node.
	 * @param value the new {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptorAnswer} node
	*/
	public void setVisitedNodes(Set<INode> value)
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseString(String node) throws AnalysisException
	{
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inString(node));


		mergeReturns(retVal,outString(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inString(String node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outString(String node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseBoolean(Boolean node) throws AnalysisException
	{
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inBoolean(node));


		mergeReturns(retVal,outBoolean(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inBoolean(Boolean node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outBoolean(Boolean node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseInteger(Integer node) throws AnalysisException
	{
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inInteger(node));


		mergeReturns(retVal,outInteger(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inInteger(Integer node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outInteger(Integer node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseDouble(Double node) throws AnalysisException
	{
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inDouble(node));


		mergeReturns(retVal,outDouble(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inDouble(Double node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outDouble(Double node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseLong(Long node) throws AnalysisException
	{
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inLong(node));


		mergeReturns(retVal,outLong(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inLong(Long node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outLong(Long node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseLexIdentifier(LexIdentifier node) throws AnalysisException
	{
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inLexIdentifier(node));


		mergeReturns(retVal,outLexIdentifier(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inLexIdentifier(LexIdentifier node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outLexIdentifier(LexIdentifier node) throws AnalysisException
	{
		return null;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A caseLexToken(LexToken node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inLexToken(node));


		mergeReturns(retVal,outLexToken(node));
		return retVal;
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A inLexToken(LexToken node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A outLexToken(LexToken node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A defaultInPDocument(PDocument node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A defaultOutPDocument(PDocument node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A defaultPDocument(PDocument node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A inPDocument(PDocument node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public A outPDocument(PDocument node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public A caseARootDocument(ARootDocument node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inARootDocument(node));

		{
			List<PCompilationUnit> copy = new ArrayList<PCompilationUnit>(node.getContent());
			for( PCompilationUnit e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outARootDocument(node));
		return retVal;
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public A inARootDocument(ARootDocument node) throws AnalysisException
	{
		return defaultInPDocument(node);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public A outARootDocument(ARootDocument node) throws AnalysisException
	{
		return defaultOutPDocument(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A defaultInPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A defaultOutPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A defaultPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A inPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public A outPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public A caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAImportedModuleCompilationUnit(node));

		if(node.getModule() != null && !_visitedNodes.contains(node.getModule())) 
		{
			mergeReturns(retVal,node.getModule().apply(this));
		}

		mergeReturns(retVal,outAImportedModuleCompilationUnit(node));
		return retVal;
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public A inAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException
	{
		return defaultInPCompilationUnit(node);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public A outAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException
	{
		return defaultOutPCompilationUnit(node);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public A caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inASimulationSpecificationCompilationUnit(node));

		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			mergeReturns(retVal,node.getBody().apply(this));
		}
		{
			List<AConfigFramework> copy = new ArrayList<AConfigFramework>(node.getFrameworkConfigs());
			for( AConfigFramework e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outASimulationSpecificationCompilationUnit(node));
		return retVal;
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public A inASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException
	{
		return defaultInPCompilationUnit(node);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public A outASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException
	{
		return defaultOutPCompilationUnit(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A defaultInPFramework(PFramework node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A defaultOutPFramework(PFramework node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A defaultPFramework(PFramework node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A inPFramework(PFramework node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public A outPFramework(PFramework node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public A caseAConfigFramework(AConfigFramework node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAConfigFramework(node));


		mergeReturns(retVal,outAConfigFramework(node));
		return retVal;
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public A inAConfigFramework(AConfigFramework node) throws AnalysisException
	{
		return defaultInPFramework(node);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public A outAConfigFramework(AConfigFramework node) throws AnalysisException
	{
		return defaultOutPFramework(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A defaultInPDeclaration(PDeclaration node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A defaultOutPDeclaration(PDeclaration node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A defaultPDeclaration(PDeclaration node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A inPDeclaration(PDeclaration node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public A outPDeclaration(PDeclaration node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public A caseAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAFunctionDeclaration(node));

		if(node.getReturnType() != null && !_visitedNodes.contains(node.getReturnType())) 
		{
			mergeReturns(retVal,node.getReturnType().apply(this));
		}
		{
			List<AFormalParameter> copy = new ArrayList<AFormalParameter>(node.getFormals());
			for( AFormalParameter e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outAFunctionDeclaration(node));
		return retVal;
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public A inAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException
	{
		return defaultInPDeclaration(node);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public A outAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException
	{
		return defaultOutPDeclaration(node);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public A caseAVariableDeclaration(AVariableDeclaration node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAVariableDeclaration(node));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this));
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getSize());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}
		if(node.getInitializer() != null && !_visitedNodes.contains(node.getInitializer())) 
		{
			mergeReturns(retVal,node.getInitializer().apply(this));
		}

		mergeReturns(retVal,outAVariableDeclaration(node));
		return retVal;
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public A inAVariableDeclaration(AVariableDeclaration node) throws AnalysisException
	{
		return defaultInPDeclaration(node);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public A outAVariableDeclaration(AVariableDeclaration node) throws AnalysisException
	{
		return defaultOutPDeclaration(node);
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public A caseAModuleDeclaration(AModuleDeclaration node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAModuleDeclaration(node));

		{
			List<AFunctionDeclaration> copy = new ArrayList<AFunctionDeclaration>(node.getFunctions());
			for( AFunctionDeclaration e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outAModuleDeclaration(node));
		return retVal;
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public A inAModuleDeclaration(AModuleDeclaration node) throws AnalysisException
	{
		return defaultInPDeclaration(node);
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public A outAModuleDeclaration(AModuleDeclaration node) throws AnalysisException
	{
		return defaultOutPDeclaration(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A defaultInPInitializer(PInitializer node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A defaultOutPInitializer(PInitializer node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A defaultPInitializer(PInitializer node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A inPInitializer(PInitializer node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public A outPInitializer(PInitializer node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public A caseAExpInitializer(AExpInitializer node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAExpInitializer(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAExpInitializer(node));
		return retVal;
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public A inAExpInitializer(AExpInitializer node) throws AnalysisException
	{
		return defaultInPInitializer(node);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public A outAExpInitializer(AExpInitializer node) throws AnalysisException
	{
		return defaultOutPInitializer(node);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public A caseAArrayInitializer(AArrayInitializer node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAArrayInitializer(node));

		{
			List<PExp> copy = new ArrayList<PExp>(node.getExp());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outAArrayInitializer(node));
		return retVal;
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public A inAArrayInitializer(AArrayInitializer node) throws AnalysisException
	{
		return defaultInPInitializer(node);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public A outAArrayInitializer(AArrayInitializer node) throws AnalysisException
	{
		return defaultOutPInitializer(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A defaultInPParameter(PParameter node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A defaultOutPParameter(PParameter node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A defaultPParameter(PParameter node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A inPParameter(PParameter node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public A outPParameter(PParameter node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public A caseAFormalParameter(AFormalParameter node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAFormalParameter(node));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this));
		}

		mergeReturns(retVal,outAFormalParameter(node));
		return retVal;
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public A inAFormalParameter(AFormalParameter node) throws AnalysisException
	{
		return defaultInPParameter(node);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public A outAFormalParameter(AFormalParameter node) throws AnalysisException
	{
		return defaultOutPParameter(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A defaultInPExp(PExp node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A defaultOutPExp(PExp node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A defaultPExp(PExp node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A inPExp(PExp node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public A outPExp(PExp node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public A caseAIdentifierExp(AIdentifierExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAIdentifierExp(node));


		mergeReturns(retVal,outAIdentifierExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public A inAIdentifierExp(AIdentifierExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public A outAIdentifierExp(AIdentifierExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A defaultInSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A defaultOutSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A defaultSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		return defaultPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A inSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public A outSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public A caseALoadExp(ALoadExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inALoadExp(node));

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outALoadExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public A inALoadExp(ALoadExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public A outALoadExp(ALoadExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public A caseAUnloadExp(AUnloadExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAUnloadExp(node));

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outAUnloadExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public A inAUnloadExp(AUnloadExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public A outAUnloadExp(AUnloadExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A defaultInSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A defaultOutSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A defaultSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		return defaultPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A inSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public A outSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A defaultInSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A defaultOutSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A defaultSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		return defaultPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A inSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public A outSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public A caseAFieldExp(AFieldExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAFieldExp(node));

		if(node.getRoot() != null && !_visitedNodes.contains(node.getRoot())) 
		{
			mergeReturns(retVal,node.getRoot().apply(this));
		}

		mergeReturns(retVal,outAFieldExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public A inAFieldExp(AFieldExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public A outAFieldExp(AFieldExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public A caseACallExp(ACallExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inACallExp(node));

		if(node.getObject() != null && !_visitedNodes.contains(node.getObject())) 
		{
			mergeReturns(retVal,node.getObject().apply(this));
		}
		if(node.getExpand() != null ) 
		{
			mergeReturns(retVal,node.getExpand().apply(this));
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outACallExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public A inACallExp(ACallExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public A outACallExp(ACallExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public A caseAArrayIndexExp(AArrayIndexExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAArrayIndexExp(node));

		if(node.getArray() != null && !_visitedNodes.contains(node.getArray())) 
		{
			mergeReturns(retVal,node.getArray().apply(this));
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getIndices());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outAArrayIndexExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public A inAArrayIndexExp(AArrayIndexExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public A outAArrayIndexExp(AArrayIndexExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public A caseAParExp(AParExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAParExp(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAParExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public A inAParExp(AParExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public A outAParExp(AParExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public A caseANullExp(ANullExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inANullExp(node));

		if(node.getToken() != null ) 
		{
			mergeReturns(retVal,node.getToken().apply(this));
		}

		mergeReturns(retVal,outANullExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public A inANullExp(ANullExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public A outANullExp(ANullExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public A caseARefExp(ARefExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inARefExp(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outARefExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public A inARefExp(ARefExp node) throws AnalysisException
	{
		return defaultInPExp(node);
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public A outARefExp(ARefExp node) throws AnalysisException
	{
		return defaultOutPExp(node);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public A caseAStringLiteralExp(AStringLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAStringLiteralExp(node));


		mergeReturns(retVal,outAStringLiteralExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public A inAStringLiteralExp(AStringLiteralExp node) throws AnalysisException
	{
		return defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public A outAStringLiteralExp(AStringLiteralExp node) throws AnalysisException
	{
		return defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public A caseABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inABoolLiteralExp(node));


		mergeReturns(retVal,outABoolLiteralExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public A inABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException
	{
		return defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public A outABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException
	{
		return defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public A caseAIntLiteralExp(AIntLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAIntLiteralExp(node));


		mergeReturns(retVal,outAIntLiteralExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public A inAIntLiteralExp(AIntLiteralExp node) throws AnalysisException
	{
		return defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public A outAIntLiteralExp(AIntLiteralExp node) throws AnalysisException
	{
		return defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public A caseAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAUIntLiteralExp(node));


		mergeReturns(retVal,outAUIntLiteralExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public A inAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException
	{
		return defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public A outAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException
	{
		return defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public A caseARealLiteralExp(ARealLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inARealLiteralExp(node));


		mergeReturns(retVal,outARealLiteralExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public A inARealLiteralExp(ARealLiteralExp node) throws AnalysisException
	{
		return defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public A outARealLiteralExp(ARealLiteralExp node) throws AnalysisException
	{
		return defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public A caseAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAPlusBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAPlusBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public A inAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public A outAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public A caseAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAMinusBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAMinusBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public A inAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public A outAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public A caseALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inALessEqualBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outALessEqualBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public A inALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public A outALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public A caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAGreaterEqualBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAGreaterEqualBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public A inAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public A outAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public A caseALessBinaryExp(ALessBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inALessBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outALessBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public A inALessBinaryExp(ALessBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public A outALessBinaryExp(ALessBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public A caseAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAGreaterBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAGreaterBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public A inAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public A outAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public A caseAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAEqualBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAEqualBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public A inAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public A outAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public A caseANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inANotEqualBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outANotEqualBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public A inANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public A outANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public A caseAOrBinaryExp(AOrBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAOrBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAOrBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public A inAOrBinaryExp(AOrBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public A outAOrBinaryExp(AOrBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public A caseAAndBinaryExp(AAndBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAAndBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAAndBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public A inAAndBinaryExp(AAndBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public A outAAndBinaryExp(AAndBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public A caseADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inADivideBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outADivideBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public A inADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public A outADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public A caseAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAMultiplyBinaryExp(node));

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			mergeReturns(retVal,node.getLeft().apply(this));
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			mergeReturns(retVal,node.getRight().apply(this));
		}

		mergeReturns(retVal,outAMultiplyBinaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public A inAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException
	{
		return defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public A outAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException
	{
		return defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public A caseANotUnaryExp(ANotUnaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inANotUnaryExp(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outANotUnaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public A inANotUnaryExp(ANotUnaryExp node) throws AnalysisException
	{
		return defaultInSUnaryExp(node);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public A outANotUnaryExp(ANotUnaryExp node) throws AnalysisException
	{
		return defaultOutSUnaryExp(node);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public A caseAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAMinusUnaryExp(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAMinusUnaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public A inAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException
	{
		return defaultInSUnaryExp(node);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public A outAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException
	{
		return defaultOutSUnaryExp(node);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public A caseAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAPlusUnaryExp(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAPlusUnaryExp(node));
		return retVal;
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public A inAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException
	{
		return defaultInSUnaryExp(node);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public A outAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException
	{
		return defaultOutSUnaryExp(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A defaultInPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A defaultOutPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A defaultPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A inPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public A outPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public A caseAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAIdentifierStateDesignator(node));


		mergeReturns(retVal,outAIdentifierStateDesignator(node));
		return retVal;
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public A inAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException
	{
		return defaultInPStateDesignator(node);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public A outAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException
	{
		return defaultOutPStateDesignator(node);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public A caseAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAArrayStateDesignator(node));

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			mergeReturns(retVal,node.getTarget().apply(this));
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAArrayStateDesignator(node));
		return retVal;
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public A inAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException
	{
		return defaultInPStateDesignator(node);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public A outAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException
	{
		return defaultOutPStateDesignator(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A defaultInPStm(PStm node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A defaultOutPStm(PStm node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A defaultPStm(PStm node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A inPStm(PStm node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public A outPStm(PStm node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link ABlockStm} node from {@link ABlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABlockStm} node
	*/
	public A caseABlockStm(ABlockStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inABlockStm(node));

		{
			List<PStm> copy = new ArrayList<PStm>(node.getBody());
			for( PStm e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outABlockStm(node));
		return retVal;
	}


	/**
	* Called by the {@link ABlockStm} node from {@link ABlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABlockStm} node
	*/
	public A inABlockStm(ABlockStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link ABlockStm} node from {@link ABlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABlockStm} node
	*/
	public A outABlockStm(ABlockStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public A caseAAssigmentStm(AAssigmentStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAAssigmentStm(node));

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			mergeReturns(retVal,node.getTarget().apply(this));
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAAssigmentStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public A inAAssigmentStm(AAssigmentStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public A outAAssigmentStm(AAssigmentStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public A caseALocalVariableStm(ALocalVariableStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inALocalVariableStm(node));

		if(node.getDeclaration() != null && !_visitedNodes.contains(node.getDeclaration())) 
		{
			mergeReturns(retVal,node.getDeclaration().apply(this));
		}

		mergeReturns(retVal,outALocalVariableStm(node));
		return retVal;
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public A inALocalVariableStm(ALocalVariableStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public A outALocalVariableStm(ALocalVariableStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public A caseAIfStm(AIfStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAIfStm(node));

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			mergeReturns(retVal,node.getTest().apply(this));
		}
		if(node.getThen() != null && !_visitedNodes.contains(node.getThen())) 
		{
			mergeReturns(retVal,node.getThen().apply(this));
		}
		if(node.getElse() != null && !_visitedNodes.contains(node.getElse())) 
		{
			mergeReturns(retVal,node.getElse().apply(this));
		}

		mergeReturns(retVal,outAIfStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public A inAIfStm(AIfStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public A outAIfStm(AIfStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public A caseAWhileStm(AWhileStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAWhileStm(node));

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			mergeReturns(retVal,node.getTest().apply(this));
		}
		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			mergeReturns(retVal,node.getBody().apply(this));
		}

		mergeReturns(retVal,outAWhileStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public A inAWhileStm(AWhileStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public A outAWhileStm(AWhileStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public A caseAExpressionStm(AExpressionStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAExpressionStm(node));

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			mergeReturns(retVal,node.getExp().apply(this));
		}

		mergeReturns(retVal,outAExpressionStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public A inAExpressionStm(AExpressionStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public A outAExpressionStm(AExpressionStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public A caseAObservableStm(AObservableStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAObservableStm(node));

		if(node.getIdentifier() != null && !_visitedNodes.contains(node.getIdentifier())) 
		{
			mergeReturns(retVal,node.getIdentifier().apply(this));
		}

		mergeReturns(retVal,outAObservableStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public A inAObservableStm(AObservableStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public A outAObservableStm(AObservableStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public A caseABreakStm(ABreakStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inABreakStm(node));

		if(node.getToken() != null ) 
		{
			mergeReturns(retVal,node.getToken().apply(this));
		}

		mergeReturns(retVal,outABreakStm(node));
		return retVal;
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public A inABreakStm(ABreakStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public A outABreakStm(ABreakStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public A caseAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAInstanceMappingStm(node));


		mergeReturns(retVal,outAInstanceMappingStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public A inAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public A outAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public A caseAConfigStm(AConfigStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAConfigStm(node));


		mergeReturns(retVal,outAConfigStm(node));
		return retVal;
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public A inAConfigStm(AConfigStm node) throws AnalysisException
	{
		return defaultInPStm(node);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public A outAConfigStm(AConfigStm node) throws AnalysisException
	{
		return defaultOutPStm(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A defaultInPType(PType node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A defaultOutPType(PType node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A defaultPType(PType node) throws AnalysisException
	{
		return defaultINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A inPType(PType node) throws AnalysisException
	{
		return defaultInINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public A outPType(PType node) throws AnalysisException
	{
		return defaultOutINode(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A defaultInSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A defaultOutSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A defaultSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		return defaultPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A inSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public A outSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public A caseANameType(ANameType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inANameType(node));


		mergeReturns(retVal,outANameType(node));
		return retVal;
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public A inANameType(ANameType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public A outANameType(ANameType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public A caseAFunctionType(AFunctionType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAFunctionType(node));

		if(node.getResult() != null && !_visitedNodes.contains(node.getResult())) 
		{
			mergeReturns(retVal,node.getResult().apply(this));
		}
		{
			List<PType> copy = new ArrayList<PType>(node.getParameters());
			for( PType e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					mergeReturns(retVal,e.apply(this));
				}
			}
		}

		mergeReturns(retVal,outAFunctionType(node));
		return retVal;
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public A inAFunctionType(AFunctionType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public A outAFunctionType(AFunctionType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public A caseAArrayType(AArrayType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAArrayType(node));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this));
		}

		mergeReturns(retVal,outAArrayType(node));
		return retVal;
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public A inAArrayType(AArrayType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public A outAArrayType(AArrayType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public A caseAUnknownType(AUnknownType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAUnknownType(node));


		mergeReturns(retVal,outAUnknownType(node));
		return retVal;
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public A inAUnknownType(AUnknownType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public A outAUnknownType(AUnknownType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public A caseAVoidType(AVoidType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAVoidType(node));


		mergeReturns(retVal,outAVoidType(node));
		return retVal;
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public A inAVoidType(AVoidType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public A outAVoidType(AVoidType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public A caseAModuleType(AModuleType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAModuleType(node));


		mergeReturns(retVal,outAModuleType(node));
		return retVal;
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public A inAModuleType(AModuleType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public A outAModuleType(AModuleType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public A caseAReferenceType(AReferenceType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAReferenceType(node));

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			mergeReturns(retVal,node.getType().apply(this));
		}

		mergeReturns(retVal,outAReferenceType(node));
		return retVal;
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public A inAReferenceType(AReferenceType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public A outAReferenceType(AReferenceType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public A caseANullType(ANullType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inANullType(node));


		mergeReturns(retVal,outANullType(node));
		return retVal;
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public A inANullType(ANullType node) throws AnalysisException
	{
		return defaultInPType(node);
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public A outANullType(ANullType node) throws AnalysisException
	{
		return defaultOutPType(node);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public A caseABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inABooleanPrimitiveType(node));


		mergeReturns(retVal,outABooleanPrimitiveType(node));
		return retVal;
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public A inABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException
	{
		return defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public A outABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public A caseAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAStringPrimitiveType(node));


		mergeReturns(retVal,outAStringPrimitiveType(node));
		return retVal;
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public A inAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException
	{
		return defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public A outAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A defaultInSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		return defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A defaultOutSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A defaultSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		return defaultSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A inSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		return defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public A outSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		return defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public A caseARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inARealNumericPrimitiveType(node));


		mergeReturns(retVal,outARealNumericPrimitiveType(node));
		return retVal;
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public A inARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException
	{
		return defaultInSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public A outARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException
	{
		return defaultOutSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public A caseAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAIntNumericPrimitiveType(node));


		mergeReturns(retVal,outAIntNumericPrimitiveType(node));
		return retVal;
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public A inAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException
	{
		return defaultInSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public A outAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException
	{
		return defaultOutSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public A caseAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		A retVal = createNewReturnValue(node);
		mergeReturns(retVal,inAUIntNumericPrimitiveType(node));


		mergeReturns(retVal,outAUIntNumericPrimitiveType(node));
		return retVal;
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public A inAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException
	{
		return defaultInSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public A outAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException
	{
		return defaultOutSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public A defaultOutINode(INode node) throws AnalysisException
	{
		return createNewReturnValue(node);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public A defaultInINode(INode node) throws AnalysisException
	{
		return createNewReturnValue(node);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public A defaultINode(INode node) throws AnalysisException
	{
		return createNewReturnValue(node);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A defaultOutIToken(IToken node) throws AnalysisException
	{
		return createNewReturnValue(node);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A defaultInIToken(IToken node) throws AnalysisException
	{
		return createNewReturnValue(node);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public A defaultIToken(IToken node) throws AnalysisException
	{
		return createNewReturnValue(node);
	}



	public abstract A mergeReturns(A original, A new_);


	public abstract A createNewReturnValue(INode node) throws AnalysisException;


	public abstract A createNewReturnValue(Object node) throws AnalysisException;


}
