/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStmBase;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import org.intocps.maestro.ast.node.PStm;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AWhileStm extends PStmBase
{
	private static final long serialVersionUID = 1L;

	private PExp _test;
	private PStm _body;

	/**
	* Creates a new complete constructor {@code AWhileStm} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param test_ the {@link PExp} node for the {@code test} child of this {@link AWhileStm} node
	* @param body_ the {@link PStm} node for the {@code body} child of this {@link AWhileStm} node
	*/
	public AWhileStm(PExp test_, PStm body_)
	{
		super();
		this.setTest(test_);
		this.setBody(body_);

	}


	/**
	 * Creates a new default constructor {@link AWhileStm} node with no children.
	 */
	public AWhileStm()
	{

	}




	public String toString()
	{
		return "" + "while( "+_test+" ) "+_body+"";
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AWhileStm} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AWhileStm} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AWhileStm} node
	 */
	public void removeChild(INode child)
	{
		if (this._test == child) {
			this._test = null;
			return;
		}

		if (this._body == child) {
			this._body = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_test",this._test);
		fields.put("_body",this._body);
		return fields;
	}


	/**
	 * Returns a deep clone of this {@link AWhileStm} node.
	 * @return a deep clone of this {@link AWhileStm} node
	 */
	public AWhileStm clone()
	{
		return new AWhileStm(
			cloneNode(_test),
			cloneNode(_body)
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a deep clone of this {@link AWhileStm} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AWhileStm} node
	 */
	public AWhileStm clone(Map<INode,INode> oldToNewMap)
	{
		AWhileStm node = new AWhileStm(
			cloneNode(_test, oldToNewMap),
			cloneNode(_body, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AWhileStm)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Sets the {@code _test} child of this {@link AWhileStm} node.
	 * @param value the new {@code _test} child of this {@link AWhileStm} node
	*/
	public void setTest(PExp value)
	{
		if (this._test != null) {
			this._test.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._test = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _test} child of this {@link AWhileStm} node
	*/
	public PExp getTest()
	{
		return this._test;
	}


	/**
	 * Sets the {@code _body} child of this {@link AWhileStm} node.
	 * @param value the new {@code _body} child of this {@link AWhileStm} node
	*/
	public void setBody(PStm value)
	{
		if (this._body != null) {
			this._body.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._body = value;

	}


	/**
	 * @return the {@link PStm} node which is the {@code _body} child of this {@link AWhileStm} node
	*/
	public PStm getBody()
	{
		return this._body;
	}


	/**
	* Calls the {@link IAnalysis#caseAWhileStm(AWhileStm)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AWhileStm} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAWhileStm(this);
	}


	/**
	* Calls the {@link IAnswer#caseAWhileStm(AWhileStm)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AWhileStm} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAWhileStm(this);
	}


	/**
	* Calls the {@link IQuestion#caseAWhileStm(AWhileStm, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AWhileStm} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAWhileStm(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAWhileStm(AWhileStm, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AWhileStm} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAWhileStm(this,question);
	}



}
