/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.PDeclarationBase;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PType;

public class AVariableDeclaration
extends PDeclarationBase {
    private static final long serialVersionUID = 1L;
    private PType _type;
    private NodeList<PExp> _size = new NodeList(this);
    private PInitializer _initializer;

    public AVariableDeclaration() {
    }

    public AVariableDeclaration(LexIdentifier name_, PType type_, List<? extends PExp> size_, PInitializer initializer_) {
        super(name_);
        this.setType(type_);
        this.setSize(size_);
        this.setInitializer(initializer_);
    }

    @Override
    public String toString() {
        return this._type + " " + this._name + (this._size == null || this._size.isEmpty() ? "" : this._size.stream().map(s -> s.toString()).collect(Collectors.joining("][", "[", "]"))) + (String)(this._initializer == null ? "" : " = " + this._initializer);
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_type", this._type);
        fields.put("_size", this._size);
        fields.put("_initializer", this._initializer);
        return fields;
    }

    @Override
    public AVariableDeclaration clone() {
        return new AVariableDeclaration(this._name, this.cloneNode(this._type), this.cloneList(this._size), this.cloneNode(this._initializer));
    }

    @Override
    public void removeChild(INode child) {
        if (this._type == child) {
            this._type = null;
            return;
        }
        if (this._size.remove(child)) {
            return;
        }
        if (this._initializer == child) {
            this._initializer = null;
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof AVariableDeclaration) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public AVariableDeclaration clone(Map<INode, INode> oldToNewMap) {
        AVariableDeclaration node = new AVariableDeclaration(this._name, this.cloneNode(this._type, oldToNewMap), this.cloneList(this._size, oldToNewMap), this.cloneNode(this._initializer, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    public void setType(PType value) {
        if (this._type != null) {
            this._type.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._type = value;
    }

    public PType getType() {
        return this._type;
    }

    public void setSize(List<? extends PExp> value) {
        if (this._size.equals(value)) {
            return;
        }
        this._size.clear();
        if (value != null) {
            this._size.addAll(value);
        }
    }

    public LinkedList<PExp> getSize() {
        return this._size;
    }

    public void setInitializer(PInitializer value) {
        if (this._initializer != null) {
            this._initializer.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._initializer = value;
    }

    public PInitializer getInitializer() {
        return this._initializer;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseAVariableDeclaration(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseAVariableDeclaration(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseAVariableDeclaration(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseAVariableDeclaration(this, question);
    }
}

