/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PStmBase;

public class ABlockStm
extends PStmBase {
    private static final long serialVersionUID = 1L;
    private NodeList<PStm> _body = new NodeList(this);

    public ABlockStm() {
    }

    public ABlockStm(List<? extends PStm> body_) {
        this.setBody(body_);
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof ABlockStm) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void removeChild(INode child) {
        if (this._body.remove(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public String toString() {
        return "\n{" + this._body.stream().map(Object::toString).collect(Collectors.joining(";\n", "\n", ";\n")) + "}\n";
    }

    @Override
    public ABlockStm clone() {
        return new ABlockStm(this.cloneList(this._body));
    }

    @Override
    public ABlockStm clone(Map<INode, INode> oldToNewMap) {
        ABlockStm node = new ABlockStm(this.cloneList(this._body, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_body", this._body);
        return fields;
    }

    public void setBody(List<? extends PStm> value) {
        if (this._body.equals(value)) {
            return;
        }
        this._body.clear();
        if (value != null) {
            this._body.addAll(value);
        }
    }

    public LinkedList<PStm> getBody() {
        return this._body;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseABlockStm(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseABlockStm(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseABlockStm(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseABlockStm(this, question);
    }
}

