/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.intocps.maestro.ast.node.INode;

public class NodeList<E extends INode>
extends LinkedList<E> {
    INode parent;

    protected void setParent(INode n) {
        INode p = n.parent();
        if (p != null) {
            p.removeChild(n);
        }
        n.parent(this.parent);
    }

    private NodeList() {
        this.parent = null;
    }

    public NodeList(INode parent) {
        this.parent = parent;
    }

    public NodeList(INode parent, Collection<? extends E> c) {
        this(parent);
        this.addAll(c);
    }

    @Override
    public boolean add(E o) {
        this.setParent((INode)o);
        return super.add(o);
    }

    @Override
    public void addFirst(E o) {
        this.setParent((INode)o);
        super.addFirst(o);
    }

    @Override
    public void addLast(E o) {
        this.setParent((INode)o);
        super.addLast(o);
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o) && ((INode)o).parent() == this.parent) {
            ((INode)o).parent(null);
            return true;
        }
        return false;
    }

    @Override
    public E removeFirst() {
        INode o = (INode)super.removeFirst();
        if (o.parent() == this.parent) {
            o.parent(null);
        }
        return (E)o;
    }

    @Override
    public E removeLast() {
        INode o = (INode)super.removeLast();
        if (o.parent() == this.parent) {
            o.parent(null);
        }
        return (E)o;
    }

    @Override
    public void clear() {
        for (INode o : this) {
            if (o.parent() != this.parent) continue;
            o.parent(null);
        }
        super.clear();
    }

    @Override
    public Object clone() {
        LinkedList<INode> clone = new LinkedList<INode>();
        for (INode n : this) {
            clone.add((INode)n.clone());
        }
        return clone;
    }

    @Override
    public E remove(int index) {
        INode old = (INode)super.remove(index);
        if (old.parent() == this.parent) {
            old.parent(null);
        }
        return (E)old;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        if (c == this) {
            return false;
        }
        int i = 0;
        for (INode elem : this) {
            if (i >= index) break;
            if (c.contains(elem)) {
                --index;
            }
            ++i;
        }
        ArrayList<E> copy = new ArrayList<E>(c);
        for (INode o : copy) {
            this.setParent(o);
        }
        return super.addAll(index, copy);
    }

    @Override
    public void add(int index, E o) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int i = 0;
        for (INode elem : this) {
            if (i >= index) break;
            if (elem == o) {
                --index;
            }
            ++i;
        }
        this.setParent((INode)o);
        super.add(index, o);
    }

    @Override
    public E set(int index, E o) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int i = 0;
        for (INode elem : this) {
            if (i == index && elem == o) {
                return o;
            }
            if (i >= index) break;
            if (elem == o) {
                --index;
            }
            ++i;
        }
        this.setParent((INode)o);
        INode old = (INode)super.set(index, o);
        if (old.parent() == this.parent) {
            old.parent(null);
        }
        return (E)old;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new NodeListIterator(super.listIterator(index));
    }

    private class NodeListIterator
    implements ListIterator<E> {
        ListIterator<E> iterator;
        E last_returned;

        NodeListIterator(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            this.last_returned = (INode)this.iterator.next();
            return this.last_returned;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E previous() {
            this.last_returned = (INode)this.iterator.previous();
            return this.last_returned;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (this.last_returned.parent() == NodeList.this.parent) {
                this.last_returned.parent(null);
            }
        }

        @Override
        public void set(E o) {
            this.iterator.set(o);
            if (o != this.last_returned) {
                NodeList.this.setParent((INode)o);
                if (this.last_returned.parent() == NodeList.this.parent) {
                    this.last_returned.parent(null);
                }
                this.last_returned = o;
            }
        }

        @Override
        public void add(E o) {
            this.iterator.add(o);
            NodeList.this.setParent((INode)o);
        }
    }
}

