/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast;


import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.PDeclarationBase;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.AVariableDeclaration;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AVariableDeclaration extends PDeclarationBase
{
	private static final long serialVersionUID = 1L;

	private PType _type;
	private NodeList<PExp> _size = new NodeList<PExp>(this);
	private PInitializer _initializer;

	/**
	 * Creates a new default constructor {@link AVariableDeclaration} node with no children.
	 */
	public AVariableDeclaration()
	{

	}



	/**
	* Creates a new complete constructor {@code AVariableDeclaration} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param type_ the {@link PType} node for the {@code type} child of this {@link AVariableDeclaration} node
	* @param size_ the {@link NodeList} node for the {@code size} child of this {@link AVariableDeclaration} node
	* @param initializer_ the {@link PInitializer} node for the {@code initializer} child of this {@link AVariableDeclaration} node
	*/
	public AVariableDeclaration(LexIdentifier name_, PType type_, List<? extends PExp> size_, PInitializer initializer_)
	{
		super(name_);
		this.setType(type_);
		this.setSize(size_);
		this.setInitializer(initializer_);

	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_type",this._type);
		fields.put("_size",this._size);
		fields.put("_initializer",this._initializer);
		return fields;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AVariableDeclaration} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AVariableDeclaration} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AVariableDeclaration} node
	 */
	public void removeChild(INode child)
	{
		if (this._type == child) {
			this._type = null;
			return;
		}

		if (this._size.remove(child)) {
				return;
		}
		if (this._initializer == child) {
			this._initializer = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}



	public String toString()
	{
		return "" + _type+ " "+ _name + ""+(_size==null || _size.isEmpty()?"":_size.stream().map(s->s.toString()).collect(Collectors.joining("][","[","]")))+ ( _initializer ==null?"":" = " +_initializer);
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AVariableDeclaration)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Creates a deep clone of this {@link AVariableDeclaration} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AVariableDeclaration} node
	 */
	public AVariableDeclaration clone(Map<INode,INode> oldToNewMap)
	{
		AVariableDeclaration node = new AVariableDeclaration(
			_name,
			cloneNode(_type, oldToNewMap),
			cloneList(_size, oldToNewMap),
			cloneNode(_initializer, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Returns a deep clone of this {@link AVariableDeclaration} node.
	 * @return a deep clone of this {@link AVariableDeclaration} node
	 */
	public AVariableDeclaration clone()
	{
		return new AVariableDeclaration(
			_name,
			cloneNode(_type),
			cloneList(_size),
			cloneNode(_initializer)
		);
	}


	/**
	 * Sets the {@code _type} child of this {@link AVariableDeclaration} node.
	 * @param value the new {@code _type} child of this {@link AVariableDeclaration} node
	*/
	public void setType(PType value)
	{
		if (this._type != null) {
			this._type.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._type = value;

	}


	/**
	 * @return the {@link PType} node which is the {@code _type} child of this {@link AVariableDeclaration} node
	*/
	public PType getType()
	{
		return this._type;
	}


	/**
	 * Sets the {@code _size} child of this {@link AVariableDeclaration} node.
	 * @param value the new {@code _size} child of this {@link AVariableDeclaration} node
	*/
	public void setSize(List<? extends PExp> value)
	{
		if (this._size.equals(value)) {
			return;
		}
		this._size.clear();
		if (value != null) {
			this._size.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _size} child of this {@link AVariableDeclaration} node
	*/
	public LinkedList<PExp> getSize()
	{
		return this._size;
	}


	/**
	 * Sets the {@code _initializer} child of this {@link AVariableDeclaration} node.
	 * @param value the new {@code _initializer} child of this {@link AVariableDeclaration} node
	*/
	public void setInitializer(PInitializer value)
	{
		if (this._initializer != null) {
			this._initializer.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._initializer = value;

	}


	/**
	 * @return the {@link PInitializer} node which is the {@code _initializer} child of this {@link AVariableDeclaration} node
	*/
	public PInitializer getInitializer()
	{
		return this._initializer;
	}


	/**
	* Calls the {@link IAnalysis#caseAVariableDeclaration(AVariableDeclaration)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AVariableDeclaration} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAVariableDeclaration(this);
	}


	/**
	* Calls the {@link IAnswer#caseAVariableDeclaration(AVariableDeclaration)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AVariableDeclaration} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAVariableDeclaration(this);
	}


	/**
	* Calls the {@link IQuestion#caseAVariableDeclaration(AVariableDeclaration, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AVariableDeclaration} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAVariableDeclaration(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAVariableDeclaration(AVariableDeclaration, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AVariableDeclaration} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAVariableDeclaration(this,question);
	}



}
