/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.PStateDesignatorBase;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AArrayStateDesignator extends PStateDesignatorBase
{
	private static final long serialVersionUID = 1L;

	private PStateDesignator _target;
	private PExp _exp;

	/**
	* Creates a new complete constructor {@code AArrayStateDesignator} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param target_ the {@link PStateDesignator} node for the {@code target} child of this {@link AArrayStateDesignator} node
	* @param exp_ the {@link PExp} node for the {@code exp} child of this {@link AArrayStateDesignator} node
	*/
	public AArrayStateDesignator(PStateDesignator target_, PExp exp_)
	{
		super();
		this.setTarget(target_);
		this.setExp(exp_);

	}


	/**
	 * Creates a new default constructor {@link AArrayStateDesignator} node with no children.
	 */
	public AArrayStateDesignator()
	{

	}



	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_target",this._target);
		fields.put("_exp",this._exp);
		return fields;
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AArrayStateDesignator)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Returns a deep clone of this {@link AArrayStateDesignator} node.
	 * @return a deep clone of this {@link AArrayStateDesignator} node
	 */
	public AArrayStateDesignator clone()
	{
		return new AArrayStateDesignator(
			cloneNode(_target),
			cloneNode(_exp)
		);
	}



	public String toString()
	{
		return "" + _target+"["+_exp+"]";
	}


	/**
	 * Creates a deep clone of this {@link AArrayStateDesignator} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AArrayStateDesignator} node
	 */
	public AArrayStateDesignator clone(Map<INode,INode> oldToNewMap)
	{
		AArrayStateDesignator node = new AArrayStateDesignator(
			cloneNode(_target, oldToNewMap),
			cloneNode(_exp, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AArrayStateDesignator} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AArrayStateDesignator} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AArrayStateDesignator} node
	 */
	public void removeChild(INode child)
	{
		if (this._target == child) {
			this._target = null;
			return;
		}

		if (this._exp == child) {
			this._exp = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Sets the {@code _target} child of this {@link AArrayStateDesignator} node.
	 * @param value the new {@code _target} child of this {@link AArrayStateDesignator} node
	*/
	public void setTarget(PStateDesignator value)
	{
		if (this._target != null) {
			this._target.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._target = value;

	}


	/**
	 * @return the {@link PStateDesignator} node which is the {@code _target} child of this {@link AArrayStateDesignator} node
	*/
	public PStateDesignator getTarget()
	{
		return this._target;
	}


	/**
	 * Sets the {@code _exp} child of this {@link AArrayStateDesignator} node.
	 * @param value the new {@code _exp} child of this {@link AArrayStateDesignator} node
	*/
	public void setExp(PExp value)
	{
		if (this._exp != null) {
			this._exp.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._exp = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _exp} child of this {@link AArrayStateDesignator} node
	*/
	public PExp getExp()
	{
		return this._exp;
	}


	/**
	* Calls the {@link IAnalysis#caseAArrayStateDesignator(AArrayStateDesignator)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AArrayStateDesignator} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAArrayStateDesignator(this);
	}


	/**
	* Calls the {@link IAnswer#caseAArrayStateDesignator(AArrayStateDesignator)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AArrayStateDesignator} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAArrayStateDesignator(this);
	}


	/**
	* Calls the {@link IQuestion#caseAArrayStateDesignator(AArrayStateDesignator, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AArrayStateDesignator} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAArrayStateDesignator(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAArrayStateDesignator(AArrayStateDesignator, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AArrayStateDesignator} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAArrayStateDesignator(this,question);
	}



}
