/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast;


import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.PDeclarationBase;
import java.util.List;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.AModuleDeclaration;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AModuleDeclaration extends PDeclarationBase
{
	private static final long serialVersionUID = 1L;

	private NodeList<AFunctionDeclaration> _functions = new NodeList<AFunctionDeclaration>(this);

	/**
	* Creates a new complete constructor {@code AModuleDeclaration} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param name_ the {@link LexIdentifier} node for the {@code name} child of this {@link AModuleDeclaration} node
	* @param functions_ the {@link NodeList} node for the {@code functions} child of this {@link AModuleDeclaration} node
	*/
	public AModuleDeclaration(LexIdentifier name_, List<? extends AFunctionDeclaration> functions_)
	{
		super(null);
		this.setName(name_);
		this.setFunctions(functions_);

	}


	/**
	 * Creates a new default constructor {@link AModuleDeclaration} node with no children.
	 */
	public AModuleDeclaration()
	{

	}



	/**
	 * Returns a deep clone of this {@link AModuleDeclaration} node.
	 * @return a deep clone of this {@link AModuleDeclaration} node
	 */
	public AModuleDeclaration clone()
	{
		return new AModuleDeclaration(
			(LexIdentifier)_name,
			cloneList(_functions)
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AModuleDeclaration)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AModuleDeclaration} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AModuleDeclaration} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AModuleDeclaration} node
	 */
	public void removeChild(INode child)
	{
		if (this._functions.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_name",this._name);
		fields.put("_functions",this._functions);
		return fields;
	}



	public String toString()
	{
		return "" + _name+" {"+ _functions.stream().map(Object::toString).collect(Collectors.joining(";\n","\n","\n"))+"}";
	}


	/**
	 * Creates a deep clone of this {@link AModuleDeclaration} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AModuleDeclaration} node
	 */
	public AModuleDeclaration clone(Map<INode,INode> oldToNewMap)
	{
		AModuleDeclaration node = new AModuleDeclaration(
			(LexIdentifier)_name,
			cloneList(_functions, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Sets the {@code _name} child of this {@link AModuleDeclaration} node.
	 * @param value the new {@code _name} child of this {@link AModuleDeclaration} node
	*/
	public void setName(LexIdentifier value)
	{
		this._name = value;
	}


	/**
	 * @return the {@link LexIdentifier} node which is the {@code _name} child of this {@link AModuleDeclaration} node
	*/
	public LexIdentifier getName()
	{
		return (LexIdentifier)this._name;
	}


	/**
	 * Sets the {@code _functions} child of this {@link AModuleDeclaration} node.
	 * @param value the new {@code _functions} child of this {@link AModuleDeclaration} node
	*/
	public void setFunctions(List<? extends AFunctionDeclaration> value)
	{
		if (this._functions.equals(value)) {
			return;
		}
		this._functions.clear();
		if (value != null) {
			this._functions.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _functions} child of this {@link AModuleDeclaration} node
	*/
	public LinkedList<AFunctionDeclaration> getFunctions()
	{
		return this._functions;
	}


	/**
	* Calls the {@link IAnalysis#caseAModuleDeclaration(AModuleDeclaration)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AModuleDeclaration} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAModuleDeclaration(this);
	}


	/**
	* Calls the {@link IAnswer#caseAModuleDeclaration(AModuleDeclaration)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AModuleDeclaration} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAModuleDeclaration(this);
	}


	/**
	* Calls the {@link IQuestion#caseAModuleDeclaration(AModuleDeclaration, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AModuleDeclaration} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAModuleDeclaration(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAModuleDeclaration(AModuleDeclaration, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AModuleDeclaration} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAModuleDeclaration(this,question);
	}



}
