/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class ALoadExp extends PExpBase
{
	private static final long serialVersionUID = 1L;

	private NodeList<PExp> _args = new NodeList<PExp>(this);

	/**
	 * Creates a new default constructor {@link ALoadExp} node with no children.
	 */
	public ALoadExp()
	{

	}



	/**
	* Creates a new complete constructor {@code ALoadExp} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param args_ the {@link NodeList} node for the {@code args} child of this {@link ALoadExp} node
	*/
	public ALoadExp(List<? extends PExp> args_)
	{
		super();
		this.setArgs(args_);

	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof ALoadExp)		{
			 return toString().equals(o.toString());
		}
		return false;
	}



	public String toString()
	{
		return "" + "load("+ _args.stream().map(Object::toString).collect(Collectors.joining(", "))+")";
	}


	/**
	 * Returns a deep clone of this {@link ALoadExp} node.
	 * @return a deep clone of this {@link ALoadExp} node
	 */
	public ALoadExp clone()
	{
		return new ALoadExp(
			cloneList(_args)
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a deep clone of this {@link ALoadExp} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link ALoadExp} node
	 */
	public ALoadExp clone(Map<INode,INode> oldToNewMap)
	{
		ALoadExp node = new ALoadExp(
			cloneList(_args, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_args",this._args);
		return fields;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link ALoadExp} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link ALoadExp} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link ALoadExp} node
	 */
	public void removeChild(INode child)
	{
		if (this._args.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	 * Sets the {@code _args} child of this {@link ALoadExp} node.
	 * @param value the new {@code _args} child of this {@link ALoadExp} node
	*/
	public void setArgs(List<? extends PExp> value)
	{
		if (this._args.equals(value)) {
			return;
		}
		this._args.clear();
		if (value != null) {
			this._args.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _args} child of this {@link ALoadExp} node
	*/
	public LinkedList<PExp> getArgs()
	{
		return this._args;
	}


	/**
	* Calls the {@link IAnalysis#caseALoadExp(ALoadExp)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link ALoadExp} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseALoadExp(this);
	}


	/**
	* Calls the {@link IAnswer#caseALoadExp(ALoadExp)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link ALoadExp} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseALoadExp(this);
	}


	/**
	* Calls the {@link IQuestion#caseALoadExp(ALoadExp, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link ALoadExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseALoadExp(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseALoadExp(ALoadExp, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link ALoadExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseALoadExp(this,question);
	}



}
