/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PExpBase;
import java.util.Map;
import java.lang.Boolean;
import java.util.HashMap;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.SBinaryExp;
import org.intocps.maestro.ast.node.PExp;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public abstract class SBinaryExpBase extends PExpBase implements SBinaryExp
{
	private static final long serialVersionUID = 1L;

	protected PExp _left;
	protected PExp _right;

	/**
	 * Creates a new default constructor {@link SBinaryExpBase} node with no children.
	 */
	public SBinaryExpBase()
	{

	}



	/**
	* Creates a new complete constructor {@code SBinaryExpBase} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param left_ the {@link PExp} node for the {@code left} child of this {@link SBinaryExpBase} node
	* @param right_ the {@link PExp} node for the {@code right} child of this {@link SBinaryExpBase} node
	*/
	public SBinaryExpBase(PExp left_, PExp right_)
	{
		super();
		this.setLeft(left_);
		this.setRight(right_);

	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_left",this._left);
		fields.put("_right",this._right);
		return fields;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof SBinaryExpBase)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link SBinaryExpBase} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link SBinaryExpBase} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link SBinaryExpBase} node
	 */
	public void removeChild(INode child)
	{
		if (this._left == child) {
			this._left = null;
			return;
		}

		if (this._right == child) {
			this._right = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a deep clone of this {@link SBinaryExpBase} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link SBinaryExpBase} node
	 */
	@Override
	public abstract SBinaryExp clone(Map<INode,INode> oldToNewMap);


	public String toString()
	{
		return "" + _left+""+_right;
	}


	/**
	 * Returns a deep clone of this {@link SBinaryExpBase} node.
	 * @return a deep clone of this {@link SBinaryExpBase} node
	 */
	@Override
	public abstract SBinaryExp clone();

	/**
	 * Sets the {@code _left} child of this {@link SBinaryExpBase} node.
	 * @param value the new {@code _left} child of this {@link SBinaryExpBase} node
	*/
	public void setLeft(PExp value)
	{
		if (this._left != null) {
			this._left.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._left = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _left} child of this {@link SBinaryExpBase} node
	*/
	public PExp getLeft()
	{
		return this._left;
	}


	/**
	 * Sets the {@code _right} child of this {@link SBinaryExpBase} node.
	 * @param value the new {@code _right} child of this {@link SBinaryExpBase} node
	*/
	public void setRight(PExp value)
	{
		if (this._right != null) {
			this._right.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._right = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _right} child of this {@link SBinaryExpBase} node
	*/
	public PExp getRight()
	{
		return this._right;
	}



}
