/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.PDeclarationBase;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.node.PType;

public class AFunctionDeclaration
extends PDeclarationBase {
    private static final long serialVersionUID = 1L;
    private PType _returnType;
    private NodeList<AFormalParameter> _formals = new NodeList(this);

    public AFunctionDeclaration(LexIdentifier name_, PType returnType_, List<? extends AFormalParameter> formals_) {
        super(name_);
        this.setReturnType(returnType_);
        this.setFormals(formals_);
    }

    public AFunctionDeclaration() {
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_returnType", this._returnType);
        fields.put("_formals", this._formals);
        return fields;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public AFunctionDeclaration clone(Map<INode, INode> oldToNewMap) {
        AFunctionDeclaration node = new AFunctionDeclaration(this._name, this.cloneNode(this._returnType, oldToNewMap), this.cloneList(this._formals, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public AFunctionDeclaration clone() {
        return new AFunctionDeclaration(this._name, this.cloneNode(this._returnType), this.cloneList(this._formals));
    }

    @Override
    public void removeChild(INode child) {
        if (this._returnType == child) {
            this._returnType = null;
            return;
        }
        if (this._formals.remove(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public String toString() {
        return this._returnType + " " + this._name + "(" + this._formals.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof AFunctionDeclaration) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public void setReturnType(PType value) {
        if (this._returnType != null) {
            this._returnType.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._returnType = value;
    }

    public PType getReturnType() {
        return this._returnType;
    }

    public void setFormals(List<? extends AFormalParameter> value) {
        if (this._formals.equals(value)) {
            return;
        }
        this._formals.clear();
        if (value != null) {
            this._formals.addAll(value);
        }
    }

    public LinkedList<AFormalParameter> getFormals() {
        return this._formals;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseAFunctionDeclaration(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseAFunctionDeclaration(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseAFunctionDeclaration(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseAFunctionDeclaration(this, question);
    }
}

