/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.node.PCompilationUnitBase;
import org.intocps.maestro.ast.node.PStm;

public class ASimulationSpecificationCompilationUnit
extends PCompilationUnitBase {
    private static final long serialVersionUID = 1L;
    private PStm _body;
    private List<? extends LexIdentifier> _imports = new Vector<LexIdentifier>();
    private List<? extends LexIdentifier> _framework = new Vector<LexIdentifier>();
    private NodeList<AConfigFramework> _frameworkConfigs = new NodeList(this);

    public ASimulationSpecificationCompilationUnit() {
    }

    public ASimulationSpecificationCompilationUnit(PStm body_, List<? extends LexIdentifier> imports_, List<? extends LexIdentifier> framework_, List<? extends AConfigFramework> frameworkConfigs_) {
        this.setBody(body_);
        this.setImports(imports_);
        this.setFramework(framework_);
        this.setFrameworkConfigs(frameworkConfigs_);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ASimulationSpecificationCompilationUnit clone(Map<INode, INode> oldToNewMap) {
        ASimulationSpecificationCompilationUnit node = new ASimulationSpecificationCompilationUnit(this.cloneNode(this._body, oldToNewMap), this.cloneListExternal(this._imports, oldToNewMap), this.cloneListExternal(this._framework, oldToNewMap), this.cloneList(this._frameworkConfigs, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public void removeChild(INode child) {
        if (this._body == child) {
            this._body = null;
            return;
        }
        if (this._frameworkConfigs.remove(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof ASimulationSpecificationCompilationUnit) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_body", this._body);
        fields.put("_imports", this._imports);
        fields.put("_framework", this._framework);
        fields.put("_frameworkConfigs", this._frameworkConfigs);
        return fields;
    }

    @Override
    public String toString() {
        return "simulation " + this._imports.stream().map(s -> "import " + s.toString()).collect(Collectors.joining(";\n", "\n", ";\n")) + (this._framework.isEmpty() ? "" : this._framework.stream().map(s -> "\"" + s.getText() + "\"").collect(Collectors.joining(",", "\n@Framework(", ");\n"))) + (this._frameworkConfigs.isEmpty() ? "" : this._frameworkConfigs.stream().map(s -> s.toString()).collect(Collectors.joining(";", "\n;", "\n"))) + this._body;
    }

    @Override
    public ASimulationSpecificationCompilationUnit clone() {
        return new ASimulationSpecificationCompilationUnit(this.cloneNode(this._body), this.cloneListExternal(this._imports), this.cloneListExternal(this._framework), this.cloneList(this._frameworkConfigs));
    }

    public void setBody(PStm value) {
        if (this._body != null) {
            this._body.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._body = value;
    }

    public PStm getBody() {
        return this._body;
    }

    public void setImports(List<? extends LexIdentifier> value) {
        this._imports = value;
    }

    public List<? extends LexIdentifier> getImports() {
        return this._imports;
    }

    public void setFramework(List<? extends LexIdentifier> value) {
        this._framework = value;
    }

    public List<? extends LexIdentifier> getFramework() {
        return this._framework;
    }

    public void setFrameworkConfigs(List<? extends AConfigFramework> value) {
        if (this._frameworkConfigs.equals(value)) {
            return;
        }
        this._frameworkConfigs.clear();
        if (value != null) {
            this._frameworkConfigs.addAll(value);
        }
    }

    public LinkedList<AConfigFramework> getFrameworkConfigs() {
        return this._frameworkConfigs;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseASimulationSpecificationCompilationUnit(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseASimulationSpecificationCompilationUnit(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseASimulationSpecificationCompilationUnit(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseASimulationSpecificationCompilationUnit(this, question);
    }
}

